% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{coef.transreg}
\alias{coef.transreg}
\title{Extract Coefficients}
\usage{
\method{coef}{transreg}(object, stack = NULL, ...)
}
\arguments{
\item{object}{object of class \code{transreg}}

\item{stack}{character "sta" (standard stacking) or "sim" (simultaneous stacking)}

\item{...}{(not applicable)}
}
\value{
Returns estimated coefficients.
The output is a list with two slots:
slot \code{alpha} with the estimated intercept (scalar),
and slot \code{beta} with the estimated slopes (vector).
}
\description{
Extracts coefficients
from an object of class \link{transreg}.
}
\examples{
#--- simulation ---
set.seed(1)
n <- 100; p <- 500
X <- matrix(rnorm(n=n*p),nrow=n,ncol=p)
beta <- rnorm(p)
prior <- beta + rnorm(p)
y <- X \%*\% beta

#--- glmnet (without prior effects) ---
object <- glmnet::cv.glmnet(y=y,x=X,alpha=0)
beta_hat <- coef(object,s="lambda.min")[-1]
mean((beta-beta_hat)^2)

#--- transreg (with prior effects) ---
object <- transreg(y=y,X=X,prior=prior,alpha=0)
beta_hat <- coef(object)$beta
mean((beta-beta_hat)^2) # decrease in MSE?

}
\references{
\href{https://orcid.org/0000-0001-6498-4801}{Armin Rauschenberger},
\href{https://orcid.org/0000-0002-2327-3904}{Zied Landoulsi},
\href{https://orcid.org/0000-0003-4780-8472}{Mark A. van de Wiel},
and
\href{https://orcid.org/0000-0003-3977-7469}{Enrico Glaab}
(2023).
"Penalised regression with multiple sets of prior effects".
\emph{Bioinformatics (In press).}
\doi{10.1093/bioinformatics/btad680}
\email{armin.rauschenberger@uni.lu}
}
\seealso{
Methods for objects of class \link{transreg}
include \code{\link[=coef.transreg]{coef}}
and \code{\link[=predict.transreg]{predict}}.
}
