% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{harmonic_mean}
\alias{harmonic_mean}
\title{Harmonic Mean}
\usage{
harmonic_mean(x, weights = NULL, na.rm = c(TRUE, FALSE))
}
\arguments{
\item{x}{A vector of values to take the harmonic mean for}

\item{weights}{Optional vector of weights.}

\item{na.rm}{remove NAs (default = TRUE).}
}
\value{
\itemize{
\item Harmonic mean of x
}
}
\description{
The harmonic mean is the reciprocal of the arithmetic mean of the reciprocals of the input values.
Common uses include computing the mean of ratios, for instance the average P/E ratio in a portfolio.
Also it is the correct mean for averaging speeds weighted for distance.
}
\examples{
# Harmonic means are suitable for ratios
tmp = c(33/1, 23/1)
harmonic_mean(tmp)

geometric_mean(tmp)
mean(tmp)

# Example with weights
harmonic_mean(c(33/1, 23/1), weights= c(.2, .8))
# If Jack travels outbound at 1 mph, and returns at 10 miles an hour, what is his average speed?
harmonic_mean(c(1,10)) # 1.81 mph

}
\references{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Harmonic_mean}
}
}
\seealso{
\itemize{
\item \code{\link[=geometric_mean]{geometric_mean()}}, \code{\link[=aggregate]{aggregate()}}
}

Other Miscellaneous Stats Functions: 
\code{\link{FishersMethod}()},
\code{\link{SE_from_p}()},
\code{\link{geometric_mean}()},
\code{\link{oddsratio}()},
\code{\link{reliability}()},
\code{\link{umx}},
\code{\link{umxCov2cor}()},
\code{\link{umxHetCor}()},
\code{\link{umxParan}()},
\code{\link{umxWeightedAIC}()},
\code{\link{umx_apply}()},
\code{\link{umx_cor}()},
\code{\link{umx_means}()},
\code{\link{umx_r_test}()},
\code{\link{umx_round}()},
\code{\link{umx_scale}()},
\code{\link{umx_var}()}
}
\concept{Miscellaneous Stats Functions}
