% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generate_discrete_copula_based}
\alias{generate_discrete_copula_based}
\title{Discrete Copula based scores}
\usage{
generate_discrete_copula_based(
  n_voters,
  n_candidates,
  min = 0,
  max = 10,
  margins = list("default"),
  cor_mat = 0
)
}
\arguments{
\item{n_voters}{integer, the number of voters to generate scores for.}

\item{n_candidates}{integer,  The number of candidates to generate scores for.}

\item{min}{The minimum value of the  distribution, by default 0}

\item{max}{The maximum value of the  distribution, by default 10}

\item{margins}{A list of n_candidates cumulative distribution vectors of length (max-min-1) : the last value of the cumulative distribution, 1, should be omitted. By default margin distribution are uniform distributions.}

\item{cor_mat}{A matrix of correlation coefficients between the n_candidates distributions. By default all correlation coefficients are set up alternatively to 0.5 or -0.5.}
}
\value{
A matrix of scores with 'n_candidates' rows and 'n_voters' columns.
}
\description{
This function generates  discrete scores following marginals distributions linked by a copula
#'
}
\examples{
# Example for 3 candidates, binomial distributions
 min=0
 max=7
n_candidates<-3
distribution<-dbinom(x=(min:max), size=max, prob=0.7)
distribution_cumul<-cumsum(distribution)
distribution_cumul<-distribution_cumul[-length(distribution_cumul)]
margins <- matrix(rep(distribution_cumul, n_candidates), ncol=n_candidates)
margins <-as.list(as.data.frame(margins))
cor_mat<-matrix(c(1,0.8,0,0.8,1,0, 0,0,1), ncol=n_candidates)
voting_situation <- generate_discrete_copula_based(10, 3, max=max, margins=margins, cor_mat=cor_mat)
}
