function test89
%TEST89 performance test of complex A*B

% SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2020, All Rights Reserved.
% http://suitesparse.com   See GraphBLAS/Doc/License.txt for license.

if (~GB_mex_have_complex)
    fprintf ('\ntest89: skipped\n') ;
    return ;
end

[save save_chunk] = nthreads_get ;
chunk = 4096 ;
nthreads = feature ('numcores') ;
nthreads_set (nthreads, chunk) ;

rng ('default') ;
Prob = ssget (936) 
A = Prob.A ;
% A = sprandn (1000, 1000, 0.3) ;
[i j x] = find (A) ;
n = size (A,1) ;
nz = length (x) ;
x = x .* (rand (nz,1) + 1i * rand (nz,1)) ;
y = x .* (rand (nz,1) + 1i * rand (nz,1)) ;
A = sparse (i,j,x,n,n) ;
B = sparse (i,j,y,n,n) ;
clear x y i j


for do_real = 0:1

    if (do_real)
        fprintf ('real:\n') ;
        A = real (A) ;
        B = real (B) ;
    else
        fprintf ('complex:\n') ;
    end

    fprintf ('start MATLAB\n') ;
    tic
    C1 = A*B ;
    tm = toc ;
    fprintf ('MATLAB %g\n', tm) ;

        % 1001: Gustavson
        % 1002: heap
        % 1003: dot

    % GraphBLAS is slower than it could be because the complex type is
    % user-defined.  This uses the default method, which selects
    % Gustavson's method:

    C2 = GB_mex_AxB (A, B) ;
    tg = grbresults ;
    err = norm (C1-C2,1)
    fprintf ('GraphBLAS %g speedup %g\n', tg, tm/tg) ;

    % these are expected to be slower still; they do not use the default method
    % (Gustavson) which is selected by the auto-strategy.

    C2 = GB_mex_AxB (A, B, 0, 0, 1002) ;
    tg = grbresults ;
    err = norm (C1-C2,1)
    fprintf ('GraphBLAS %g speedup %g (heap)\n', tg, tm/tg) ;


    C2 = GB_mex_AxB (A, B, 0, 0, 1003) ;
    tg = grbresults ;
    err = norm (C1-C2,1)
    fprintf ('GraphBLAS %g speedup %g (dot)\n', tg, tm/tg) ;

end
nthreads_set (save, save_chunk) ;
