#include "Tower.h"

#include <SDL_stdinc.h>
#include <stddef.h>

#include "Constants.h"
#include "MakeAndPlay.h"
#include "UtilityClass.h"

towerclass::towerclass(void)
{
    minitowermode = false;
    //We create a blank map
    SDL_memset(contents, 0, sizeof(contents));
    SDL_memset(back, 0, sizeof(back));
    SDL_memset(minitower, 0, sizeof(minitower));

    loadbackground();
    loadmap();
}

int towerclass::backat(int xp, int yp, int yoff)
{
    yp = (yp*8 + yoff) / 8;

    if (xp >= 0 && xp < 40)
    {
        yp = POS_MOD(yp, 120);
        return back[TILE_IDX(xp, yp)];
    }
    return 0;
}

int towerclass::at(int xp, int yp, int yoff)
{
    if (minitowermode)
    {
        return miniat(xp, yp, yoff);
    }
    else
    {
        yp = (yp*8 + yoff) / 8;

        yp = POS_MOD(yp, 700);
        if (xp >= 0 && xp < 40)
        {
            return contents[TILE_IDX(xp, yp)];
        }
        else if (xp == -1)
        {
            return contents[TILE_IDX(0, yp)];
        }
        else if (xp == 40)
        {
            return contents[TILE_IDX(39, yp)];
        }
        return 0;
    }
}

int towerclass::miniat(int xp, int yp, int yoff)
{
    yp = (yp*8 + yoff) / 8;

    yp = POS_MOD(yp, 100);
    if (xp >= 0 && xp < 40)
    {
        return minitower[TILE_IDX(xp, yp)];
    }
    else if (xp == -1)
    {
        return minitower[TILE_IDX(0, yp)];
    }
    else if (xp == 40)
    {
        return minitower[TILE_IDX(39, yp)];
    }
    return 0;
}

void towerclass::loadminitower1(void)
{
    //Loads the first minitower into the array.
#if !defined(MAKEANDPLAY)
    static const short tmap[] = {
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,14,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,22,14,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,22,14,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,28,22,14,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,28,28,28,28,22,14,12,12,12,12,12,
    23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    6,6,6,6,6,6,6,6,28,28,28,28,28,28,28,28,28,28,28,28,6,6,6,6,6,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    18,18,18,18,18,18,18,19,28,28,28,28,28,28,28,28,28,28,28,28,17,18,18,18,19,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,15,19,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,15,19,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,15,19,28,28,28,28,28,28,17,18,16,12,12,12,12,12,12,15,19,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,15,19,28,28,28,17,18,16,12,12,12,12,12,12,12,12,12,15,19,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,15,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12,15,19,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,22,14,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,22,14,12,12,12,
    12,12,13,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,7,7,28,28,28,28,28,28,20,12,12,12,
    12,12,21,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,13,23,24,7,7,28,28,28,28,28,28,28,28,20,12,12,12,
    12,12,21,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,13,23,24,7,7,28,28,28,28,28,28,28,28,28,28,20,12,12,12,
    12,12,21,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,13,23,24,7,7,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,
    12,12,21,28,28,28,28,28,28,28,28,20,12,12,12,12,12,13,23,24,7,7,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,
    12,12,21,28,28,28,28,28,28,28,28,20,12,12,12,13,23,24,7,7,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,
    12,12,21,28,28,28,17,19,28,28,28,22,23,23,23,24,7,7,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,12,
    12,12,21,28,28,28,20,21,28,28,28,7,7,7,7,7,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,12,12,12,
    12,12,21,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,12,12,12,12,12,
    12,12,21,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,12,12,12,12,12,12,12,
    12,12,21,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,21,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,13,23,23,23,23,14,12,12,12,12,12,
    12,12,21,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,12,12,13,23,24,7,7,7,7,20,12,12,12,12,12,
    12,12,21,28,28,28,20,15,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,13,23,24,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,21,28,28,28,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,19,28,28,28,28,20,12,12,12,12,12,
    12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,21,28,28,28,28,20,12,12,12,12,12,
    12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,16,12,12,21,28,28,28,28,20,12,12,12,12,12,
    12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,13,23,24,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,24,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,24,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,18,18,18,16,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,23,14,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,17,19,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,22,24,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,23,23,23,23,23,23,23,23,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,6,6,6,6,6,6,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,17,18,18,18,18,18,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,17,19,28,28,28,28,28,0,0,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,22,24,28,28,28,28,28,0,0,28,28,28,28,28,28,28,28,28,0,0,0,20,13,23,23,23,23,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,20,21,28,28,28,28,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,20,21,28,28,28,28,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,20,21,28,28,28,28,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,20,21,28,28,28,28,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,20,21,28,28,28,28,
    12,12,12,12,12,12,12,12,21,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,20,21,28,28,17,18,
    12,12,12,12,12,12,12,12,21,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,20,21,28,28,20,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,17,19,0,0,0,20,21,28,28,22,23,
    12,12,12,12,12,12,12,12,21,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,22,24,0,0,0,20,21,28,28,28,28,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,21,28,28,28,28,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,21,28,28,28,28,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,21,28,28,28,28,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,21,28,28,28,28,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,15,18,18,18,18,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    };

    SDL_memcpy(minitower, tmap, sizeof(minitower));
#endif
}

void towerclass::loadminitower2(void)
{
#if !defined(MAKEANDPLAY)
    static const short tmap[] = {
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,20,12,12,12,12,12,12,12,12,12,12,
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,20,12,12,12,12,12,12,12,12,12,12,
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,20,12,12,12,12,12,12,12,12,12,12,
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,20,13,23,23,23,23,23,23,23,23,23,
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,22,24,28,28,0,0,0,0,0,0,0,
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,20,21,28,28,28,28,28,28,0,0,0,0,0,0,0,
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,22,24,28,28,28,28,28,28,0,0,0,0,0,0,0,
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,20,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,22,24,28,28,28,28,28,28,28,28,28,28,0,17,18,18,18,18,18,
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,28,28,28,28,28,28,28,28,28,28,0,0,0,20,12,12,12,12,12,
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,28,28,28,28,28,28,28,28,28,28,0,0,0,20,12,12,12,12,12,
    12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,11,20,21,10,0,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,
    23,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,11,22,24,10,0,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    18,18,18,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    23,23,23,23,23,23,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,19,0,0,0,0,0,0,20,12,12,12,12,12,
    18,18,18,18,18,19,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,21,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,21,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,21,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,21,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,13,23,23,23,23,23,23,14,13,23,23,23,23,23,23,23,14,12,12,12,12,21,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,9,9,9,9,9,9,22,24,9,9,9,9,9,9,9,22,23,23,23,23,24,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,8,8,0,0,0,0,0,0,0,28,28,28,28,28,6,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,25,27,0,0,0,0,0,0,0,28,28,28,28,28,26,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,9,9,0,0,0,0,0,0,0,28,28,28,28,28,7,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,21,8,8,8,8,8,8,17,18,18,18,19,8,8,8,6,17,18,18,18,18,19,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,15,18,18,18,18,18,18,16,12,12,12,15,18,18,18,18,16,12,12,12,12,21,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,6,6,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,19,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,14,13,23,23,23,24,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,21,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,21,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,22,24,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,25,27,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,17,19,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,20,21,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,20,21,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,21,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,24,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,0,0,28,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,28,28,17,19,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,13,24,0,28,28,28,28,28,28,28,20,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,13,24,0,0,28,28,28,28,28,28,17,16,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,13,24,0,0,0,28,28,28,28,28,28,20,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,13,24,0,0,0,0,28,28,28,28,28,17,16,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,13,24,0,0,0,0,0,28,28,28,28,28,20,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,13,24,0,0,0,0,0,0,28,28,28,28,17,16,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,13,24,0,0,0,0,0,28,28,28,28,28,28,20,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,13,24,0,0,0,0,0,0,28,28,28,28,28,17,16,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,13,24,0,0,0,0,0,0,0,28,28,28,28,28,20,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,13,24,0,0,0,0,0,0,0,0,28,28,28,28,17,16,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    23,23,24,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,17,16,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,20,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,28,28,17,16,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,0,20,12,12,12,12,12,
    0,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    };

    SDL_memcpy(minitower, tmap, sizeof(minitower));
#endif
}


void towerclass::loadbackground(void)
{
    //Loads the background into the array.
    static const short tmap[] = {
    1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,2,0,0,0,0,0,0,0,0,0,0,0,0,5,4,0,0,
    2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,2,0,0,0,0,0,0,0,0,0,0,0,0,5,1,1,4,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,2,0,0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,1,4,
    0,5,4,0,0,0,0,0,0,5,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,2,
    5,1,1,4,0,0,0,0,5,1,1,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,2,0,
    1,1,1,1,4,0,0,5,1,1,1,1,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,0,5,1,1,1,1,1,2,0,0,
    1,1,1,1,1,4,5,1,1,1,1,1,1,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,3,1,1,1,1,1,4,0,0,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,3,1,1,1,1,1,4,0,
    1,1,1,1,1,1,1,1,2,3,1,1,2,3,1,4,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,3,1,1,1,1,1,4,
    1,1,1,1,1,1,1,2,0,0,3,2,0,0,3,2,0,0,0,0,0,0,5,4,5,1,1,4,0,0,0,0,0,0,3,1,1,1,1,1,
    1,1,1,1,1,1,2,0,5,4,0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,0,0,0,0,0,0,3,1,1,1,1,
    1,1,1,1,1,1,4,5,1,2,0,0,0,0,0,0,0,0,0,0,0,3,1,1,1,2,3,1,1,4,0,0,0,0,0,0,3,1,1,1,
    1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,1,4,0,3,1,1,4,0,0,0,0,0,0,3,1,1,
    3,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,1,2,0,5,1,1,1,4,0,0,0,0,0,0,3,1,
    0,3,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,5,4,5,1,1,2,0,0,3,1,1,1,2,0,0,0,0,0,0,0,3,
    0,0,3,1,1,1,4,0,0,0,0,0,5,4,0,0,0,0,5,1,1,1,1,2,0,0,0,0,3,1,2,0,5,4,0,0,0,0,0,0,
    0,0,0,3,1,1,1,4,0,0,0,5,1,2,0,0,0,0,3,1,1,1,1,4,5,4,0,0,5,1,4,5,1,1,4,0,0,0,0,0,
    0,0,0,0,3,1,1,1,4,0,0,3,1,4,0,0,0,0,5,1,1,1,1,1,1,1,4,5,1,1,1,1,1,1,2,0,0,0,0,0,
    0,0,0,0,5,1,1,1,1,4,0,0,3,1,4,5,4,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,
    0,0,0,5,1,1,1,1,1,1,4,0,0,3,1,1,1,1,1,1,1,1,2,3,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,5,
    0,0,5,1,1,1,2,3,1,1,1,4,0,0,3,1,1,1,1,1,1,2,0,0,3,1,1,1,1,1,1,1,4,0,0,0,0,0,5,1,
    0,0,3,1,1,2,0,0,3,1,1,1,4,0,0,3,1,1,1,1,1,4,0,0,0,3,2,3,1,1,1,1,1,4,0,0,0,0,3,1,
    0,0,0,3,2,0,0,0,0,3,2,3,1,4,0,0,3,1,1,1,1,1,4,0,0,0,0,0,3,1,1,2,3,1,4,0,0,0,0,3,
    0,0,0,0,0,0,5,4,0,0,0,0,3,1,4,0,0,3,2,3,1,1,1,4,0,0,0,0,0,3,2,0,0,3,1,4,0,0,0,0,
    0,0,0,0,0,0,3,1,4,0,0,0,0,3,1,4,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0,0,3,2,0,0,0,0,
    0,0,0,0,0,0,5,1,1,4,5,4,0,0,3,2,0,0,0,3,1,1,2,0,0,5,4,0,0,0,0,5,4,0,0,0,0,0,0,0,
    0,0,0,0,0,5,1,1,1,1,1,2,0,0,0,0,0,0,0,0,3,1,4,0,0,3,1,4,0,0,5,1,1,4,0,0,5,4,0,0,
    0,0,0,0,5,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,3,1,4,0,0,3,1,4,5,1,2,3,1,4,5,1,1,4,0,
    0,0,0,5,1,1,1,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,3,1,4,0,0,3,1,1,2,0,0,3,1,1,1,1,1,4,
    0,0,0,3,1,1,2,3,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,3,1,4,0,0,3,2,0,0,0,0,3,1,1,1,1,1,
    4,0,0,0,3,2,0,0,3,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,0,5,1,1,1,1,1,
    1,4,0,0,0,0,0,0,5,1,1,1,1,4,0,0,0,0,5,4,0,0,0,0,0,3,1,4,0,5,4,0,0,5,1,1,1,1,1,1,
    3,1,4,0,0,0,0,5,1,1,1,1,1,1,4,0,0,0,3,1,4,5,4,0,0,5,1,2,0,3,1,4,5,1,1,1,2,3,1,1,
    0,3,1,4,0,0,5,1,1,1,2,3,1,1,2,0,0,0,0,3,1,1,1,4,5,1,2,0,0,0,3,1,1,1,1,2,0,5,1,1,
    0,5,1,1,4,5,1,1,1,2,0,0,3,2,0,0,0,0,0,5,1,1,1,1,1,2,0,0,0,0,0,3,1,1,2,0,5,1,1,1,
    5,1,1,1,1,1,1,1,1,4,5,4,0,0,0,0,0,0,0,3,1,1,1,1,1,4,0,0,0,0,0,5,1,2,0,0,3,1,1,1,
    1,1,1,2,3,1,1,1,1,1,1,1,4,5,4,0,0,5,4,0,3,1,1,1,1,1,4,0,0,0,5,1,2,0,0,0,0,3,1,1,
    1,1,2,0,0,3,1,1,1,1,1,1,1,1,1,4,5,1,2,0,5,1,1,1,2,3,2,0,0,0,3,1,4,0,0,0,0,0,3,1,
    1,2,0,0,0,0,3,1,1,2,3,1,1,1,1,1,1,2,0,5,1,1,1,1,4,0,0,5,4,0,0,3,1,4,0,0,0,0,0,3,
    2,0,0,0,0,0,5,1,2,0,0,3,1,1,1,1,2,0,5,1,1,1,1,1,1,4,5,1,1,4,0,0,3,1,4,0,0,0,0,0,
    0,0,0,0,0,5,1,2,0,0,0,0,3,1,1,1,4,5,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,3,2,0,0,0,0,0,
    0,0,0,0,0,3,2,0,0,0,0,0,0,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,
    0,5,4,0,0,0,0,5,4,0,0,0,0,0,3,1,1,1,1,2,3,1,1,1,1,1,1,2,0,0,5,4,0,0,5,4,0,0,0,5,
    5,1,1,4,0,0,5,1,2,0,0,0,0,0,0,3,1,1,2,0,0,3,1,1,1,1,2,0,0,5,1,1,4,5,1,2,0,0,5,1,
    1,1,1,1,4,5,1,2,0,0,0,0,0,0,0,0,3,2,0,0,0,0,3,1,1,2,0,0,5,1,1,1,1,1,2,0,0,5,1,1,
    1,1,1,1,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,1,4,0,0,3,1,1,1,1,2,0,0,5,1,1,1,
    1,1,1,1,1,1,1,2,0,5,4,0,0,0,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,3,1,1,2,0,0,5,1,1,1,1,
    1,1,1,1,1,1,1,4,5,1,2,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,0,0,3,1,4,0,0,3,1,1,1,1,
    1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,1,2,0,0,5,1,1,4,0,0,3,1,1,1,
    1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,1,2,0,0,5,1,1,1,2,0,0,5,1,1,1,
    3,1,1,1,1,1,1,2,0,0,0,0,0,5,4,0,0,5,1,1,1,1,1,1,1,2,0,0,5,1,1,1,2,0,0,5,1,1,1,1,
    0,3,1,1,1,1,1,4,0,0,5,4,5,1,1,4,5,1,1,1,1,1,1,1,2,0,0,5,1,1,1,2,0,0,5,1,1,1,1,1,
    0,0,3,1,1,1,1,1,4,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,0,0,3,1,1,2,0,0,5,1,1,1,1,1,1,
    0,0,0,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,0,0,3,2,0,0,5,1,1,1,1,1,1,1,
    0,0,0,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,0,0,0,0,0,3,1,1,1,1,1,1,1,
    0,0,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,1,4,0,0,0,0,0,3,1,1,1,1,1,1,
    0,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,1,1,1,1,1,1,2,0,0,3,1,4,0,0,0,0,5,1,2,3,1,1,1,
    5,1,1,1,1,1,1,1,1,1,1,1,2,3,2,0,0,3,1,1,1,1,2,0,0,0,0,3,1,4,0,0,5,1,2,0,0,3,1,1,
    1,1,1,1,1,1,1,1,1,1,1,1,4,0,0,5,4,0,3,1,1,2,0,0,0,0,0,0,3,1,4,5,1,2,0,0,0,0,3,1,
    1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,1,1,4,0,3,1,4,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,3,
    3,1,1,1,1,2,3,1,1,2,3,1,1,1,1,1,1,1,4,0,3,1,4,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,
    0,3,1,1,2,0,0,3,2,0,0,3,1,1,1,1,1,1,2,0,0,3,2,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0,
    0,0,3,2,0,0,0,0,0,0,0,0,3,1,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,5,1,2,3,1,1,1,4,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,0,0,0,0,5,1,2,0,0,3,1,1,1,4,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,5,1,1,1,2,3,1,4,0,0,0,0,0,3,2,0,0,0,0,3,1,1,1,4,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,5,1,1,1,2,0,0,3,1,4,0,0,0,0,0,0,0,0,0,0,0,3,1,1,1,4,0,0,0,0,0,
    0,0,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,3,1,4,0,0,0,0,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,
    0,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,
    0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,3,1,4,0,0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,
    0,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0,5,1,1,4,0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,
    0,0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0,
    0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,5,1,1,1,2,0,0,0,0,0,0,0,0,0,0,
    0,0,5,1,1,1,1,4,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,
    0,5,1,1,1,2,3,1,4,0,0,0,0,0,0,5,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,
    5,1,1,1,2,0,0,3,1,4,0,0,0,0,5,1,1,1,2,3,2,3,2,3,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,0,
    1,1,1,2,0,0,0,5,1,2,0,0,0,5,1,1,1,2,0,0,0,0,0,0,3,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,
    1,1,2,0,0,0,5,1,2,0,0,0,5,1,1,1,1,4,0,0,0,0,0,0,0,3,1,1,1,4,0,0,0,0,0,0,0,0,0,0,
    1,2,0,0,0,0,3,1,4,0,0,5,1,1,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,0,0,0,0,0,0,0,
    2,0,0,0,0,0,0,3,1,4,5,1,1,1,1,1,1,4,0,0,0,0,0,0,5,1,2,3,1,1,1,4,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,3,1,1,1,1,1,1,1,1,1,4,5,4,0,0,0,3,2,0,0,3,1,1,1,4,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,0,0,0,0,
    0,0,0,0,0,0,0,5,1,2,3,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,0,0,0,0,0,
    0,0,0,0,0,0,5,1,1,4,0,3,1,1,1,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,1,1,1,2,0,0,0,0,0,
    0,0,0,0,0,0,3,1,1,1,4,0,3,1,1,1,1,2,0,0,0,5,4,0,0,5,1,1,1,1,1,1,1,2,0,5,4,0,0,0,
    0,0,0,0,0,0,0,3,1,1,2,0,5,1,1,1,1,4,0,0,5,1,2,0,5,1,1,1,1,1,1,1,2,0,5,1,1,4,0,0,
    0,0,0,0,0,0,0,5,1,2,0,5,1,1,1,1,1,1,4,0,3,1,4,5,1,1,1,1,1,1,1,2,0,5,1,1,1,1,4,0,
    0,0,0,0,0,0,5,1,2,0,5,1,1,1,1,1,1,1,1,4,0,3,1,1,1,1,1,1,1,1,2,0,5,1,1,1,1,1,1,4,
    0,0,0,0,0,0,3,2,0,0,3,1,1,1,1,2,3,1,1,1,4,0,3,1,1,1,1,1,1,1,4,0,3,1,1,1,1,1,1,1,
    0,0,5,4,0,0,0,0,0,0,0,3,1,1,2,0,5,1,1,1,2,0,0,3,1,1,1,1,1,1,1,4,0,3,1,1,1,1,1,1,
    0,5,1,1,4,0,0,0,0,0,0,0,3,2,0,5,1,1,1,1,4,0,0,0,3,1,1,1,1,1,1,1,4,0,3,1,1,1,1,2,
    0,3,1,1,1,4,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,0,0,0,3,1,1,1,1,1,1,1,4,5,1,1,1,2,0,
    0,0,3,1,1,1,4,0,0,0,0,0,0,0,3,1,1,1,1,1,1,2,0,5,4,0,3,1,1,1,1,1,1,1,1,1,1,2,0,0,
    0,0,0,3,1,1,1,4,0,0,0,0,0,0,0,3,1,1,1,1,2,0,5,1,2,0,5,1,1,1,1,1,1,1,1,1,2,0,0,0,
    0,0,0,5,1,1,1,2,0,0,0,0,0,0,0,5,1,1,1,1,4,5,1,2,0,5,1,2,3,1,1,1,1,1,1,1,4,0,0,0,
    0,0,5,1,1,1,2,0,5,4,0,0,0,0,5,1,1,1,1,1,1,1,2,0,0,3,2,0,5,1,1,1,1,1,1,1,1,4,0,0,
    0,5,1,1,1,2,0,0,3,1,4,0,0,5,1,1,1,1,1,1,1,2,0,5,4,0,0,0,3,1,1,1,1,1,1,1,1,1,4,0,
    5,1,1,1,2,0,5,4,0,3,1,4,0,3,1,1,1,1,1,1,2,0,5,1,1,4,5,4,0,3,1,1,1,1,2,3,1,1,1,4,
    1,1,1,2,0,5,1,1,4,0,3,1,4,0,3,1,1,1,1,2,0,5,1,1,1,1,1,1,4,5,1,1,1,2,0,0,3,1,1,1,
    1,1,1,4,5,1,1,1,1,4,5,1,1,4,0,3,1,1,1,4,0,3,1,1,1,1,1,1,1,1,1,1,1,4,0,0,0,3,1,1,
    1,1,1,1,1,1,2,3,1,1,1,1,1,1,4,0,3,1,1,1,4,0,3,1,1,1,1,1,1,1,1,1,1,1,4,0,0,5,1,1,
    3,1,1,1,1,1,4,0,3,1,1,1,1,1,1,4,0,3,1,1,1,4,0,3,1,1,1,1,1,2,3,1,1,1,2,0,5,1,1,1,
    0,3,1,1,1,1,1,4,0,3,1,1,1,1,1,1,4,0,3,1,1,2,0,5,1,1,1,1,1,4,0,3,1,1,4,5,1,1,1,1,
    0,0,3,1,1,1,1,1,4,0,3,1,1,1,1,1,1,4,0,3,2,0,5,1,1,1,1,1,1,1,4,0,3,1,1,1,1,1,1,2,
    0,0,0,3,1,1,1,1,1,4,0,3,1,1,1,1,1,1,4,0,0,5,1,1,1,1,1,1,1,1,2,0,5,1,1,1,1,1,2,0,
    0,0,0,0,3,1,1,1,1,2,0,0,3,1,1,1,1,1,1,4,5,1,1,1,1,1,1,1,1,2,0,5,1,1,1,1,1,2,0,0,
    4,0,0,0,0,3,1,1,2,0,5,4,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,5,1,1,1,1,1,2,0,0,0,
    1,4,0,0,0,0,3,2,0,5,1,1,1,2,3,1,1,1,1,1,1,1,1,2,3,1,1,2,0,5,1,1,1,1,1,2,0,0,0,0,
    1,1,4,0,0,0,0,0,5,1,1,1,2,0,5,1,1,1,1,1,1,1,1,4,0,3,2,0,5,1,1,1,1,1,2,0,0,0,0,0,
    1,1,1,4,0,0,0,5,1,1,1,2,0,5,1,2,3,2,3,1,1,1,1,1,4,0,0,0,3,1,1,1,1,2,0,0,0,0,0,0,
    1,1,1,2,0,0,5,1,1,1,2,0,5,1,2,0,0,0,0,3,1,1,1,1,1,4,0,0,0,3,1,1,2,0,0,0,0,0,0,5,
    1,1,2,0,0,5,1,1,1,1,4,0,3,2,0,0,0,0,0,5,1,1,1,1,1,1,4,0,0,0,3,2,0,0,0,0,0,0,5,1,
    1,2,0,0,5,1,1,1,1,1,1,4,0,0,0,0,0,0,5,1,2,3,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,5,1,1,
    1,4,0,0,3,1,1,1,1,1,1,1,4,0,0,0,0,5,1,2,0,0,3,1,1,2,0,0,5,4,0,0,0,0,0,0,5,1,1,1,
    1,1,4,0,0,3,1,1,1,1,1,1,1,4,0,0,5,1,2,0,0,0,0,3,2,0,0,5,1,1,4,0,0,0,0,5,1,1,1,1,
    1,1,1,4,0,0,3,1,1,1,1,2,3,1,4,5,1,2,0,0,0,0,0,0,0,0,5,1,1,1,1,4,0,0,5,1,1,1,1,1,
    1,1,1,1,4,0,0,3,1,1,2,0,0,3,1,1,2,0,0,0,0,0,0,0,0,5,1,1,1,1,1,1,4,5,1,1,1,2,3,1,
    1,1,1,1,2,0,0,0,3,2,0,0,0,0,3,2,0,0,0,0,0,0,0,0,5,1,2,3,1,1,1,1,1,1,1,1,2,0,0,3,
    1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,2,0,0,3,1,1,2,3,1,1,2,0,0,0,0,
    1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,2,0,0,0,0,3,2,0,0,3,2,0,0,0,0,0,
    };
    SDL_memcpy(back, tmap, sizeof(back));
}

void towerclass::loadmap(void)
{
    //Loads the map into the array.
#if !defined(MAKEANDPLAY)
    static const short tmap[] = {
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,19,28,28,28,28,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,24,28,28,28,28,22,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,28,28,28,28,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,28,28,28,28,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,0,28,28,0,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,13,23,23,24,28,0,0,17,18,18,19,0,0,28,22,23,23,14,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,22,23,23,24,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,19,0,0,28,28,0,0,17,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,24,0,0,28,28,0,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,17,18,18,19,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,22,14,13,24,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,22,24,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,19,10,0,28,28,0,11,17,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,24,0,0,28,28,0,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,19,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,24,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,17,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,22,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,19,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,24,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,17,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,22,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,19,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,10,28,28,0,11,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,10,0,28,28,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,28,28,0,11,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,24,0,0,0,28,28,0,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,11,17,18,18,18,18,19,10,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,22,23,23,23,23,24,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,19,10,0,28,28,0,11,17,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,24,0,0,28,28,0,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,11,17,18,18,19,10,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,22,23,23,24,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,10,0,28,28,0,0,0,28,28,0,0,0,28,28,0,11,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,15,18,18,19,28,0,0,0,28,28,0,0,0,28,17,18,18,16,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,0,28,28,0,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,0,28,28,0,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,0,28,28,0,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,0,28,28,0,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,0,0,28,28,28,28,0,0,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,19,28,28,28,28,17,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,24,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,17,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,20,12,12,12,12,13,23,23,24,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,20,12,12,12,12,21,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,20,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,20,12,12,12,12,21,0,0,0,0,0,0,0,8,8,0,0,28,28,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,21,28,28,28,20,12,13,23,23,24,0,0,0,0,0,0,8,17,19,0,0,28,28,20,12,12,12,12,12,12,12,12,12,12,12,
    23,23,23,23,23,24,28,28,28,20,12,21,28,28,28,0,0,0,0,0,8,17,16,21,0,0,28,28,22,23,23,23,23,23,23,23,23,23,23,23,
    28,28,28,28,28,28,28,28,28,20,12,21,28,28,28,0,0,0,0,8,17,16,12,21,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,28,28,28,28,28,20,12,21,28,28,28,0,0,0,8,17,16,12,12,21,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,28,28,28,28,28,20,12,21,28,28,28,0,0,8,17,16,12,12,12,21,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    18,18,18,18,18,18,18,18,18,16,12,21,28,28,28,0,0,17,16,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,7,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,7,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,9,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,28,28,0,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,28,28,0,28,28,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,28,28,0,28,28,7,22,14,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,28,28,0,28,28,28,7,22,14,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,0,0,28,28,0,28,28,0,28,28,28,28,7,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,6,28,28,0,0,28,28,0,28,28,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,15,19,6,28,0,0,17,18,19,28,28,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,15,19,6,0,0,20,12,21,28,28,0,28,28,28,28,28,22,23,23,23,23,14,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,0,20,12,21,28,28,0,28,28,28,28,28,28,28,0,0,0,20,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,20,12,21,28,28,0,28,28,28,28,28,28,28,0,0,0,20,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,16,12,21,28,28,0,28,28,28,0,0,0,0,0,0,0,22,14,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,0,28,28,28,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,6,28,0,28,28,28,0,0,0,0,0,0,0,0,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,6,0,17,18,18,19,0,0,0,0,0,0,0,22,14,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,20,12,12,21,0,0,0,0,0,0,0,28,20,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,16,12,12,21,10,0,0,0,0,0,0,28,22,14,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,10,0,0,0,0,0,28,28,22,14,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,28,28,28,20,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,10,0,0,0,0,28,28,28,20,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,20,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,20,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,10,0,0,0,28,28,28,28,20,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,20,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,10,0,0,0,28,28,28,28,17,16,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,10,0,0,0,28,28,28,28,17,16,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,20,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,24,0,0,0,0,28,28,28,28,17,16,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,0,0,0,28,28,28,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,7,0,0,0,28,28,28,0,0,0,0,28,28,28,28,28,17,16,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,7,28,0,0,0,28,28,28,0,0,0,0,28,28,28,28,28,20,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,13,24,7,28,28,0,0,0,28,28,28,0,0,0,0,28,28,28,28,17,16,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,13,24,9,28,28,28,0,0,0,28,28,28,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,9,0,28,28,28,0,0,0,28,28,28,0,0,0,0,28,28,28,17,16,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,28,28,28,0,0,0,28,28,28,0,0,0,0,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,13,23,23,23,24,0,0,28,28,28,0,0,0,28,28,28,0,0,0,17,18,18,18,16,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,28,28,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,28,28,0,0,8,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,28,28,0,8,17,16,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,28,28,8,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,28,6,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,6,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,0,28,28,28,0,0,0,28,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,17,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,0,8,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,8,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,17,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    23,23,23,23,23,14,12,12,21,28,28,28,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
    28,28,28,28,28,20,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,28,20,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,28,20,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,28,20,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    18,19,28,28,28,20,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,
    12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    23,24,28,28,28,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
    7,7,28,28,28,28,28,28,28,28,28,28,28,28,28,28,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,
    28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,
    28,28,0,0,0,0,0,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,
    28,28,0,0,0,0,0,17,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,
    0,0,0,0,0,0,0,22,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,8,8,8,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,17,18,19,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,22,23,24,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,28,28,28,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,28,28,28,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,28,28,28,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,28,28,28,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,0,0,
    0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,19,0,0,
    0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,24,0,0,
    0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,
    0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,
    0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,
    0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,0,0,0,28,28,28,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,19,0,0,0,0,28,28,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,24,0,0,0,0,28,28,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,28,28,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,28,28,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,28,28,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,28,28,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,17,18,18,18,18,18,18,19,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,22,23,23,23,23,23,23,24,10,0,0,0,0,0,0,0,0,0,0,28,28,0,0,28,28,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,7,7,7,7,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,28,28,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,28,28,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,28,28,28,28,28,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,17,18,18,18,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,22,23,23,23,23,23,23,23,24,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,19,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,24,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,8,8,8,8,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,17,18,18,19,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,22,23,23,24,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0,
    8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,8,8,8,8,8,8,8,8,
    18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,17,18,18,18,18,18,18,18,
    12,21,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,22,23,23,23,23,23,14,12,
    12,15,18,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,28,28,28,28,28,28,20,12,
    12,12,12,12,12,12,12,21,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,28,28,28,28,28,28,20,12,
    12,12,12,12,12,12,12,15,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,28,28,28,28,28,28,20,12,
    23,23,14,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,0,0,28,28,28,28,28,28,22,23,
    28,28,20,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,28,28,28,28,28,28,
    28,28,22,23,23,23,23,14,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,28,28,28,28,28,28,
    28,28,28,28,28,28,28,20,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,28,28,28,28,
    28,28,28,28,28,28,28,20,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,28,28,28,28,
    28,28,28,28,28,28,28,20,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,28,28,
    28,28,28,28,28,28,28,22,23,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,28,28,
    0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    8,8,8,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,
    18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,18,
    12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,20,12,12,
    12,12,21,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,18,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,20,12,12,
    12,12,21,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,23,23,23,23,24,0,0,0,0,0,0,0,0,0,0,0,20,12,12,
    12,12,21,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,
    12,12,21,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,
    12,12,21,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,
    12,12,21,6,6,6,6,6,6,28,28,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,
    12,12,15,18,18,18,18,18,19,28,28,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,8,8,8,8,8,8,20,12,12,
    12,12,12,12,12,12,12,12,21,28,28,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,17,18,18,18,18,18,16,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,17,18,16,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,22,23,14,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,28,28,28,0,0,28,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,28,0,0,0,0,0,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,0,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,15,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,13,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,8,8,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,15,18,19,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,13,23,24,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,8,8,8,8,8,6,6,6,6,6,6,6,6,6,6,6,6,20,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,8,8,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,15,18,19,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,13,23,24,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,8,8,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,17,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,13,23,23,23,23,23,14,21,0,0,0,20,12,12,12,13,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,21,9,9,9,9,9,20,21,0,0,0,20,12,12,12,21,9,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,21,0,0,0,0,0,20,21,0,0,0,20,12,12,12,21,0,9,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,21,0,0,0,0,0,20,21,0,0,0,22,23,23,23,24,0,0,9,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,21,0,0,0,0,0,20,21,0,0,0,0,0,0,0,0,0,0,0,9,20,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,14,12,
    23,24,0,0,0,0,0,20,21,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,22,23,
    0,0,0,0,0,0,0,20,21,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,
    0,0,0,0,0,0,0,22,24,0,0,0,0,0,0,0,0,0,0,0,0,22,23,23,23,23,14,12,12,12,12,12,12,21,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,21,0,0,0,0,0,0,
    18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,15,19,0,0,17,18,18,
    12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,13,24,0,0,20,12,12,
    12,12,12,15,18,18,18,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,21,0,0,0,20,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,21,0,0,0,20,12,12,
    12,12,12,12,12,12,12,12,12,12,12,21,8,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,23,23,23,14,12,21,0,0,0,20,12,12,
    12,12,12,12,12,12,12,12,12,12,12,15,19,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,21,0,0,17,16,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,0,0,17,18,18,18,19,0,0,0,0,0,0,0,0,11,20,12,21,0,0,22,23,23,14,
    12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,0,20,12,12,12,21,0,0,0,0,0,0,0,0,11,20,12,21,0,0,0,0,0,20,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,8,20,12,12,12,21,8,8,8,8,0,0,0,0,11,20,12,21,0,0,0,0,0,20,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,16,12,12,12,15,18,18,18,19,10,0,0,0,11,20,12,21,0,0,0,0,0,20,
    23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,11,20,12,21,0,0,0,0,0,22,
    9,9,9,9,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,11,20,12,21,0,0,0,0,0,9,
    0,0,0,0,11,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,11,20,12,21,0,0,0,0,0,0,
    0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,11,20,12,15,18,18,19,0,0,0,
    0,0,0,0,0,11,22,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,11,20,12,12,12,13,24,0,0,0,
    0,0,0,0,0,0,11,20,12,13,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,21,10,0,0,0,11,20,12,12,13,24,0,0,0,0,
    0,0,0,0,0,0,11,20,13,24,9,9,9,9,9,9,9,9,20,12,12,12,12,12,12,21,10,0,0,0,11,20,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,21,10,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,21,10,0,0,0,11,20,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,21,10,0,0,0,0,0,0,0,0,22,23,23,23,23,23,23,24,10,0,0,0,11,20,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,21,10,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,11,20,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,21,10,0,0,0,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,17,16,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,21,10,0,28,28,28,28,28,28,28,28,28,0,0,17,18,18,18,18,18,18,18,16,12,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,17,16,21,10,0,28,28,28,28,28,28,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,
    0,0,0,0,0,17,16,12,21,10,0,28,28,28,28,28,28,28,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,
    0,0,0,0,0,22,14,12,15,19,8,6,6,6,6,6,6,6,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,22,14,12,15,18,18,18,18,18,18,18,19,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,21,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,21,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,21,28,28,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,21,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,12,12,21,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,12,12,12,12,12,13,23,23,23,24,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,
    0,0,0,0,0,0,11,20,12,13,23,23,23,24,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,15,19,0,0,0,0,
    0,0,0,0,0,0,11,20,12,21,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,15,18,19,0,0,
    18,18,19,0,0,0,11,20,12,21,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,13,23,23,23,23,14,12,12,15,18,18,
    12,12,21,0,0,0,11,20,12,21,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,12,21,28,28,28,28,22,23,23,23,14,12,
    23,23,24,0,0,0,11,20,12,21,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,22,23,
    0,0,0,0,0,0,11,20,12,21,28,28,28,28,17,18,18,19,0,0,0,0,20,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,
    0,0,0,0,0,0,11,20,12,21,28,28,28,28,20,12,12,15,18,18,18,18,16,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,
    0,0,0,0,0,0,11,20,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,
    0,0,0,0,0,0,11,20,12,21,28,28,28,28,22,23,23,23,14,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,
    0,0,0,0,0,0,11,20,12,21,28,28,28,28,28,28,28,28,22,23,23,23,14,12,12,12,12,12,12,21,28,28,28,28,0,0,0,0,0,0,
    0,0,0,0,0,0,11,20,12,21,28,28,28,28,28,28,28,28,28,28,0,0,22,23,23,23,14,12,12,21,28,28,28,28,17,18,18,19,0,0,
    18,19,0,0,0,0,11,20,12,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,21,28,28,28,28,20,12,12,15,18,18,
    12,15,18,18,18,18,18,16,12,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,21,28,28,28,28,20,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,21,28,28,28,28,22,23,23,23,14,12,
    23,23,14,12,12,12,12,12,12,15,18,18,18,19,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,21,28,28,28,28,0,0,0,0,22,23,
    0,0,22,23,23,23,14,12,12,12,12,12,12,21,28,28,28,28,6,6,8,8,0,0,0,0,20,12,12,21,28,28,28,28,0,0,0,0,0,0,
    0,0,0,0,0,0,22,23,23,23,14,12,12,21,28,28,28,28,17,18,18,19,0,0,0,0,20,12,12,21,28,28,28,28,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,28,28,22,23,23,24,28,28,28,28,20,12,12,21,0,0,0,0,20,12,12,21,28,28,28,28,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,21,0,0,0,0,20,12,12,21,6,6,6,6,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,21,28,28,0,0,20,12,12,15,18,18,18,19,8,8,8,8,0,0,
    8,8,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,21,28,28,0,0,20,12,12,12,12,12,12,15,18,18,18,19,8,8,
    18,19,8,8,8,8,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,21,28,28,0,0,22,23,23,23,14,12,12,12,12,12,12,15,18,18,
    12,15,18,18,18,19,0,0,28,28,28,28,28,28,28,28,28,28,20,12,12,21,28,28,0,0,0,0,0,0,22,23,23,23,14,12,12,12,12,12,
    12,12,12,12,12,15,18,18,18,19,28,28,28,28,28,28,28,28,20,12,12,21,28,28,0,0,0,0,0,0,28,28,28,28,22,23,23,23,14,12,
    12,12,12,12,12,12,12,12,12,15,18,18,18,19,28,28,28,28,20,12,12,21,28,28,0,0,0,0,0,0,28,28,28,28,28,28,28,28,20,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,16,12,12,21,28,28,0,0,0,0,0,0,0,0,28,28,28,28,28,28,20,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,6,6,8,8,0,0,0,0,0,0,28,28,28,28,28,28,20,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,19,8,8,8,8,0,0,28,28,28,28,28,28,20,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,19,0,0,28,28,28,28,28,28,20,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,19,28,28,28,28,20,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,
    23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,14,21,28,28,28,28,22,23,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,11,20,21,28,28,28,28,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,11,20,21,28,28,28,28,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,21,28,28,28,28,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,21,28,28,28,28,0,0,
    18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,28,28,0,0,11,20,15,18,18,18,18,18,18,
    12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,28,28,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,21,10,0,0,0,0,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,
    12,12,12,21,10,0,0,0,0,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,
    12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,22,23,23,23,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,24,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,17,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,22,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,22,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,23,23,14,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,13,23,23,23,23,23,23,23,23,23,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,6,6,6,6,6,6,6,6,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,17,18,18,18,18,18,18,18,18,18,19,0,0,0,0,0,0,17,18,18,19,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,22,23,23,24,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,20,12,13,23,23,23,23,23,23,23,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,17,18,16,12,12,12,12,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,22,23,23,23,23,23,14,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,6,6,6,6,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,17,18,18,19,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,22,23,23,24,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,
    12,21,28,28,28,28,20,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,
    12,21,28,28,28,28,22,23,24,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,17,18,19,0,0,0,20,12,12,12,
    12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,22,23,24,0,0,0,20,12,12,12,
    12,21,28,28,28,28,28,28,28,28,28,28,28,17,19,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,20,12,12,12,
    12,21,28,28,28,28,28,28,28,28,28,28,28,20,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,20,12,12,12,
    12,15,18,18,18,18,18,18,18,18,18,18,18,16,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,6,6,6,6,6,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,19,28,28,28,28,28,17,19,28,28,28,28,28,28,28,0,0,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,6,6,6,6,6,20,21,28,28,28,28,28,28,28,0,0,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,16,21,28,28,28,28,28,28,28,0,0,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,17,18,18,18,18,18,16,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,22,23,14,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,20,12,12,12,12,12,12,12,
    23,23,23,23,23,14,13,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,22,14,13,23,23,23,23,23,
    28,28,28,28,28,22,24,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,22,24,28,28,28,28,28,
    28,28,28,28,28,7,7,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,7,7,28,28,28,28,28,
    28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,
    28,28,28,28,28,28,28,28,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,
    18,18,18,18,18,18,18,18,19,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,
    12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,22,23,23,23,23,23,14,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,14,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,22,24,28,28,28,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,7,7,28,28,28,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,6,6,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,21,28,28,28,28,28,17,19,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,15,18,18,18,18,18,16,15,18,18,18,18,18,18,19,10,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,10,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,10,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,0,0,11,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,17,18,18,18,16,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,10,0,0,0,0,0,22,23,23,23,14,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,0,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,12,13,23,23,23,14,12,13,23,23,23,23,23,23,23,23,23,24,10,0,0,0,0,0,0,0,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,13,24,9,9,9,20,12,21,7,7,7,7,7,7,7,7,9,9,0,0,0,0,0,0,0,0,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,22,23,24,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,28,28,28,28,20,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,22,23,23,23,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,22,14,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,0,0,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,10,0,0,0,17,18,19,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,15,19,8,8,8,20,12,21,6,6,6,6,6,6,6,6,8,8,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,15,18,18,18,16,12,15,18,18,18,18,18,18,18,18,18,19,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,24,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,24,7,7,7,7,7,9,9,9,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,13,24,0,0,0,0,28,28,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,11,20,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,17,16,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,17,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,6,6,6,6,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,17,18,18,18,16,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,21,10,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,15,19,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,22,23,23,23,23,14,13,23,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,28,28,20,21,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,28,28,22,24,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,28,28,28,28,28,28,0,0,0,0,0,0,20,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,14,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,15,18,18,18,18,19,0,0,0,0,0,0,0,0,0,0,17,19,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,0,0,0,0,0,0,0,0,0,20,21,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,18,18,18,16,21,0,0,0,0,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,0,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,19,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,13,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,0,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,20,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,22,23,23,23,23,23,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,22,23,23,23,14,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,22,23,23,23,14,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,15,18,18,18,19,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,19,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,18,18,18,18,18,18,18,19,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,13,23,23,23,14,12,12,12,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,22,23,23,14,12,12,12,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,21,28,28,28,28,28,28,22,23,23,14,12,12,21,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,13,24,28,28,28,28,28,28,28,28,28,22,23,23,24,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    23,23,23,23,23,14,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    28,28,28,28,28,20,12,12,12,12,12,21,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    28,28,28,28,28,22,23,23,23,23,23,24,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,0,0,28,28,28,28,28,20,12,12,12,12,12,12,12,12,12,
    18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,16,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
    };

    SDL_memcpy(contents, tmap, sizeof(contents));
#endif
}
