/* angst - help.c
 * by Patroklos Argyroudis <argp@bsd.gr>
 *
 * Help message and version number.
 *
 * $Id: help.c,v 1.6 2001/02/05 15:21:51 argp Exp $
 */ 

#include "angst.h"

void
usage(char *name)
{
 fprintf(stderr, "\n			[ angst - an active sniffer ]\n");
 fprintf(stderr, "		    [ Patroklos Argyroudis <argp@bsd.gr> ]\n\n");
 fprintf(stderr, "usage: %s [active sniffing method] [active sniffing options] [options]\n\n", name);
 fprintf(stderr, "active sniffing methods:\n");
 fprintf(stderr, "	[ -a	man-in-the-middle ARP method ]\n");
 fprintf(stderr, "	[ -f	flood random MAC addresses method ]\n\n");
 fprintf(stderr, "active sniffing options:\n");
 fprintf(stderr, "	[ -d	don't try to enable IP forwarding on the local host ]\n");
 fprintf(stderr, "	[ -s	specify the seconds between each flooding for flood method,\n");
 fprintf(stderr, "		or the seconds between the injection of the fake ARP replies ]\n");
 fprintf(stderr, "	[ -c	specify the number of packets to flood, for flood method ]\n\n");
 fprintf(stderr, "options:\n");
 fprintf(stderr, "	[ -h	this help message ]\n");
 fprintf(stderr, "	[ -p	don't put the interface into promiscuous mode ]\n");
 fprintf(stderr, "	[ -r	resolve IP addresses ]\n");
 fprintf(stderr, "	[ -v	display the version number and exit ]\n");
 fprintf(stderr, "	[ -i	specify which interface to use ]\n");
 fprintf(stderr, "	[ -l	specify the log filename ]\n");
 fprintf(stderr, "	[ -e	specify the port numbers to build the filter expression ]\n\n");
}

void
display_version(const char *ver)
{
 fprintf(stderr, "angst v%s - an active sniffer\n", ver);
 fprintf(stderr, "by invisible <invisibl@bsd.gr>\n");
}

/* EOF */
