# Try to find SuperLU 4.x
# Once done, this will define
#
#  SuperLU_FOUND        - system has SuperLU
#  SuperLU_LIBRARY      - Link this to use SuperLU
#  SuperLU_INCLUDE_DIR  - directory of SuperLU headers

find_path(SuperLU_INCLUDE_DIR slu_ddefs.h
  /usr/include/superlu/
  /usr/include/SuperLU/
  /usr/include/
  /usr/local/include/superlu/
  /usr/local/include/SuperLU/
  /usr/local/include/
  /opt/local/include/superlu/
  /opt/local/include/SuperLU/
  /opt/local/include/
)

find_library(SuperLU_LIBRARY
  NAMES superlu
  PATHS ${CMAKE_SYSTEM_LIBRARY_PATH} /usr/lib64 /usr/lib /usr/local/lib64 /usr/local/lib /opt/local/lib64 /opt/local/lib
)

SET(SuperLU_FOUND NO)

IF (NOT SuperLU_FIND_QUIETLY)
  MESSAGE(STATUS "Looking for SuperLU version 4")
ENDIF ()

IF (SuperLU_LIBRARY AND SuperLU_INCLUDE_DIR)
  
  # Now determine if the version is version 4.
  # This voodoo is required as SuperLU developers like to keep things messy.
  
  IF (EXISTS "${SuperLU_INCLUDE_DIR}/slu_ddefs.h")
    
    FILE(READ "${SuperLU_INCLUDE_DIR}/slu_ddefs.h" _slu_HEADER_CONTENTS)
    
    STRING(REGEX REPLACE ".*version ([0-9]).*" "\\1" SLU_VERSION_MAJOR "${_slu_HEADER_CONTENTS}")
    
    IF ("${SLU_VERSION_MAJOR}" EQUAL "4")
      
      # NOTE: SLU_VERSION_MAJOR = 4 is not 100% reliable, as the version string in slu_ddefs.h wasn't updated in SuperLU 5.0, 5.1, 5.2
      # NOTE: We need to explicitly check the prototype of dgssvx() to determine whether this is version 4 or 5.
      
      STRING(FIND "${_slu_HEADER_CONTENTS}" "dgssvx" _slu_dgssvx_start)
      
      IF ("${_slu_dgssvx_start}" GREATER 0)
        
        STRING(SUBSTRING "${_slu_HEADER_CONTENTS}" ${_slu_dgssvx_start} -1 _slu_dgssvx_tmp)
        
        STRING(FIND "${_slu_dgssvx_tmp}" ";" _slu_dgssvx_len)
        
        STRING(SUBSTRING "${_slu_HEADER_CONTENTS}" ${_slu_dgssvx_start} ${_slu_dgssvx_len} _slu_dgssvx_proto)
        
        STRING(FIND "${_slu_dgssvx_proto}" "GlobalLU_t" _slu_dgssvx_check)
        
        IF ("${_slu_dgssvx_check}" EQUAL -1)
          # in version 4, dgssvx() doesn't have a GlobalLU_t argument
          SET(SuperLU_FOUND YES)
        ELSE ()
          IF (NOT SuperLU_FIND_QUIETLY)
            MESSAGE(STATUS "Found SuperLU, but it doesn't appear to be version 4")
          ENDIF ()
        ENDIF ()
      ENDIF ()
    ELSE ()
      IF (NOT SuperLU_FIND_QUIETLY)
        MESSAGE(STATUS "Found SuperLU version ${SLU_VERSION_MAJOR}, but version 4 is required")
      ENDIF ()
    ENDIF ()
  ELSE ()
    IF (NOT SuperLU_FIND_QUIETLY)
      MESSAGE(STATUS "Found SuperLU and headers, but could not verify version 4")
    ENDIF ()
  ENDIF ()
ENDIF ()

IF (SuperLU_LIBRARY AND NOT SuperLU_INCLUDE_DIR)
  IF (NOT SuperLU_FIND_QUIETLY)
    MESSAGE(STATUS "Incomplete installation of SuperLU: no SuperLU headers found")
  ENDIF ()
ENDIF ()
  
IF (NOT SuperLU_FOUND) 
  IF (NOT SuperLU_FIND_QUIETLY)
    MESSAGE(STATUS "Could not find SuperLU")
  ENDIF ()
ELSE ()
  MESSAGE(STATUS "Found SuperLU: ${SuperLU_LIBRARY}")
ENDIF ()

