### Requirements for Adding, Changing, or Removing a Feature

* Fill out the template below. Any pull request that does not include enough information to be reviewed in a timely manner may be closed at the maintainers' discretion.
* The pull request must contribute a change that has been endorsed by the maintainer team. See details in the template below.
* The pull request must update the test suite to exercise the updated functionality. For guidance, please see https://flight-manual.atom.io/hacking-atom/sections/writing-specs/.
* After you create the pull request, all status checks must be pass before a maintainer reviews your contribution. For more details, please see https://github.com/atom/atom/tree/master/CONTRIBUTING.md#pull-requests.

### Issue or RFC Endorsed by Atom's Maintainers

<!--

Link to the issue or RFC that your change relates to. This must be one of the following:

* An open issue with the `help-wanted` label
* An open issue with the `triaged` label
* An RFC with "accepted" status

To contribute an enhancement that isn't covered by one of the items above, please follow our guide for suggesting an enhancement: https://github.com/atom/atom/blob/master/CONTRIBUTING.md#suggesting-enhancements

To contribute other changes, you must use a different template. You can see all templates at https://github.com/atom/atom/tree/master/.github/PULL_REQUEST_TEMPLATE.

-->

### Description of the Change

<!--

We must be able to understand the design of your change from this description. If we can't get a good idea of what the code will be doing from the description here, the pull request may be closed at the maintainers' discretion. Keep in mind that the maintainer reviewing this PR may not be familiar with or have worked with the code here recently, so please walk us through the concepts.

-->

### Alternate Designs

<!-- Explain what other alternates were considered and why the proposed version was selected -->

### Possible Drawbacks

<!-- What are the possible side-effects or negative impacts of the code change? -->

### Verification Process

<!--

What process did you follow to verify that your change has the desired effects?

- How did you verify that all new functionality works as expected?
- How did you verify that all changed functionality works as expected?
- How did you verify that the change has not introduced any regressions?

Describe the actions you performed (including buttons you clicked, text you typed, commands you ran, etc.), and describe the results you observed.

-->
