/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.Locale;
import org.basex.core.Command;
import org.basex.core.Text;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.util.options.Option;

public final class ShowOptions
extends Command {
    public ShowOptions() {
        this((String)null);
    }

    public ShowOptions(Option<?> option) {
        this(option.name());
    }

    public ShowOptions(String key) {
        super(Perm.NONE, key != null ? key : "");
    }

    @Override
    protected boolean run() throws IOException {
        if (this.args[0].isEmpty()) {
            if (this.context.user().has(Perm.ADMIN)) {
                this.out.println(Text.GLOBAL_OPTIONS + ":");
                for (Option<?> o : this.soptions) {
                    this.out.println(o.name() + ": " + String.valueOf(this.soptions.get(o)));
                }
            }
            this.out.println(Text.NL + Text.LOCAL_OPTIONS + ":");
            for (Option<?> o : this.options) {
                this.out.println(o.name() + ": " + String.valueOf(this.options.get(o)));
            }
        } else {
            String name = this.args[0].toUpperCase(Locale.ENGLISH);
            Object value = this.context.option(name);
            if (value == null) {
                return this.error(this.context.options.similar(name), new Object[0]);
            }
            this.out.println(name + ": " + String.valueOf(value));
        }
        return true;
    }

    @Override
    public void addLocks() {
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(String.valueOf((Object)Commands.Cmd.SHOW) + " " + String.valueOf((Object)Commands.CmdShow.OPTIONS)).arg(0);
    }
}

