/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.csv.CsvOptions;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.StandardSerializer;
import org.basex.io.serial.csv.CsvDirectSerializer;
import org.basex.io.serial.csv.CsvW3ArraysSerializer;
import org.basex.io.serial.csv.CsvW3Serializer;
import org.basex.io.serial.csv.CsvW3XmlSerializer;
import org.basex.io.serial.csv.CsvXQuerySerializer;
import org.basex.query.QueryError;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.SeqType;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;
import org.basex.util.list.TokenList;

public abstract class CsvSerializer
extends StandardSerializer {
    final CsvOptions copts;
    final int fieldDelimiter;
    final boolean quotes;
    final boolean backslashes;
    private final int rowDelimiter;
    private final int quoteCharacter;
    private final int[] selectColumns;
    private int maxCol;
    boolean header;

    public static Serializer get(OutputStream os, SerializerOptions so) throws IOException {
        return switch (so.get(SerializerOptions.CSV).get(CsvOptions.FORMAT)) {
            case CsvOptions.CsvFormat.XQUERY -> new CsvXQuerySerializer(os, so);
            case CsvOptions.CsvFormat.W3 -> new CsvW3Serializer(os, so);
            case CsvOptions.CsvFormat.W3_ARRAYS -> new CsvW3ArraysSerializer(os, so);
            case CsvOptions.CsvFormat.W3_XML -> new CsvW3XmlSerializer(os, so);
            default -> new CsvDirectSerializer(os, so);
        };
    }

    CsvSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
        Str str;
        Boolean b;
        this.copts = sopts.get(SerializerOptions.CSV);
        this.quotes = this.copts.get(CsvOptions.QUOTES);
        this.backslashes = this.copts.get(CsvOptions.BACKSLASHES);
        this.fieldDelimiter = this.copts.fieldDelimiter();
        this.rowDelimiter = this.copts.rowDelimiter();
        this.quoteCharacter = this.copts.quoteCharacter();
        this.selectColumns = this.copts.get(CsvOptions.SELECT_COLUMNS);
        this.maxCol = -1;
        for (int col : this.selectColumns) {
            if (col <= this.maxCol) continue;
            this.maxCol = col;
        }
        Value hdr = this.copts.get(CsvOptions.HEADER);
        if (SeqType.BOOLEAN_O.instance(hdr)) {
            this.header = ((Bln)hdr).bool(null);
        } else if (hdr instanceof Str && (b = Strings.toBoolean(Token.string((str = (Str)hdr).string()))) != null) {
            this.header = b;
        }
    }

    final void record(TokenList entries) throws IOException {
        this.record(entries, true);
    }

    final void record(TokenList entries, boolean reset) throws IOException {
        int f = 0;
        if (this.maxCol < 0) {
            for (byte[] val : entries) {
                this.field(f++, val);
            }
        } else {
            byte[][] row = new byte[this.maxCol][];
            int i = 0;
            for (byte[] val : entries) {
                int j;
                if (i == this.selectColumns.length) break;
                if (row[j = this.selectColumns[i++] - 1] != null) continue;
                row[j] = val;
            }
            for (Object val : (Object)row) {
                this.field(f++, val == null ? Token.EMPTY : (byte[])val);
            }
        }
        this.out.print(this.rowDelimiter);
        if (reset) {
            entries.reset();
        }
    }

    final void field(int seqNo, byte[] value) throws IOException {
        boolean special;
        if (seqNo != 0) {
            this.out.print(this.fieldDelimiter);
        }
        byte[] txt = value != null ? value : Token.EMPTY;
        boolean delim = Token.contains(txt, this.fieldDelimiter) || Token.contains(txt, this.rowDelimiter);
        boolean bl = special = Token.contains(txt, 13) || Token.contains(txt, 9) || Token.contains(txt, this.quoteCharacter);
        if (delim || special || this.backslashes && Token.contains(txt, 92)) {
            TokenBuilder tb = new TokenBuilder();
            if (delim && !this.backslashes && !this.quotes) {
                throw QueryError.CSV_SERIALIZE_X_X.getIO("Output must be put into quotes", txt);
            }
            if (this.quotes && (delim || special)) {
                tb.add(this.quoteCharacter);
            }
            TokenParser tp = new TokenParser(txt);
            while (tp.more()) {
                int cp = tp.next();
                if (this.backslashes) {
                    if (cp == 10) {
                        tb.add("\\").add(this.fieldDelimiter == 10 ? "n" : Integer.valueOf(cp));
                        continue;
                    }
                    if (cp == 13) {
                        tb.add("\\r");
                        continue;
                    }
                    if (cp == 9) {
                        tb.add("\\t");
                        continue;
                    }
                    if (cp == this.quoteCharacter) {
                        tb.add("\\").add(cp);
                        continue;
                    }
                    if (cp == 92) {
                        tb.add("\\\\");
                        continue;
                    }
                    if (cp == this.fieldDelimiter && !this.quotes) {
                        tb.add(92).add(cp);
                        continue;
                    }
                    tb.add(cp);
                    continue;
                }
                if (cp == this.quoteCharacter) {
                    tb.add(this.quoteCharacter);
                }
                tb.add(cp);
            }
            if (this.quotes && (delim || special)) {
                tb.add(this.quoteCharacter);
            }
            txt = tb.finish();
        }
        this.out.print(txt);
    }

    @Override
    protected void atomic(Item value) throws IOException {
        throw QueryError.CSV_SERIALIZE_X.getIO("Atomic items cannot be serialized");
    }
}

