/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Convert;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Castable
extends Convert {
    public Castable(InputInfo info, Expr expr, SeqType seqType) {
        super(info, expr, seqType, SeqType.BOOLEAN_O);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        super.optimize(cc);
        SeqType st = this.castType();
        Boolean test = this.castable(st);
        if (test != null) {
            return cc.replaceWith(this, Bln.get(test));
        }
        Expr arg = this.simplify(st, cc);
        if (arg != null) {
            return new Castable(this.info, arg, this.seqType).optimize(cc);
        }
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        return this.seqType.cast(this.expr.atomValue(qc, this.info), false, qc, this.info) != null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Castable(this.info, this.expr.copy(cc, vm), this.seqType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Castable)) return false;
        Castable cst = (Castable)obj;
        if (!this.seqType.eq(cst.seqType)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("(").token(this.expr).token("castable").token("as").token(this.seqType).token(')');
    }
}

