/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.XQStruct;
import org.basex.query.value.type.FuncType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class DynFuncCall
extends FuncCall {
    private final boolean updating;
    private boolean ndt;

    public DynFuncCall(InputInfo info, Expr expr, Expr ... args) {
        this(info, false, false, expr, args);
    }

    public DynFuncCall(InputInfo info, boolean updating, boolean ndt, Expr expr, Expr ... args) {
        super(info, ExprList.concat(args, expr));
        this.updating = updating;
        this.ndt = ndt;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        if (this.body().has(Flag.NDT)) {
            this.ndt = true;
        }
        return super.compile(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr func = this.body();
        int nargs = this.exprs.length - 1;
        FuncType ft = func.funcType();
        if (ft != null) {
            int arity;
            if (ft.argTypes != null && nargs != (arity = ft.argTypes.length)) {
                throw QueryError.arityError(func, nargs, arity, false, this.info);
            }
            if (!this.sc().mixUpdates && !this.updating && ft.anns.contains(Annotation.UPDATING)) {
                throw QueryError.FUNCUP_X.get(this.info, func);
            }
            this.exprType.assign(ft.declType);
        }
        if (func instanceof XQStruct) {
            if (nargs == 1) {
                this.arg(0, arg -> arg.simplifyFor(CompileContext.Simplify.DATA, cc));
            }
            if (this.values(false, cc)) {
                return cc.preEval(this);
            }
        }
        if (func instanceof XQFunctionExpr) {
            XQFunctionExpr fe = (XQFunctionExpr)((Object)func);
            if (!cc.inlined.contains(fe)) {
                this.checkUp(fe, this.updating);
                cc.inlined.push(fe);
                try {
                    Expr inlined = fe.inline(Arrays.copyOf(this.exprs, nargs), cc);
                    if (inlined != null) {
                        Expr expr = inlined;
                        return expr;
                    }
                }
                finally {
                    cc.inlined.pop();
                }
            }
        } else if (func instanceof Value) {
            throw QueryError.INVFUNCITEM_X_X.get(this.info, func.seqType(), func);
        }
        return this;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(Arrays.copyOf(this.exprs, this.exprs.length - 1));
        this.body().checkUp();
    }

    private Expr body() {
        return this.exprs[this.exprs.length - 1];
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        Expr[] copy = DynFuncCall.copyAll((CompileContext)cc, vm, (Expr[])this.exprs);
        int last = copy.length - 1;
        Expr[] args = Arrays.copyOf(copy, last);
        return this.copyType(new DynFuncCall(this.info, this.updating, this.ndt, copy[last], args));
    }

    @Override
    FItem evalFunc(QueryContext qc) throws QueryException {
        Item item = this.body().item(qc, this.info);
        if (!(item instanceof FItem)) {
            throw QueryError.INVFUNCITEM_X_X.get(this.info, item.seqType(), item);
        }
        FItem func = (FItem)item;
        this.checkUp(func, this.updating);
        int nargs = this.exprs.length - 1;
        int arity = func.arity();
        if (nargs != arity) {
            throw QueryError.arityError(func, nargs, arity, false, this.info);
        }
        return func;
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.UPD.oneOf(flags) && (this.updating || this.sc().mixUpdates) || Flag.NDT.oneOf(flags) && (this.ndt || this.updating || this.sc().mixUpdates) || super.has(Flag.remove(flags, Flag.UPD));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DynFuncCall)) return false;
        DynFuncCall dfc = (DynFuncCall)obj;
        if (this.updating != dfc.updating) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public String description() {
        return this.body().description() + "(...)";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "tailCall", this.tco), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        int el = this.exprs.length - 1;
        qs.token(this.exprs[el]).token('(');
        for (int e = 0; e < el; ++e) {
            if (e > 0) {
                qs.token(", ");
            }
            qs.token(this.exprs[e]);
        }
        qs.token(')');
    }
}

