/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.io.in.TextInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.func.Function;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Lazy;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class StrLazy
extends AStr
implements Lazy {
    private final IO input;
    private final String encoding;
    private final QueryError error;
    private final boolean validate;
    private boolean cache;

    public StrLazy(IO input, String encoding, QueryError error, boolean validate) {
        this.input = input;
        this.encoding = encoding;
        this.error = error;
        this.validate = validate;
    }

    @Override
    public byte[] string(InputInfo ii) throws QueryException {
        this.cache(ii);
        return this.value;
    }

    @Override
    public String toJava() throws QueryException {
        return Token.string(this.string(null));
    }

    @Override
    public TextInput stringInput(InputInfo ii) throws IOException, QueryException {
        if (this.cache) {
            this.cache(ii);
        }
        return this.isCached() ? super.stringInput(ii) : this.get(ii);
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
        if (lazy) {
            this.cache = true;
        } else {
            this.cache(ii);
        }
    }

    @Override
    public void cache(InputInfo ii) throws QueryException {
        try {
            if (!this.isCached()) {
                this.value = this.get(ii).content();
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            throw this.error.get(ii, this.input);
        }
    }

    public int hashCode() {
        try {
            return Token.hashCode(this.string(null));
        }
        catch (QueryException ex) {
            Util.stack(ex);
            return Integer.MAX_VALUE;
        }
    }

    private TextInput get(InputInfo info) throws QueryException {
        NewlineInput nli = null;
        try {
            nli = new NewlineInput(this.input);
            nli.encoding(this.encoding).validate(this.validate);
            return nli;
        }
        catch (IOException ex) {
            if (nli != null) {
                try {
                    nli.close();
                }
                catch (IOException e) {
                    Util.debug(e);
                }
            }
            throw this.error.get(info, ex);
        }
    }

    @Override
    public boolean isCached() {
        return this.value != null;
    }

    @Override
    public Item materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        this.cache(ii);
        return this;
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        this.cache(ii);
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StrLazy) {
            StrLazy str = (StrLazy)obj;
            if (this.input.eq(str.input) && Objects.equals(this.encoding, str.encoding) && this.error == str.error && this.validate == str.validate) {
                return true;
            }
        }
        return super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        if (this.isCached()) {
            super.toString(qs);
        } else {
            qs.function(Function._FILE_READ_TEXT, this.input);
        }
    }
}

