/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.list.ElementList;

public final class IntList
extends ElementList {
    private int[] list;

    public IntList() {
        this(-1L);
    }

    public IntList(long capacity) {
        this.list = new int[Array.initialCapacity(capacity)];
    }

    public IntList(double factor) {
        this();
        this.factor = (byte)Math.max(10, (byte)(factor * 10.0));
    }

    public IntList(int[] elements) {
        this.list = elements;
        this.size = elements.length;
    }

    public IntList add(int element) {
        int s = this.size;
        int[] lst = this.list;
        if (s == lst.length) {
            this.list = lst = Arrays.copyOf(lst, this.newCapacity());
        }
        lst[s] = element;
        this.size = s + 1;
        return this;
    }

    public IntList add(int ... elements) {
        int s = this.size;
        int l = elements.length;
        int ns = s + l;
        int[] lst = this.list;
        if (ns > lst.length) {
            this.list = lst = Arrays.copyOf(lst, this.newCapacity(ns));
        }
        Array.copyFromStart(elements, l, lst, s);
        this.size = ns;
        return this;
    }

    public int get(int index) {
        return this.list[index];
    }

    public void set(int index, int element) {
        if (index >= this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newCapacity(index + 1));
        }
        this.list[index] = element;
        this.size = Math.max(this.size, index + 1);
    }

    public boolean contains(int element) {
        int s = this.size;
        int[] lst = this.list;
        for (int i = 0; i < s; ++i) {
            if (lst[i] != element) continue;
            return true;
        }
        return false;
    }

    public IntList addUnique(int element) {
        if (!this.contains(element)) {
            this.add(element);
        }
        return this;
    }

    public void insert(int index, int ... elements) {
        int l = elements.length;
        if (l == 0) {
            return;
        }
        if (this.size + l > this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newCapacity(this.size + l));
        }
        Array.insert(this.list, index, l, this.size, elements);
        this.size += l;
    }

    public void removeAll(int element) {
        int[] lst = this.list;
        int s = this.size;
        int ns = 0;
        for (int i = 0; i < s; ++i) {
            if (lst[i] == element) continue;
            lst[ns++] = lst[i];
        }
        this.size = ns;
    }

    public int remove(int index) {
        int[] lst = this.list;
        int e = lst[index];
        Array.remove(lst, index, 1, this.size);
        --this.size;
        return e;
    }

    public void incFrom(int diff, int index) {
        int[] lst = this.list;
        int s = this.size;
        int l = index;
        while (l < s) {
            int n = l++;
            lst[n] = lst[n] + diff;
        }
    }

    public int peek() {
        return this.list[this.size - 1];
    }

    public int pop() {
        return this.list[--this.size];
    }

    public void push(int element) {
        this.add(element);
    }

    public int sortedIndexOf(int element) {
        return Arrays.binarySearch(this.list, 0, this.size, element);
    }

    public int[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public int[] finish() {
        int[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == lst.length ? lst : Arrays.copyOf(lst, s);
    }

    public IntList ddo() {
        if (!this.isEmpty()) {
            this.sort();
            int i = 1;
            for (int j = 1; j < this.size; ++j) {
                while (j < this.size && this.list[i - 1] == this.list[j]) {
                    ++j;
                }
                if (j >= this.size) continue;
                this.list[i++] = this.list[j];
            }
            this.size = i;
        }
        return this;
    }

    public int[] createOrder(boolean asc) {
        IntList il = Array.number(this.size);
        il.sort(this.list, asc);
        return il.finish();
    }

    public IntList sort() {
        int s = this.size;
        if (s > 1) {
            Arrays.sort(this.list, 0, s);
        }
        return this;
    }

    public void sort(byte[][] values, boolean asc, boolean num) {
        this.sort(values, asc, 0, this.size, num);
    }

    public void sort(double[] values, boolean asc) {
        this.sort(values, asc, 0, this.size);
    }

    public void sort(int[] values, boolean asc) {
        this.sort(values, asc, 0, this.size);
    }

    public void sort(long[] values, boolean asc) {
        this.sort(values, asc, 0, this.size);
    }

    private void sort(byte[][] values, boolean asc, int start, int length, boolean num) {
        int c;
        int a;
        if (length < 7) {
            block0: for (int i = start; i < length + start; ++i) {
                for (int j = i; j > start; --j) {
                    int h;
                    int n = h = num ? IntList.cmpNum(values[j - 1], values[j]) : IntList.cmp(values[j - 1], values[j]);
                    if (asc ? h < 0 : h > 0) continue block0;
                    this.swap(j, j - 1, values);
                }
            }
            return;
        }
        int m = start + (length >> 1);
        if (length > 7) {
            int l = start;
            int n = start + length - 1;
            if (length > 40) {
                int k = length >>> 3;
                l = this.median(l, l + k, l + (k << 1));
                m = this.median(m - k, m, m + k);
                n = this.median(n - (k << 1), n - k, n);
            }
            m = this.median(l, m, n);
        }
        byte[] v = values[m];
        int b = a = start;
        int d = c = start + length - 1;
        while (true) {
            int h;
            if (b <= c) {
                int n = h = num ? IntList.cmpNum(values[b], v) : IntList.cmp(values[b], v);
                if (!(!asc ? h < 0 : h > 0)) {
                    if (h == 0) {
                        this.swap(a++, b, values);
                    }
                    ++b;
                    continue;
                }
            }
            while (c >= b) {
                int n = h = num ? IntList.cmpNum(values[c], v) : IntList.cmp(values[c], v);
                if (!asc ? h > 0 : h < 0) break;
                if (h == 0) {
                    this.swap(c, d--, values);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--, values);
        }
        int n = start + length;
        int k = Math.min(a - start, b - a);
        this.swap(values, start, b - k, k);
        k = Math.min(d - c, n - d - 1);
        this.swap(values, b, n - k, k);
        k = b - a;
        if (k > 1) {
            this.sort(values, asc, start, k, num);
        }
        if ((k = d - c) > 1) {
            this.sort(values, asc, n - k, k, num);
        }
    }

    private void sort(double[] values, boolean asc, int start, int length) {
        int c;
        int a;
        if (length < 7) {
            block0: for (int i = start; i < length + start; ++i) {
                for (int j = i; j > start; --j) {
                    double h = values[j - 1] - values[j];
                    if (asc ? h < 0.0 : h > 0.0) continue block0;
                    this.swap(j, j - 1, values);
                }
            }
            return;
        }
        int m = start + (length >> 1);
        if (length > 7) {
            int l = start;
            int n = start + length - 1;
            if (length > 40) {
                int k = length >>> 3;
                l = this.median(l, l + k, l + (k << 1));
                m = this.median(m - k, m, m + k);
                n = this.median(n - (k << 1), n - k, n);
            }
            m = this.median(l, m, n);
        }
        double v = values[m];
        int b = a = start;
        int d = c = start + length - 1;
        while (true) {
            double h;
            if (b <= c) {
                h = values[b] - v;
                if (!(!asc ? h < 0.0 : h > 0.0)) {
                    if (h == 0.0) {
                        this.swap(a++, b, values);
                    }
                    ++b;
                    continue;
                }
            }
            while (c >= b) {
                h = values[c] - v;
                if (!asc ? h > 0.0 : h < 0.0) break;
                if (h == 0.0) {
                    this.swap(c, d--, values);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--, values);
        }
        int n = start + length;
        int k = Math.min(a - start, b - a);
        this.swap(values, start, b - k, k);
        k = Math.min(d - c, n - d - 1);
        this.swap(values, b, n - k, k);
        k = b - a;
        if (k > 1) {
            this.sort(values, asc, start, k);
        }
        if ((k = d - c) > 1) {
            this.sort(values, asc, n - k, k);
        }
    }

    private void sort(int[] values, boolean asc, int start, int length) {
        int c;
        int a;
        if (length < 7) {
            block0: for (int i = start; i < start + length; ++i) {
                for (int j = i; j > start; --j) {
                    int h = values[j - 1] - values[j];
                    if (asc ? h < 0 : h > 0) continue block0;
                    this.swap(j, j - 1, values);
                }
            }
            return;
        }
        int m = start + (length >> 1);
        if (length > 7) {
            int l = start;
            int n = start + length - 1;
            if (length > 40) {
                int k = length >>> 3;
                l = this.median(l, l + k, l + (k << 1));
                m = this.median(m - k, m, m + k);
                n = this.median(n - (k << 1), n - k, n);
            }
            m = this.median(l, m, n);
        }
        int v = values[m];
        int b = a = start;
        int d = c = start + length - 1;
        while (true) {
            int h;
            if (b <= c) {
                h = values[b] - v;
                if (!(!asc ? h < 0 : h > 0)) {
                    if (h == 0) {
                        this.swap(a++, b, values);
                    }
                    ++b;
                    continue;
                }
            }
            while (c >= b) {
                h = values[c] - v;
                if (!asc ? h > 0 : h < 0) break;
                if (h == 0) {
                    this.swap(c, d--, values);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--, values);
        }
        int n = start + length;
        int k = Math.min(a - start, b - a);
        this.swap(values, start, b - k, k);
        k = Math.min(d - c, n - d - 1);
        this.swap(values, b, n - k, k);
        k = b - a;
        if (k > 1) {
            this.sort(values, asc, start, k);
        }
        if ((k = d - c) > 1) {
            this.sort(values, asc, n - k, k);
        }
    }

    private void sort(long[] values, boolean asc, int start, int length) {
        int c;
        int a;
        if (length < 7) {
            block0: for (int i = start; i < length + start; ++i) {
                for (int j = i; j > start; --j) {
                    long h = values[j - 1] - values[j];
                    if (asc ? h < 0L : h > 0L) continue block0;
                    this.swap(values, j, j - 1);
                }
            }
            return;
        }
        int m = start + (length >> 1);
        if (length > 7) {
            int l = start;
            int n = start + length - 1;
            if (length > 40) {
                int k = length >>> 3;
                l = this.median(l, l + k, l + (k << 1));
                m = this.median(m - k, m, m + k);
                n = this.median(n - (k << 1), n - k, n);
            }
            m = this.median(l, m, n);
        }
        long v = values[m];
        int b = a = start;
        int d = c = start + length - 1;
        while (true) {
            long h;
            if (b <= c) {
                h = values[b] - v;
                if (!(!asc ? h < 0L : h > 0L)) {
                    if (h == 0L) {
                        this.swap(values, a++, b);
                    }
                    ++b;
                    continue;
                }
            }
            while (c >= b) {
                h = values[c] - v;
                if (!asc ? h > 0L : h < 0L) break;
                if (h == 0L) {
                    this.swap(values, c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(values, b++, c--);
        }
        int n = start + length;
        int k = Math.min(a - start, b - a);
        this.swap(values, start, b - k, k);
        k = Math.min(d - c, n - d - 1);
        this.swap(values, b, n - k, k);
        k = b - a;
        if (k > 1) {
            this.sort(values, asc, start, k);
        }
        if ((k = d - c) > 1) {
            this.sort(values, asc, n - k, k);
        }
    }

    private static int cmpNum(byte[] value1, byte[] value2) {
        double n = Token.toDouble(value1) - Token.toDouble(value2);
        return n > 0.0 ? 1 : (n < 0.0 ? -1 : 0);
    }

    private static int cmp(byte[] value1, byte[] value2) {
        return value1 == null ? (value2 == null ? 0 : -1) : (value2 == null ? 1 : Token.compare(value1, value2));
    }

    private void swap(int a, int b, byte[][] values) {
        int l = this.list[a];
        this.list[a] = this.list[b];
        this.list[b] = l;
        byte[] c = values[a];
        values[a] = values[b];
        values[b] = c;
    }

    private void swap(int a, int b, double[] values) {
        int l = this.list[a];
        this.list[a] = this.list[b];
        this.list[b] = l;
        double c = values[a];
        values[a] = values[b];
        values[b] = c;
    }

    private void swap(int a, int b, int[] values) {
        int l = this.list[a];
        this.list[a] = this.list[b];
        this.list[b] = l;
        int c = values[a];
        values[a] = values[b];
        values[b] = c;
    }

    private void swap(long[] values, int a, int b) {
        int l = this.list[a];
        this.list[a] = this.list[b];
        this.list[b] = l;
        long c = values[a];
        values[a] = values[b];
        values[b] = c;
    }

    private void swap(byte[][] values, int a, int b, int length) {
        for (int i = 0; i < length; ++i) {
            this.swap(a + i, b + i, values);
        }
    }

    private void swap(double[] values, int a, int b, int length) {
        for (int i = 0; i < length; ++i) {
            this.swap(a + i, b + i, values);
        }
    }

    private void swap(int[] values, int a, int b, int length) {
        for (int i = 0; i < length; ++i) {
            this.swap(a + i, b + i, values);
        }
    }

    private void swap(long[] values, int a, int b, int length) {
        for (int i = 0; i < length; ++i) {
            this.swap(values, a + i, b + i);
        }
    }

    private int median(int a, int b, int c) {
        return this.list[a] < this.list[b] ? (this.list[b] < this.list[c] ? b : (this.list[a] < this.list[c] ? c : a)) : (this.list[b] > this.list[c] ? b : (this.list[a] > this.list[c] ? c : a));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof IntList)) return false;
        IntList l = (IntList)obj;
        if (!Arrays.equals(this.list, 0, this.size, l.list, 0, l.size)) return false;
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Arrays.toString(this.toArray());
    }
}

