/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.Copy;
import org.basex.core.cmd.CreateBackup;
import org.basex.core.cmd.DropBackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Restore;
import org.basex.core.cmd.ShowBackups;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.gui.GUI;
import org.basex.gui.dialog.DialogInput;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXList;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.RowLayout;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DialogManage
extends BaseXDialog {
    private final BaseXList choice;
    private final BaseXLabel doc1;
    private final BaseXLabel doc2;
    private final TextPanel detail;
    private final BaseXButton rename;
    private final BaseXButton drop;
    private final BaseXButton open;
    private final BaseXButton backup;
    private final BaseXButton restore;
    private final BaseXButton copy;
    private final BaseXList backups;
    private final BaseXLabel comment;
    private final BaseXButton delete;
    private final BaseXButton deleteAll;
    private boolean refresh;

    public DialogManage(GUI gui) {
        super(gui, Text.MANAGE_DB);
        this.panel.setLayout(new BorderLayout(4, 0));
        String[] dbs = (String[])gui.context.databases.all().finish();
        this.choice = new BaseXList((BaseXDialog)this, false, dbs);
        this.choice.setSize(240, 600);
        Data data = gui.context.data();
        if (data != null) {
            data.flush(true);
            this.choice.setValue(data.meta.name);
        }
        this.doc1 = new BaseXLabel(" ").large();
        this.detail = new TextPanel(this, false);
        this.detail.setFont(this.panel.getFont());
        this.detail.setPreferredSize(new Dimension(600, 1));
        this.rename = new BaseXButton(this, Text.RENAME + "...");
        this.copy = new BaseXButton(this, Text.COPY + "...");
        this.open = new BaseXButton(this, Text.OPEN);
        this.drop = new BaseXButton(this, Text.DROP + "...");
        BaseXBack tab1 = new BaseXBack(new BorderLayout(0, 8)).border(8);
        tab1.add((Component)this.doc1, "North");
        tab1.add((Component)new SearchEditor(gui, this.detail), "Center");
        tab1.add((Component)this.newButtons(this.drop, this.rename, this.copy, this.open), "South");
        this.doc2 = new BaseXLabel(" ").border(0, 0, 6, 0);
        this.doc2.setFont(this.doc1.getFont());
        this.backups = new BaseXList((BaseXDialog)this, new String[0]);
        this.backups.setSize(600, 420);
        this.comment = new BaseXLabel("x ");
        BaseXBack back = new BaseXBack(new RowLayout(8));
        back.add(this.backups);
        back.add(new BaseXLabel(Text.COMMENT + ":", false, true));
        back.add(this.comment);
        this.backup = new BaseXButton(this, Text.BACKUP);
        this.restore = new BaseXButton(this, Text.RESTORE);
        this.delete = new BaseXButton(this, Text.DELETE);
        this.deleteAll = new BaseXButton(this, Text.DELETE_ALL + "...");
        BaseXBack tab2 = new BaseXBack(new BorderLayout(0, 8)).border(8);
        tab2.add((Component)this.doc2, "North");
        tab2.add((Component)back, "Center");
        tab2.add((Component)this.newButtons(this.backup, this.restore, this.delete, this.deleteAll), "South");
        BaseXTabs tabs = new BaseXTabs(this);
        tabs.addTab(Text.INFORMATION, tab1);
        tabs.addTab(Text.BACKUPS, tab2);
        this.set(this.choice, "Center");
        this.set(tabs, "East");
        this.action(null);
        if (dbs.length != 0) {
            this.finish();
        }
    }

    public boolean nodb() {
        return this.choice.getList().length == 0;
    }

    @Override
    public void action(Object cmp) {
        Context ctx = this.gui.context;
        if (this.refresh) {
            this.choice.setData((String[])ctx.databases.all().finish());
            this.choice.requestFocusInWindow();
            this.refresh = false;
        }
        StringList dbs = this.choice.getValues();
        String db = this.choice.getValue();
        ArrayList<Command> cmds = new ArrayList<Command>();
        if (cmp == this.open) {
            this.close();
        } else if (cmp == this.drop) {
            for (String s : dbs) {
                if (!ctx.soptions.dbExists(s)) continue;
                cmds.add(new DropDB(s));
            }
            if (!BaseXDialog.confirm(this.gui, Util.info(Text.DROPPING_DB_X, cmds.size()))) {
                return;
            }
            this.refresh = true;
        } else if (cmp == this.rename) {
            DialogInput input = new DialogInput(db, this, DialogInput.Action.ALTER_DATABASE);
            if (!input.ok() || input.input().equals(db)) {
                return;
            }
            cmds.add(new AlterDB(db, input.input()));
            this.refresh = true;
        } else if (cmp == this.copy) {
            DialogInput input = new DialogInput(db, this, DialogInput.Action.COPY_DATABASE);
            if (!input.ok() || input.input().equals(db)) {
                return;
            }
            cmds.add(new Copy(db, input.input()));
            this.refresh = true;
        } else if (cmp == this.backup) {
            DialogInput input = new DialogInput("", this, DialogInput.Action.CREATE_BACKUP);
            if (!input.ok()) {
                return;
            }
            for (String name : dbs) {
                cmds.add(new CreateBackup(name, input.input()));
            }
        } else if (cmp == this.restore) {
            if (!this.gui.context.soptions.dbExists(db) || BaseXDialog.confirm(this.gui, Text.OVERWRITE_DB_QUESTION)) {
                cmds.add(new Restore(this.backups.getValue()));
            }
        } else if (cmp == this.backups) {
            this.comment.setText(ShowBackups.comment(this.backups.getValue(), ctx));
        } else if (cmp == this.delete) {
            if (!BaseXDialog.confirm(this.gui, Util.info(Text.DROP_BACKUPS_X, 1))) {
                return;
            }
            cmds.add(new DropBackup(this.backups.getValue()));
            this.refresh = this.backups.getList().length == 1;
            this.backups.requestFocusInWindow();
        } else if (cmp == this.deleteAll) {
            String[] back = this.backups.getList();
            if (!BaseXDialog.confirm(this.gui, Util.info(Text.DROP_BACKUPS_X, back.length))) {
                return;
            }
            for (String b : back) {
                cmds.add(new DropBackup(b));
            }
            this.refresh = true;
        } else {
            String title = dbs.size() == 1 ? db : dbs.size() + " " + Text.DATABASES;
            this.doc1.setChoppedText(title, 600);
            this.doc2.setChoppedText(Text.BACKUPS + ": " + title, 600);
            boolean active = ctx.soptions.dbExists(db);
            String info = "";
            if (active) {
                MetaData meta = new MetaData(db, ctx.options, ctx.soptions);
                try {
                    meta.read();
                    info = InfoDB.db(meta, true, true);
                }
                catch (IOException ex) {
                    info = Util.message(ex);
                }
            } else if (dbs.size() == 1) {
                info = Text.ONLY_BACKUP;
            }
            this.detail.setText(info);
            this.rename.setEnabled(active);
            this.copy.setEnabled(active);
            this.open.setEnabled(active);
            this.restore.setEnabled(active);
            active = false;
            for (String d : dbs) {
                active |= ctx.soptions.dbExists(d);
            }
            this.drop.setEnabled(active);
            this.backup.setEnabled(active);
            String[] names = (String[])ctx.databases.backups(db).finish();
            active = names.length != 0;
            this.backups.setData(names);
            this.backups.setEnabled(active);
            this.restore.setEnabled(active);
            this.delete.setEnabled(active);
            this.deleteAll.setEnabled(active);
            String name = this.backups.getValue();
            this.comment.setText(name.isEmpty() ? "" : ShowBackups.comment(name, ctx));
        }
        if (!cmds.isEmpty()) {
            DialogProgress.execute((BaseXDialog)this, (Command[])cmds.toArray(Command[]::new));
        }
    }

    @Override
    public void close() {
        String db = this.choice.getValue();
        if (this.gui.context.soptions.dbExists(db)) {
            DialogProgress.execute((BaseXDialog)this, new Open(db));
            this.dispose();
        }
    }
}

