/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.ArrayList;
import java.util.List;
import org.basex.data.Data;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Util;

public abstract class Test
extends ExprInfo {
    public final NodeType type;

    Test(NodeType type) {
        this.type = type;
    }

    public static Test get(List<Test> tests) {
        int ts = tests.size();
        if (ts == 0) {
            return null;
        }
        if (ts == 1) {
            return tests.get(0);
        }
        ArrayList<Test> list = new ArrayList<Test>(ts);
        for (Test test : tests) {
            if (test instanceof UnionTest) {
                UnionTest ut = (UnionTest)test;
                for (Test t : ut.tests) {
                    Test.merge(t, list);
                }
                continue;
            }
            if (test != null) {
                Test.merge(test, list);
                continue;
            }
            return null;
        }
        return list.size() == 1 ? (Test)list.get(0) : new UnionTest((Test[])list.toArray(Test[]::new));
    }

    private static void merge(Test test, List<Test> list) {
        boolean ntest = test instanceof NameTest;
        boolean utest = ntest && ((NameTest)test).scope == NameTest.Scope.URI;
        int ls = list.size();
        for (int l = 0; l < ls; ++l) {
            Test t = list.get(l);
            if (ntest && t instanceof NameTest) {
                NameTest nt = (NameTest)t;
                if (utest || nt.scope == NameTest.Scope.URI) continue;
            }
            if (test.instanceOf(t)) {
                return;
            }
            if (!t.instanceOf(test)) continue;
            list.set(l, test);
            return;
        }
        list.add(test);
    }

    public Test optimize(Data data) {
        return this;
    }

    public abstract boolean matches(ANode var1);

    public final boolean matches(Item item) {
        ANode node;
        return item instanceof ANode && this.matches(node = (ANode)item);
    }

    public Boolean matches(SeqType seqType) {
        return null;
    }

    public abstract Test copy();

    public boolean instanceOf(Test test) {
        boolean bl;
        if (test instanceof UnionTest) {
            UnionTest ut = (UnionTest)test;
            bl = ut.instance(this);
        } else {
            bl = this.type.instanceOf(test.type);
        }
        return bl;
    }

    public abstract Test intersect(Test var1);

    public abstract String toString(boolean var1);

    @Override
    public void toXml(QueryPlan plan) {
        throw Util.notExpected();
    }

    @Override
    public final void toString(QueryString qs) {
        qs.token(this.toString(true));
    }
}

