/*
** Copyright (c) 2002, 2003, 2004, 2005 Alexis Megas
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 3. The name of the author may not be used to endorse or promote products
**    derived from this software without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
** INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
** NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
** THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
** -- X Includes --
*/

#include <Xm/Form.h>
#include <Xm/List.h>
#include <Xm/Text.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/TextF.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrolledW.h>

/*
** -- C Includes --
*/

#include <pwd.h>
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

/*
** -- MySQL Includes --
*/

#include <mysql.h>

/*
** -- Defines --
*/

#define ERROR 0
#define WIDTH 800
#define HEIGHT 700
#define INSERT 0
#define MODIFY 1
#define NFIELDS 11
#define NONERROR 1

/*
** -- Function Declarations --
*/

extern int snprintf(char *, size_t, const char *, ...);
static void resize();
static void loadData(const char *);
static void popupMsg(const Widget, const char * const, const int);
static void writeCb(Widget, XtPointer, XtPointer);
static void wCallback(Widget, XtPointer, XtPointer);
static void fillPulldowns(const Widget, FILE *, const char *);
static void createIMWindow(const Widget, const char *);
static void fdialogCancelCb(Widget, XtPointer, XtPointer);

/*
** -- Global Variables --
*/

static int allow = FALSE;
static int which = -1;
static int fieldsizes[] = {32,
			   512,
			   512,
			   32,
			   512,
			   6};
static const char *fields[] = {"ISBN (required)",
			       "Title (required)",
			       "Edition",
			       "Author (required)",
			       "Publication Date (required)",
			       "Publisher (required)",
			       "Category",
			       "Price (required)",
			       "Language",
			       "Monetary Units"};
static const char *editions[] = {"1st",
				 "2nd",
				 "3rd",
				 "4th",
				 "5th",
				 "6th",
				 "7th",
				 "8th",
				 "9th",
				 "10th",
				 "11th",
				 "12th",
				 "13th",
				 "14th",
				 "15th"};
static const char *languages[] = {"English",
				  "French",
				  "German",
				  "Greek",
				  "Lakota",
				  "Romanian",
				  "Russian"};
static const char *categories[] = {"Biography",
				   "Biology",
				   "Chemistry",
				   "Computer Science",
				   "Engineering",
                                   "Fantasy",
				   "Fiction",
				   "History",
				   "Literature",
				   "Mathematics",
				   "Medicine",
				   "Non-Fiction",
				   "Poetry",
				   "Puzzle",
				   "Reference",
				   "Technical"};
static const char *fieldnames[] = {"ISBN",
				   "Title",
				   "Edition",
				   "Author",
				   "Pub. Date",
				   "Publisher",
				   "Category",
				   "Price",
				   "Description",
				   "Language",
				   "Monetary Units"};
static const char *monetaryunits[] = {"Dollar",
				      "Drachma",
				      "Franc",
				      "Leu"};
static MYSQL *connection = NULL;
static Widget ta_w = NULL;
static Widget tf_w[6];
static Widget list_w;
static Widget menu_w[4];
static Widget fdialog = NULL;
static Widget rowcol_w = NULL;
static Widget imshell_w = NULL;
static Widget titlepb_w = NULL;
static Widget scrolledw_w = NULL;
static Widget appmainform_w = NULL;

/*
** -- main() --
*/

int
main(int argc, char *argv[])
{
  int n = 0;
  Arg args[32];
  char line[64];
  char buffer[256];
  char *tmpstr = NULL;
  char filename[2048];
  FILE *fp = NULL;
  Widget sb_w = NULL;
  Widget form_w = NULL;
  Widget addpb_w = NULL;
  Widget exitpb_w = NULL;
  Widget filepb_w = NULL;
  Widget frame1_w = NULL;
  Widget frame2_w = NULL;
  Widget isbnpb_w = NULL;
  Widget statpb_w = NULL;
  Widget aboutpb_w = NULL;
  Widget authorpb_w = NULL;
  Widget deletepb_w = NULL;
  Widget modifypb_w = NULL;
  Widget toplevel_w = NULL;
  Widget editionpb_w = NULL;
  Widget pubdatepb_w = NULL;
  Widget categorypb_w = NULL;
  Widget headerform_w = NULL;
  Widget languagepb_w = NULL;
  Widget publisherpb_w = NULL;
  XmString xmstr;
  Dimension dim1 = 0;
  Dimension dim2 = 0;
  Dimension dim3 = 0;
  Dimension dim4 = 0;
  XtActionsRec rec;
  XtAppContext app;
  struct passwd *pwd = NULL;

  if(argc != 3)
    {
      (void) printf("Usage: xbook host dir.\n");
      return EXIT_FAILURE;
    }

  if((connection = mysql_init(NULL)) == NULL)
    {
      (void) printf("Error: mysql_init() failure.\n");
      return EXIT_FAILURE;
    }

  if(mysql_real_connect(connection,
			argv[1],
			DB_USER, DB_PASSWORD,
			DB_NAME, 0, NULL, 0) == NULL)
    {
      (void) printf("Error: mysql_real_connect() failure (%s).\n",
		    mysql_error(connection));
      return EXIT_FAILURE;
    }

  /*
  ** Build the UI.
  */

  (void) XtSetLanguageProc(NULL,
			   NULL,
			   NULL);

  /*
  ** Initialize the display.
  */

  toplevel_w = XtAppInitialize(&app,
			       "toplevel_w",
			       NULL,
			       0,
			       &argc,
			       argv,
			       NULL,
			       NULL,
			       0);

  /*
  ** Set the title of the main display and other attributes.
  */

  tmpstr = (char *) "XBook";
  XtVaSetValues(toplevel_w,
		XmNtitle,
		tmpstr,
		XmNminHeight,
		HEIGHT / 2,
		XmNminWidth,
		WIDTH,
		NULL);

  /*
  ** Create the main form.
  */

  appmainform_w = XtVaCreateManagedWidget("appmainform_w",
					  xmFormWidgetClass,
					  toplevel_w,
					  XmNheight,
					  HEIGHT,
					  XmNwidth,
					  WIDTH,
					  NULL);

  /*
  ** Create a RowColumn widget.
  */

  rowcol_w = XtVaCreateManagedWidget("rowcol_w",
				     xmRowColumnWidgetClass,
				     appmainform_w,
				     XmNorientation,
				     XmHORIZONTAL,
				     XmNpacking,
				     XmPACK_COLUMN,
				     XmNbottomAttachment,
				     XmATTACH_FORM,
				     XmNleftAttachment,
				     XmATTACH_FORM,
				     XmNrightAttachment,
				     XmATTACH_FORM,
				     XmNleftOffset,
				     10,
				     XmNbottomOffset,
				     10,
				     XmNrightOffset,
				     10,
				     XmNentryAlignment,
				     XmALIGNMENT_CENTER,
				     NULL);

  /*
  ** Is the user trustworthy?
  */

  if((pwd = getpwuid(geteuid())) != NULL)
    {
      if(argv[2] != NULL && strlen(argv[2]) > 0)
	(void) snprintf(filename, sizeof(filename),
			"%s/xbook_superusers.dat", argv[2]);
      else
	(void) snprintf(filename, sizeof(filename), "xbook_superusers.dat");

      if((fp = fopen(filename, "r")) != NULL)
	{
	  while(fgets(line, sizeof(line), fp) != NULL)
	    if(strncmp(line, pwd->pw_name, strlen(pwd->pw_name)) == 0)
	      {
		allow = TRUE;
		break;
	      }

	  (void) fclose(fp);
	}
      else
	allow = FALSE;
    }
  else
    allow = FALSE;

  /*
  ** Create the buttons and insert them into the RowColumn widget.
  */
  
  xmstr = XmStringCreateLocalized((char *) "Insert");
  addpb_w = XtVaCreateManagedWidget("addpb_w",
				    xmPushButtonWidgetClass,
				    rowcol_w,
				    XmNlabelString,
				    xmstr,
				    NULL);
  XmStringFree(xmstr);
  xmstr = XmStringCreateLocalized((char *) "Delete");
  deletepb_w = XtVaCreateManagedWidget("deletepb_w",
				       xmPushButtonWidgetClass,
				       rowcol_w,
				       XmNlabelString,
				       xmstr,
				       NULL);
  XmStringFree(xmstr);
  xmstr = XmStringCreateLocalized((char *) "Modify");
  modifypb_w = XtVaCreateManagedWidget("modifypb_w",
				       xmPushButtonWidgetClass,
				       rowcol_w,
				       XmNlabelString,
				       xmstr,
				       NULL);
  XmStringFree(xmstr);
  xmstr = XmStringCreateLocalized((char *) "Save as HTML");
  filepb_w = XtVaCreateManagedWidget("filepb_w",
				     xmPushButtonWidgetClass,
				     rowcol_w,
				     XmNlabelString,
				     xmstr,
				     NULL);
  XmStringFree(xmstr);
  xmstr = XmStringCreateLocalized((char *) "Statistics");
  statpb_w = XtVaCreateManagedWidget("statpb_w",
				     xmPushButtonWidgetClass,
				     rowcol_w,
				     XmNlabelString,
				     xmstr,
				     NULL);
  XmStringFree(xmstr);
  xmstr = XmStringCreateLocalized((char *) "About");
  aboutpb_w = XtVaCreateManagedWidget("aboutpb_w",
				      xmPushButtonWidgetClass,
				      rowcol_w,
				      XmNlabelString,
				      xmstr,
				      NULL);
  XmStringFree(xmstr);
  xmstr = XmStringCreateLocalized((char *) "Exit");
  exitpb_w = XtVaCreateManagedWidget("exitpb_w",
				     xmPushButtonWidgetClass,
				     rowcol_w,
				     XmNlabelString,
				     xmstr,
				     NULL);
  XmStringFree(xmstr);
  scrolledw_w = XtVaCreateManagedWidget("scrolledw_w",
					xmScrolledWindowWidgetClass,
					appmainform_w,
					XmNscrollingPolicy,
					XmAUTOMATIC,
					NULL);
  XtVaSetValues(scrolledw_w,
		XmNtopAttachment,
		XmATTACH_FORM,
		XmNleftAttachment,
		XmATTACH_FORM,
		XmNrightAttachment,
		XmATTACH_FORM,
		XmNbottomAttachment,
		XmATTACH_WIDGET,
		XmNbottomWidget,
		rowcol_w,
		XmNtopOffset,
		10,
		XmNbottomOffset,
		10,
		XmNleftOffset,
		10,
		XmNrightOffset,
		10,
		NULL);
  form_w = XtVaCreateManagedWidget("form_w",
				   xmFormWidgetClass,
				   scrolledw_w,
				   XmNtopAttachment,
				   XmATTACH_FORM,
				   XmNbottomAttachment,
				   XmATTACH_NONE,
				   XmNleftAttachment,
				   XmATTACH_FORM,
				   XmNrightAttachment,
				   XmATTACH_FORM,
				   NULL);

  /*
  ** Create a frame widget to store the list widget in.
  */

  frame1_w = XtVaCreateManagedWidget("frame1_w",
				     xmFrameWidgetClass,
				     form_w,
				     NULL);

  /*
  ** Create a RowColumn widget for the headers.
  */

  frame2_w = XtVaCreateManagedWidget("frame2_w",
				     xmFrameWidgetClass,
				     form_w,
				     XmNtopAttachment,
				     XmATTACH_FORM,
				     XmNleftAttachment,
				     XmATTACH_FORM,
				     XmNrightAttachment,
				     XmATTACH_FORM,
				     XmNbottomAttachment,
				     XmATTACH_NONE,
				     NULL);
  XtVaSetValues(frame1_w,
		XmNtopAttachment,
		XmATTACH_WIDGET,
		XmNtopWidget,
		frame2_w,
		XmNleftAttachment,
		XmATTACH_FORM,
		XmNrightAttachment,
		XmATTACH_FORM,
		XmNbottomAttachment,
		XmATTACH_NONE,
		NULL);
  headerform_w = XtVaCreateManagedWidget("headerform_w",
					 xmFormWidgetClass,
					 frame2_w,
					 XmNleftAttachment,
					 XmATTACH_FORM,
					 XmNrightAttachment,
					 XmATTACH_FORM,
					 XmNtopAttachment,
					 XmATTACH_FORM,
					 NULL);
  (void) snprintf(buffer, 48, "%s", "Title");
  xmstr = XmStringCreateLocalized(buffer);
  titlepb_w = XtVaCreateManagedWidget("titlepb_w",
				      xmPushButtonWidgetClass,
				      headerform_w,
				      XmNlabelString,
				      xmstr,
				      XmNleftAttachment,
				      XmATTACH_FORM,
				      XmNtopAttachment,
				      XmATTACH_FORM,
				      XmNbottomAttachment,
				      XmATTACH_FORM,
				      XmNalignment,
				      XmALIGNMENT_CENTER,
				      XmNwidth,
				      460,
				      NULL);
  XmStringFree(xmstr);
  (void) snprintf(buffer, 48, "%s", "Author");
  xmstr = XmStringCreateLocalized(buffer);
  authorpb_w = XtVaCreateManagedWidget("authorpb_w",
				       xmPushButtonWidgetClass,
				       headerform_w,
				       XmNlabelString,
				       xmstr,
				       XmNleftAttachment,
				       XmATTACH_WIDGET,
				       XmNleftWidget,
				       titlepb_w,
				       XmNtopAttachment,
				       XmATTACH_FORM,
				       XmNbottomAttachment,
				       XmATTACH_FORM,
				       XmNalignment,
				       XmALIGNMENT_CENTER,
				       XmNwidth,
				       460,
				       NULL);
  XmStringFree(xmstr);
  (void) snprintf(buffer, 48, "%s", "Publisher");
  xmstr = XmStringCreateLocalized(buffer);
  publisherpb_w = XtVaCreateManagedWidget("publisherpb_w",
					  xmPushButtonWidgetClass,
					  headerform_w,
					  XmNlabelString,
					  xmstr,
					  XmNleftAttachment,
					  XmATTACH_WIDGET,
					  XmNleftWidget,
					  authorpb_w,
					  XmNtopAttachment,
					  XmATTACH_FORM,
					  XmNbottomAttachment,
					  XmATTACH_FORM,
					  XmNalignment,
					  XmALIGNMENT_CENTER,
					  XmNwidth,
					  340,
					  NULL);
  XmStringFree(xmstr);
  (void) snprintf(buffer, 32, "%s", "Publication Date");
  xmstr = XmStringCreateLocalized(buffer);
  pubdatepb_w = XtVaCreateManagedWidget("pubdatepb_w",
					xmPushButtonWidgetClass,
					headerform_w,
					XmNlabelString,
					xmstr,
					XmNleftAttachment,
					XmATTACH_WIDGET,
					XmNleftWidget,
					publisherpb_w,
					XmNtopAttachment,
					XmATTACH_FORM,
					XmNbottomAttachment,
					XmATTACH_FORM,
					XmNalignment,
					XmALIGNMENT_CENTER,
					XmNwidth,
					227,
					NULL);
  XmStringFree(xmstr);
  (void) snprintf(buffer, 16, "%s", "Edition");
  xmstr = XmStringCreateLocalized(buffer);
  editionpb_w = XtVaCreateManagedWidget("editionpb_w",
					xmPushButtonWidgetClass,
					headerform_w,
					XmNlabelString,
					xmstr,
					XmNleftAttachment,
					XmATTACH_WIDGET,
					XmNleftWidget,
					pubdatepb_w,
					XmNtopAttachment,
					XmATTACH_FORM,
					XmNbottomAttachment,
					XmATTACH_FORM,
					XmNalignment,
					XmALIGNMENT_CENTER,
					XmNwidth,
					113,
					NULL);
  XmStringFree(xmstr);
  (void) snprintf(buffer, 32, "%s", "Category");
  xmstr = XmStringCreateLocalized(buffer);
  categorypb_w = XtVaCreateManagedWidget("categorypb_w",
					 xmPushButtonWidgetClass,
					 headerform_w,
					 XmNlabelString,
					 xmstr,
					 XmNleftAttachment,
					 XmATTACH_WIDGET,
					 XmNleftWidget,
					 editionpb_w,
					 XmNtopAttachment,
					 XmATTACH_FORM,
					 XmNbottomAttachment,
					 XmATTACH_FORM,
					 XmNalignment,
					 XmALIGNMENT_CENTER,
					 XmNwidth,
					 227,
					 NULL);
  XmStringFree(xmstr);
  (void) snprintf(buffer, 16, "%s", "Language");
  xmstr = XmStringCreateLocalized(buffer);
  languagepb_w = XtVaCreateManagedWidget("languagepb_w",
					 xmPushButtonWidgetClass,
					 headerform_w,
					 XmNlabelString,
					 xmstr,
					 XmNleftAttachment,
					 XmATTACH_WIDGET,
					 XmNleftWidget,
					 categorypb_w,
					 XmNtopAttachment,
					 XmATTACH_FORM,
					 XmNbottomAttachment,
					 XmATTACH_FORM,
					 XmNalignment,
					 XmALIGNMENT_CENTER,
					 XmNwidth,
					 113,
					 NULL);
  XmStringFree(xmstr);
  (void) snprintf(buffer, 32, "%s", "ISBN");
  xmstr = XmStringCreateLocalized(buffer);
  isbnpb_w = XtVaCreateManagedWidget("isbnpb_w",
				     xmPushButtonWidgetClass,
				     headerform_w,
				     XmNlabelString,
				     xmstr,
				     XmNleftAttachment,
				     XmATTACH_WIDGET,
				     XmNleftWidget,
				     languagepb_w,
				     XmNtopAttachment,
				     XmATTACH_FORM,
				     XmNbottomAttachment,
				     XmATTACH_FORM,
				     XmNalignment,
				     XmALIGNMENT_CENTER,
				     XmNwidth,
				     227,
				     NULL);
  XmStringFree(xmstr);

  /*
  ** Create and add the list widget.
  */

  n = 0;
  XtSetArg(args[n],
	   XmNlistSizePolicy,
	   XmVARIABLE); n++;
  XtSetArg(args[n],
	   XmNscrollBarDisplayPolicy,
	   XmSTATIC); n++;
  list_w = XmCreateScrolledList(frame1_w,
				(char *) "list_w",
				args,
				n);
  XtVaGetValues(appmainform_w,
		XmNheight,
		&dim1,
		NULL);
  XtVaGetValues(titlepb_w,
		XmNheight,
		&dim2,
		NULL);
  XtVaGetValues(rowcol_w,
		XmNheight,
		&dim3,
		NULL);
  XtVaGetValues(scrolledw_w,
		XmNhorizontalScrollBar,
		&sb_w,
		NULL);
  XtVaGetValues(sb_w,
		XmNheight,
		&dim4,
		NULL);
  XtVaSetValues(list_w,
		XmNheight,
		dim1 - (dim2 + dim3 + dim4 + 50),
		NULL);

  /*
  ** Add callbacks.
  */

  XtAddCallback(exitpb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(titlepb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(authorpb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(pubdatepb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(publisherpb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(editionpb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(categorypb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(languagepb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(isbnpb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(aboutpb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(addpb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(modifypb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(deletepb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(filepb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(statpb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(list_w,
		XmNdefaultActionCallback,
		wCallback,
		NULL);

  /*
  ** Load existing data.
  */

  loadData("title");

  /*
  ** Manage the children.
  */

  XtManageChild(list_w);

  /*
  ** Realize the main display.
  */

  XtRealizeWidget(toplevel_w);

  /*
  ** Create a file dialog.
  */

  fdialog = XmCreateFileSelectionDialog(toplevel_w,
					"fdialog",
					NULL,
					0);
  XtVaSetValues(fdialog,
		XmNdialogStyle,
		XmDIALOG_PRIMARY_APPLICATION_MODAL,
		NULL);
  tmpstr = (char *) "XBook";
  XtVaSetValues(XtParent(fdialog),
		XmNtitle,
		tmpstr,
		NULL);
  XtAddCallback(fdialog, XmNokCallback, writeCb, NULL);
  XtAddCallback(fdialog, XmNcancelCallback, fdialogCancelCb, NULL);
  XtUnmanageChild(XmFileSelectionBoxGetChild(fdialog, XmDIALOG_HELP_BUTTON));

  /*
  ** Create a window to allow the insertion and modification
  ** of new and existing entries.
  */

  createIMWindow(toplevel_w, argv[2]);

  /*
  ** Add a resize event.
  */

  rec.string = "resize";
  rec.proc = resize;
  XtAppAddActions(app, &rec, 1);
  XtOverrideTranslations(toplevel_w,
			 XtParseTranslationTable("<Configure>: resize()"));

  /*
  ** Start an endless loop.
  */

  XtAppMainLoop(app);

  /*
  ** Disconnect from the database.
  ** This may never be reached, unless XtAppMainLoop() fails.
  */

  (void) mysql_close(connection);

  /*
  ** Necessary.
  */

  return EXIT_SUCCESS;
}

/*
** -- wCallback() --
*/

static void
wCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
  int i = 0;
  int j = 0;
  int n = 0;
  int end = 0;
  int error = 0;
  int index[4];
  int spaces = 0;
  char buffer[2048];
  char resultbuff[2048];
  char isbn[33];
  char *tmpstr = NULL;
  char *tmpstr_om[4];
  char tmpstr_ta[256];
  char tmpstr_tf[6][256];
  Widget m_w = NULL;
  Widget last_w = NULL;
  XmString xmstr;
  MYSQL_RES *res_set = NULL;
  MYSQL_ROW row;
  WidgetList buttons_w;
  XmStringTable xmstringtable = 0;

  if((tmpstr = XtName(w)) == NULL)
    {
      popupMsg(appmainform_w, "Error: XtName() failure.", ERROR);
      return;
    }
  else if(strcmp(tmpstr, "exitpb_w") == 0)
    {
      (void) mysql_close(connection);
      exit(EXIT_SUCCESS);
    }
  else if(strcmp(tmpstr, "filepb_w") == 0)
    {
      /*
      ** Display a selection dialog.
      */

      tmpstr = XmTextFieldGetString
	(XmFileSelectionBoxGetChild(fdialog, XmDIALOG_FILTER_TEXT));

      if(strcmp(tmpstr + strlen(tmpstr) - 5, ".html") != 0)
	(void) snprintf(buffer, sizeof(buffer), "%s.html", tmpstr);
      else
	(void) snprintf(buffer, sizeof(buffer), "%s", tmpstr);

      XtFree(tmpstr);
      XmTextFieldSetString
	(XmFileSelectionBoxGetChild(fdialog, XmDIALOG_FILTER_TEXT), buffer);
      xmstr = XmStringCreateLocalized(buffer);
      XmFileSelectionDoSearch(fdialog, xmstr);
      XmStringFree(xmstr);
      XtManageChild(fdialog);
    }
  else if(strcmp(tmpstr, "aboutpb_w") == 0)
    popupMsg(appmainform_w, "XBook Version 2.0.\n"
	     "Copyright (c) 2002, 2003, 2004, 2005 Alexis Megas.", NONERROR);
  else if(strcmp(tmpstr, "titlepb_w") == 0)
    loadData("title");
  else if(strcmp(tmpstr, "authorpb_w") == 0)
    loadData("author");
  else if(strcmp(tmpstr, "pubdatepb_w") == 0)
    loadData("pdate");
  else if(strcmp(tmpstr, "languagepb_w") == 0)
    loadData("language");
  else if(strcmp(tmpstr, "isbnpb_w") == 0)
    loadData("isbn");
  else if(strcmp(tmpstr, "publisherpb_w") == 0)
    loadData("publisher");
  else if(strcmp(tmpstr, "editionpb_w") == 0)
    loadData("edition");
  else if(strcmp(tmpstr, "categorypb_w") == 0)
    loadData("category");
  else if(strcmp(tmpstr, "addpb_w") == 0 && allow)
    {
      XmTextSetString(ta_w, (char *) "");

      for(i = 0; i < sizeof(tf_w) / sizeof(tf_w[0]); i++)
	XmTextFieldSetString(tf_w[i], (char *) "");

      for(i = 0; i < sizeof(menu_w) / sizeof(menu_w[0]); i++)
	{
	  XtVaGetValues(menu_w[i],
			XmNsubMenuId,
			&m_w,
			NULL);
	  XtVaGetValues(m_w,
			XmNnumChildren,
			&n,
			XmNchildren,
			&buttons_w,
			NULL);
	  XtVaSetValues(menu_w[i],
			XmNmenuHistory,
			buttons_w[0],
			NULL);
	}

      which = INSERT;
      XtPopdown(imshell_w);
      XtPopup(imshell_w, XtGrabNone);
    }
  else if((strcmp(tmpstr, "modifypb_w") == 0 ||
	   strcmp(tmpstr, "list_w") == 0))
    {
      /*
      ** Obtain the current item from the list widget.
      */

      XtVaGetValues(list_w,
		    XmNselectedItemCount,
		    &i,
		    XmNselectedItems,
		    &xmstringtable,
		    NULL);

      if(i > 0)
	{
	  which = MODIFY;
	  XmStringGetLtoR(xmstringtable[0], XmFONTLIST_DEFAULT_TAG, &tmpstr);

	  /*
	  ** Grab the ISBN, which is the last token.
	  */

	  if(tmpstr != NULL)
	    {
	      (void) memset(buffer, '\0', sizeof(buffer));

	      for(end = strlen(tmpstr) - 1; end >= 0; end--)
		if(!isspace((int) tmpstr[end]))
		  break;

	      for(i = end; i >= 0; i--)
		if(isspace((int) tmpstr[i]))
		  break;

	      for(i = i + 1, j = 0; i <= end; i++, j++)
		buffer[j] = tmpstr[i];

	      (void) memset(isbn, '\0', sizeof(isbn));
	      (void) strncpy(isbn, buffer, sizeof(isbn) - 1);
	      XtFree(tmpstr);

	      /*
	      ** Fill the display with the data from the database.
	      */

	      (void) snprintf(buffer, sizeof(buffer),
			      "SELECT isbn, title, edition, author, pdate, "
			      "publisher, category, price, description, "
			      "language, "
			      "monetary_units FROM book WHERE isbn = '%s'",
			      isbn);

	      if(mysql_query(connection, buffer) != 0)
		{
		  popupMsg(appmainform_w, "Error: Unable to retrieve data.",
			   ERROR);
		  return;
		}

	      if((res_set = mysql_store_result(connection)) == NULL)
		{
		  popupMsg(appmainform_w, "Error: mysql_store_result() "
			   "failure.",
			   ERROR);
		  return;
		}

	      if((row = mysql_fetch_row(res_set)) != NULL)
		{
		  XmTextFieldSetString(tf_w[0], row[0]);
		  XmTextFieldSetString(tf_w[1], row[1]);
		  XmTextFieldSetString(tf_w[2], row[3]);
		  XmTextFieldSetString(tf_w[3], row[4]);
		  XmTextFieldSetString(tf_w[4], row[5]);
		  XmTextSetString(ta_w, row[8]);
		  XmTextFieldSetString(tf_w[5], row[7]);

		  /*
		  ** Update the pulldown menus.
		  */

		  index[0] = 2;
		  index[1] = 6;
		  index[2] = 9;
		  index[3] = 10;

		  for(i = 0; i < sizeof(menu_w) / sizeof(menu_w[0]); i++)
		    {
		      XtVaGetValues(menu_w[i],
				    XmNsubMenuId,
				    &m_w,
				    NULL);
		      XtVaGetValues(m_w,
				    XmNnumChildren,
				    &n,
				    XmNchildren,
				    &buttons_w,
				    NULL);

		      for(j = 0; j < n; j++)
			{
			  tmpstr = NULL;
			  XtVaGetValues(buttons_w[j],
					XmNlabelString,
					&xmstr,
					NULL);
			  XmStringGetLtoR(xmstr,
					  XmFONTLIST_DEFAULT_TAG,
					  &tmpstr);

			  if(tmpstr != NULL)
			    {
			      if(strcmp(tmpstr, row[index[i]]) == 0)
				{
				  XtVaSetValues(menu_w[i],
						XmNmenuHistory,
						buttons_w[j],
						NULL);
				  XtFree(tmpstr);
				  break;
				}

			      XtFree(tmpstr);
			    }
			}
		    }

		  XtPopdown(imshell_w);
		  XtPopup(imshell_w, XtGrabNone);
		}
	      else
		popupMsg(appmainform_w, "Error: Unable to retrieve data.",
			 ERROR);

	      (void) mysql_free_result(res_set);
	    }
	}
    }
  else if(strcmp(tmpstr, "closepb_w") == 0)
    XtPopdown(imshell_w);
  else if(allow && strcmp(tmpstr, "savepb_w") == 0)
    {
      /*
      ** Save the data.
      */

      tmpstr = XmTextGetString(ta_w);
      (void) mysql_escape_string(tmpstr_ta, tmpstr, strlen(tmpstr));
      XtFree(tmpstr);

      for(i = 0; i < sizeof(tf_w) / sizeof(tf_w[0]); i++)
	{
	  tmpstr = XmTextFieldGetString(tf_w[i]);
	  (void) mysql_escape_string(tmpstr_tf[i], tmpstr, strlen(tmpstr));
	  XtFree(tmpstr);
	}

      for(i = 0; i < sizeof(menu_w) / sizeof(menu_w[0]); i++)
	{
	  XtVaGetValues(menu_w[i],
			XmNmenuHistory,
			&last_w,
			NULL);
	  XtVaGetValues(last_w,
			XmNlabelString,
			&xmstr,
			NULL);
	  XmStringGetLtoR(xmstr, XmFONTLIST_DEFAULT_TAG, &tmpstr_om[i]);
	}

      if(which == MODIFY)
	(void) snprintf(buffer, sizeof(buffer),
			"UPDATE book SET isbn = LTRIM(RTRIM('%s')), "
			"title = LTRIM(RTRIM('%s')), edition = '%s', "
			"author = LTRIM(RTRIM('%s')), "
			"pdate = LTRIM(RTRIM('%s')), "
			"publisher = LTRIM(RTRIM('%s')), category = '%s', "
			"price = %s, description = LTRIM(RTRIM('%s')), "
			"language = '%s', monetary_units = '%s' WHERE "
			"isbn = LTRIM(RTRIM('%s'))",
			tmpstr_tf[0], tmpstr_tf[1], tmpstr_om[0],
			tmpstr_tf[2], tmpstr_tf[3], tmpstr_tf[4],
			tmpstr_om[1], tmpstr_tf[5], tmpstr_ta,
			tmpstr_om[2], tmpstr_om[3], tmpstr_tf[0]);
      else
	(void) snprintf(buffer, sizeof(buffer),
			"INSERT INTO book VALUES(LTRIM(RTRIM('%s')), "
			"LTRIM(RTRIM('%s')), "
			"'%s', LTRIM(RTRIM('%s')), LTRIM(RTRIM('%s')), "
			"LTRIM(RTRIM('%s')), '%s', "
			"%s, LTRIM(RTRIM('%s')), '%s', '%s')",
			tmpstr_tf[0], tmpstr_tf[1], tmpstr_om[0],
			tmpstr_tf[2], tmpstr_tf[3], tmpstr_tf[4],
			tmpstr_om[1], tmpstr_tf[5], tmpstr_ta,
			tmpstr_om[2], tmpstr_om[3]);

      for(i = 0; i < sizeof(tf_w) / sizeof(tf_w[0]); i++)
	if(strlen(tmpstr_tf[i]) == 0)
	  {
	    error = 1;
	    break;
	  }
	else
	  {
	    for(j = 0, spaces = 0; j < strlen(tmpstr_tf[i]); j++)
	      if(isspace(tmpstr_tf[i][j]))
		spaces += 1;

	    if(spaces == strlen(tmpstr_tf[i]))
	      {
		error = 1;
		break;
	      }
	  }

      if(error == 1 || mysql_query(connection, buffer) != 0)
	popupMsg(imshell_w, "Error: Unable to perform request.\n"
		 "Please verify that all required fields have been "
		 "provided.",
		 ERROR);
      else
	loadData("title");

      for(i = 0; i < sizeof(menu_w) / sizeof(menu_w[0]); i++)
	if(tmpstr_om[i] != NULL)
	  XtFree(tmpstr_om[i]);
    }
  else if(strcmp(tmpstr, "statpb_w") == 0)
    {
      (void) memset(resultbuff, '\0', sizeof(resultbuff));
      (void) snprintf(buffer, sizeof(buffer), "SELECT COUNT(*) FROM book");

      if(mysql_query(connection, buffer) != 0)
	{
	  popupMsg(appmainform_w, "Error: Unable to retrieve data.", ERROR);
	  return;
	}

      if((res_set = mysql_store_result(connection)) == NULL)
	{
	  popupMsg(appmainform_w, "Error: mysql_store_result() failure.",
		   ERROR);
	  return;
	}

      if((row = mysql_fetch_row(res_set)) != NULL)
	(void) sprintf(buffer, "Number of entries: %s.\n", row[0]);

      (void) strcat(resultbuff, buffer);

      popupMsg(appmainform_w, resultbuff, NONERROR);
    }
  else if(strcmp(tmpstr, "deletepb_w") == 0)
    popupMsg(appmainform_w, "This option is not yet supported.", NONERROR);
  else
    {
      if(strcmp(tmpstr, "savepb_w") == 0)
	popupMsg(imshell_w, "You are not an authorized user.",
		 NONERROR);
      else
	popupMsg(appmainform_w, "You are not an authorized user.",
		 NONERROR);
    }
}

/*
** -- loadData() --
*/

static void
loadData(const char *orderby)
{
  char buffer[2048];
  XmString xmstr;
  MYSQL_RES *res_set = NULL;
  MYSQL_ROW row;

  (void) snprintf(buffer, sizeof(buffer), "SELECT LTRIM(RTRIM(title)), "
		  "LTRIM(RTRIM(author)), "
		  "LTRIM(RTRIM(publisher)), LTRIM(RTRIM(pdate)), edition, "
		  "category, language, LTRIM(RTRIM(isbn)) FROM "
		  "book ORDER BY %s", orderby);

  if(mysql_query(connection, buffer) != 0)
    {
      popupMsg(appmainform_w, "Error: mysql_query() failure.", ERROR);
      return;
    }

  if((res_set = mysql_store_result(connection)) == NULL)
    {
      popupMsg(appmainform_w, "Error: mysql_store_result() failure.", ERROR);
      return;
    }

  /*
  ** Clear the list widget.
  */

  XmListDeleteAllItems(list_w);

  while((row = mysql_fetch_row(res_set)) != NULL)
    {
      (void) snprintf(buffer, sizeof(buffer),
		      " %-76s %-76s %-56s %-36s %-18s %-36s %-18s %-16s",
		      row[0], row[1], row[2], row[3], row[4], row[5],
		      row[6], row[7]);
      xmstr = XmStringCreateLocalized(buffer);
      XmListAddItem(list_w, xmstr, 0);
      XmStringFree(xmstr);
    }

  resize();
  (void) mysql_free_result(res_set);
}

/*
** -- createIMWindow() --
*/

static void
createIMWindow(const Widget parent_w, const char *dirname)
{
  int i = 0;
  int j = 0;
  int k = 0;
  char *tmpstr = NULL;
  char filename[2048];
  FILE *fp = NULL;
  Widget tmp_w = NULL;
  Widget pane_w = NULL;
  Widget frame_w = NULL;
  Widget savepb_w = NULL;
  Widget closepb_w = NULL;
  Widget imrowcol_w = NULL;
  Widget mainform_w = NULL;
  XmString xmstr;

  tmpstr = (char *) "XBook";
  imshell_w = XtVaAppCreateShell(NULL,
				 "imshell_w",
				 topLevelShellWidgetClass,
				 XtDisplay(parent_w),
				 XmNtitle,
				 tmpstr,
				 XmNdeleteResponse,
				 XmUNMAP,
				 XmNmaxHeight,
#ifdef SUNOS
				 450,
#elif FREEBSD
				 500,
#else
				 500,
#endif
				 XmNmaxWidth,
				 450,
				 XmNminHeight,
#ifdef SUNOS
				 450,
#elif FREEBSD
				 500,
#else
				 500,
#endif
				 XmNminWidth,
				 450,
				 NULL);
  frame_w = XtVaCreateManagedWidget("frame_w",
				    xmFrameWidgetClass,
				    imshell_w,
				    NULL);
  mainform_w = XtVaCreateManagedWidget("mainform_w",
				       xmFormWidgetClass,
				       frame_w,
				       NULL);
  imrowcol_w = XtVaCreateManagedWidget("rowcol_w",
				       xmRowColumnWidgetClass,
				       mainform_w,
				       XmNpacking,
				       XmPACK_COLUMN,
				       XmNnumColumns,
				       /* Ignore the Description. */
				       NFIELDS - 1,
				       XmNorientation,
				       XmHORIZONTAL,
				       XmNisAligned,
				       True,
				       XmNleftAttachment,
				       XmATTACH_FORM,
				       XmNrightAttachment,
				       XmATTACH_FORM,
				       NULL);

  (void) snprintf(filename, sizeof(filename), "%s/xbook_cfg.dat", dirname);
  fp = fopen(filename, "r");

  /*
  ** Add the textfields and pulldowns.
  */

  for(i = 0; i < sizeof(fields) / sizeof(fields[0]); i++)
    {
      (void) XtVaCreateManagedWidget(fields[i],
				     xmLabelWidgetClass,
				     imrowcol_w,
				     NULL);

      if(strstr(fields[i], "Edition") != NULL)
	{
	  menu_w[0] = XmCreateOptionMenu(imrowcol_w,
					 (char *) "menu_w",
					 NULL,
					 0);
	  pane_w = XmCreatePulldownMenu(imrowcol_w,
					(char *) "pane_w",
					NULL,
					0);

	  if(fp == NULL)
	    for(j = 0; j < sizeof(editions) / sizeof(editions[0]); j++)
	      (void) XtCreateManagedWidget(editions[j],
					   xmPushButtonWidgetClass,
					   pane_w,
					   NULL,
					   0);
	  else
	    fillPulldowns(pane_w, fp, "[Editions]");

	  XtVaSetValues(menu_w[0],
			XmNsubMenuId,
			pane_w,
			NULL);
	  XtVaSetValues(pane_w,
			XmNpacking,
			XmPACK_COLUMN,
			XmNnumColumns,
			1,
			NULL);
	  XtManageChild(menu_w[0]);
	}
      else if(strstr(fields[i], "Category") != NULL)
	{
	  menu_w[1] = XmCreateOptionMenu(imrowcol_w,
					 (char *) "menu_w",
					 NULL,
					 0);
	  pane_w = XmCreatePulldownMenu(imrowcol_w,
					(char *) "pane_w",
					NULL,
					0);

	  if(fp == NULL)
	    for(j = 0; j < sizeof(categories) / sizeof(categories[0]); j++)
	      (void) XtCreateManagedWidget(categories[j],
					   xmPushButtonWidgetClass,
					   pane_w,
					   NULL,
					   0);
	  else
	    fillPulldowns(pane_w, fp, "[Categories]");

	  XtVaSetValues(menu_w[1],
			XmNsubMenuId,
			pane_w,
			NULL);
	  XtVaSetValues(pane_w,
			XmNpacking,
			XmPACK_COLUMN,
			XmNnumColumns,
			1,
			NULL);
	  XtManageChild(menu_w[1]); 
	}
      else if(strstr(fields[i], "Language") != NULL)
	{
	  menu_w[2] = XmCreateOptionMenu(imrowcol_w,
					 (char *) "menu_w",
					 NULL,
					 0);
	  pane_w = XmCreatePulldownMenu(imrowcol_w,
					(char *) "pane_w",
					NULL,
					0);

	  if(fp == NULL)
	    for(j = 0; j < sizeof(languages) / sizeof(languages[0]); j++)
	      (void) XtCreateManagedWidget(languages[j],
					   xmPushButtonWidgetClass,
					   pane_w,
					   NULL,
					   0);
	  else
	    fillPulldowns(pane_w, fp, "[Languages]");

	  XtVaSetValues(menu_w[2],
			XmNsubMenuId,
			pane_w,
			NULL);
	  XtVaSetValues(pane_w,
			XmNpacking,
			XmPACK_COLUMN,
			XmNnumColumns,
			1,
			NULL);
	  XtManageChild(menu_w[2]);
	}
      else if(strstr(fields[i], "Monetary") != NULL)
	{
	  menu_w[3] = XmCreateOptionMenu(imrowcol_w,
					 (char *) "menu_w",
					 NULL,
					 0);
	  pane_w = XmCreatePulldownMenu(imrowcol_w,
					(char *) "pane_w",
					NULL,
					0);

	  if(fp == NULL)
	    for(j = 0;
		j < sizeof(monetaryunits) / sizeof(monetaryunits[0]); j++)
	      (void) XtCreateManagedWidget(monetaryunits[j],
					   xmPushButtonWidgetClass,
					   pane_w,
					   NULL,
					   0);
	  else
	    fillPulldowns(pane_w, fp, "[Monetary Units]");

	  XtVaSetValues(menu_w[3],
			XmNsubMenuId,
			pane_w,
			NULL);
	  XtVaSetValues(pane_w,
			XmNpacking,
			XmPACK_COLUMN,
			XmNnumColumns,
			1,
			NULL);
	  XtManageChild(menu_w[3]);
	}
      else
	{
	  tf_w[k] = XtVaCreateManagedWidget("textfield_w",
					    xmTextFieldWidgetClass,
					    imrowcol_w,
					    XmNmaxLength,
					    fieldsizes[k],
					    NULL);
	  k += 1;
	}
    }

  (void) fclose(fp);

  /*
  ** Add the Description.
  */

  tmp_w = XtVaCreateManagedWidget("Description (required)          ",
				  xmLabelWidgetClass,
				  mainform_w,
				  XmNleftAttachment,
				  XmATTACH_OPPOSITE_WIDGET,
				  XmNleftWidget,
				  imrowcol_w,
				  XmNrightAttachment,
				  XmATTACH_NONE,
				  XmNtopAttachment,
				  XmATTACH_WIDGET,
				  XmNtopWidget,
				  imrowcol_w,
				  XmNleftOffset,
				  3,
				  NULL);
  ta_w = XtVaCreateManagedWidget("text_w",
				 xmTextWidgetClass,
				 mainform_w,
				 XmNeditMode,
				 XmMULTI_LINE_EDIT,
				 XmNrows,
				 4,
				 XmNcolumns,
				 24,
				 XmNleftAttachment,
				 XmATTACH_WIDGET,
				 XmNleftWidget,
				 tmp_w,
				 XmNrightAttachment,
				 XmATTACH_NONE,
				 XmNbottomAttachment,
				 XmATTACH_NONE,
				 XmNtopAttachment,
				 XmATTACH_WIDGET,
				 XmNtopWidget,
				 imrowcol_w,
				 NULL);

  /*
  ** Add some buttons.
  */

  xmstr = XmStringCreateLocalized((char *) "Save");
  savepb_w = XtVaCreateManagedWidget("savepb_w",
				     xmPushButtonWidgetClass,
				     mainform_w,
				     XmNlabelString,
				     xmstr,
				     XmNtopAttachment,
				     XmATTACH_WIDGET,
				     XmNtopWidget,
				     ta_w,
				     XmNleftAttachment,
				     XmATTACH_FORM,
				     XmNtopOffset,
				     10,
				     XmNleftOffset,
				     50,
				     XmNwidth,
				     100,
				     NULL);
  XmStringFree(xmstr);
  xmstr = XmStringCreateLocalized((char *) "Dismiss");
  closepb_w = XtVaCreateManagedWidget("closepb_w",
				      xmPushButtonWidgetClass,
				      mainform_w,
				      XmNlabelString,
				      xmstr,
				      XmNtopAttachment,
				      XmATTACH_WIDGET,
				      XmNtopWidget,
				      ta_w,
				      XmNrightAttachment,
				      XmATTACH_FORM,
				      XmNtopOffset,
				      10,
				      XmNrightOffset,
				      50,
				      XmNwidth,
				      100,
				      NULL);
  XmStringFree(xmstr);

  /*
  ** Add callbacks to the buttons.
  */

  XtAddCallback(savepb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
  XtAddCallback(closepb_w,
		XmNactivateCallback,
		wCallback,
		NULL);
}

/*
** -- popupMsg() --
*/

static void
popupMsg(const Widget parent_w, const char * const str, const int type)
{
  XmString xmstr;
  static char *tmpstr = (char *) "XBook";
  Widget dialog_w = NULL;

  dialog_w = XmCreateErrorDialog(parent_w,
				 (char *) "dialog_w",
				 NULL,
				 0);
  xmstr = XmStringCreateLocalized((char *) str);
  XtUnmanageChild(XmMessageBoxGetChild(dialog_w,
				       XmDIALOG_HELP_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dialog_w,
				       XmDIALOG_CANCEL_BUTTON));
  XtVaSetValues(dialog_w,
		XmNmessageString,
		xmstr,
		XmNdialogStyle,
		XmDIALOG_PRIMARY_APPLICATION_MODAL,
		NULL);
  XtVaSetValues(XtParent(dialog_w),
		XmNtitle,
		tmpstr,
		NULL);
  XtManageChild(dialog_w);
  XmStringFree(xmstr);
}

/*
** -- fdialogCancelCb() --
*/

static void
fdialogCancelCb(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtUnmanageChild(fdialog);
}

/*
** -- writeCb() --
*/

static void
writeCb(Widget w, XtPointer client_data, XtPointer call_data)
{
  int i = 0;
  FILE *fp = NULL;
  char buffer[2048];
  char *filename = NULL;
  MYSQL_RES *res_set = NULL;
  MYSQL_ROW row;
  XmFileSelectionBoxCallbackStruct *cbs = NULL;

  /*
  ** Save the data to disk.
  */

  cbs = (XmFileSelectionBoxCallbackStruct *) call_data;

  if(!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &filename))
    {
      popupMsg(appmainform_w, "Please select a file.", ERROR);
      return;
    }
  else if(filename == NULL)
    {
      popupMsg(appmainform_w, "Please select a file.", ERROR);
      return;
    }
  else if(strlen(filename) == 0)
    {
      XtFree(filename);
      popupMsg(appmainform_w, "Please select a file.", ERROR);
      return;
    }

  if((fp = fopen(filename, "w")) == NULL)
    {
      XtFree(filename);
      popupMsg(appmainform_w, "Unable to save the file.", ERROR);
      return;
    }

  XtFree(filename);
  XtUnmanageChild(fdialog);
  (void) strcpy(buffer, "SELECT isbn, title, edition, author, "
		"pdate, publisher, category, price, description, "
		"language, monetary_units "
		"FROM book ORDER BY title");

  if(mysql_query(connection, buffer) != 0)
    {
      (void) fclose(fp);
      popupMsg(appmainform_w, "Error: mysql_query() failure.", ERROR);
      return;
    }

  if((res_set = mysql_store_result(connection)) == NULL)
    {
      (void) fclose(fp);
      popupMsg(appmainform_w, "Error: mysql_store_result() failure.",
	       ERROR);
      return;
    }

  (void) fprintf(fp, "<html><body></body>");
  (void) fprintf(fp, "<table border=1>");
  (void) fprintf(fp, "<tr><th>Item #");

  for(i = 0; i < sizeof(fieldnames) / sizeof(fieldnames[0]); i++)
    {
      (void) fprintf(fp, "<th>");
      (void) fprintf(fp, fieldnames[i]);
      (void) fprintf(fp, "</th>");
    }

  (void) fprintf(fp, "</tr>");
  i = 1;

  while((row = mysql_fetch_row(res_set)) != NULL)
    {
      (void) snprintf(buffer, sizeof(buffer),
		      "<tr>"
		      "<td>%d"
		      "<td>%s"
		      "<td>%s"
		      "<td>%s"
		      "<td>%s"
		      "<td>%s"
		      "<td>%s"
		      "<td>%s"
		      "<td>%.2f"
		      "<td>%s"
		      "<td>%s"
		      "<td>%s"
		      "</tr>",
		      i,
		      row[0], row[1], row[2], row[3], row[4], row[5],
		      row[6], atof(row[7]), row[8], row[9], row[10]);
      (void) fprintf(fp, "%s\n", buffer);
      i += 1;
    }

  (void) fprintf(fp, "</html>");
  (void) fclose(fp);
   popupMsg(appmainform_w, "HTML file generated successfully.", NONERROR);
  (void) mysql_free_result(res_set);
}

/*
** -- fillPulldowns() --
*/

static void
fillPulldowns(const Widget widget, FILE *fp, const char *section)
{
  int found = FALSE;
  char line[256];

  do
    {
      errno = 0;
      rewind(fp);
    }
  while(errno != 0);

  found = FALSE;

  while(fgets(line, sizeof(line), fp) != NULL)
    {
      line[strlen(line) - 1] = '\0';

      if(found && (strlen(line) == 0 ||
		   strstr(line, "[") != NULL))
	break;

      if(strcmp(line, section) == 0)
	found = TRUE;
      else if(found)
	(void) XtCreateManagedWidget(line,
				     xmPushButtonWidgetClass,
				     widget,
				     NULL,
				     0);
    }
}

/*
** -- resize() --
*/

static void
resize(Widget w, XEvent *event, String *args, int *num_args)
{
  Widget sb_w = NULL;
  Dimension dim1 = 0;
  Dimension dim2 = 0;
  Dimension dim3 = 0;
  Dimension dim4 = 0;

  XtVaGetValues(appmainform_w,
		XmNheight,
		&dim1,
		NULL);
  XtVaGetValues(titlepb_w,
		XmNheight,
		&dim2,
		NULL);
  XtVaGetValues(rowcol_w,
		XmNheight,
		&dim3,
		NULL);
  XtVaGetValues(scrolledw_w,
		XmNhorizontalScrollBar,
		&sb_w,
		NULL);
  XtVaGetValues(sb_w,
		XmNheight,
		&dim4,
		NULL);
  XtVaSetValues(list_w,
		XmNheight,
		dim1 - (dim2 + dim3 + dim4 + 50),
		NULL);
  XtVaGetValues(scrolledw_w,
		XmNverticalScrollBar,
		&sb_w,
		NULL);
  XtUnmanageChild(sb_w);
}
