/*
 * Utility functions
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include "util.h"

void abortmsg(const char *fmt, ...)
{
    va_list args;
    va_start(args, fmt);
    fputs("\033[1;31mchg: abort: ", stderr);
    vfprintf(stderr, fmt, args);
    fputs("\033[m\n", stderr);
    va_end(args);

    exit(255);
}

static int debugmsgenabled = 0;

void enabledebugmsg(void)
{
    debugmsgenabled = 1;
}

void debugmsg(const char *fmt, ...)
{
    if (!debugmsgenabled) return;

    va_list args;
    va_start(args, fmt);
    fputs("\033[1;30mchg: debug: ", stderr);
    vfprintf(stderr, fmt, args);
    fputs("\033[m\n", stderr);
    va_end(args);
}
