cHg
===

A bit faster Mercurial client for Unix with per-user
[cmdserver daemon][cmdserver].

Install
-------

for local use:

1. Run `make` (or `gmake` on FreeBSD.)
2. Create symlink to `chg` from your `PATH`

to system:

1. Run `make install`
2. Add `hgext` directory to `PYTHONPATH`
   (or specify approprivate `HGEXTDIR` on `make install`.)

Usage
-----

Same as `hg`. e.g.

    % chg stat

You may want to add the alias:

    % alias hg=chg

To terminate background cmdserver:

    % chg --kill-chg-daemon

Environment Variables
---------------------

cHg updates `os.environ` on each request, but some variables cannot make an
effect. The following variables are specially handled by cHg:

* update ui attributes by `HGPLAIN` and `HGPLAINEXCEPT`, but some behaviors
  may not change.
* reload message catalog if `LANG`, `LANGUAGE` or `LC_MESSAGES` changed.
* `CHGHG` or `HG` is the path to the 'hg' executable spawned as the background
  cmdserver.

The following variables are available for testing purpose:

* `CHGDEBUG` enables debug message of cHg.
* `CHGCMDSERVEROPTS` gives additional parameters to background cmdserver.
* `CHGSOCKNAME` specifies socket path of background cmdserver.

[cmdserver]: http://mercurial.selenic.com/wiki/CommandServer

Compatibility
-------------

On some old platforms, it isn't safe to call accept()s by multiple processes.
Currently cHg doesn't support such platforms.

For details, grep Apache httpd source for `SINGLE_LISTEN_UNSERIALIZED_ACCEPT`.
