# S-SYSDEPS

## An Abstraction Layer Over Platform Dependent Functionality

`S-SYSDEPS` is an abstraction layer over platform dependent functionality. This simple package is used as a building block in a number of other open source projects.

### Contents

-   [Features](#features)
-   [Status](#status)
-   [News](#news)
-   [Platforms](#platforms)
-   [Downloading](#downloading)
-   [Installation](#installation)
-   [Usage](#usage)
-   [API Reference](#api)
-   [Mailinglist](#mailinglist)
-   [Changelog](#changelog)
-   [TODO](#tod)
-   [FAQ](#faq)
-   [Bugs](#bugs)
-   [Authors](#authors)
-   [Maintainers](#maintainers)
-   [License](#license)
-   [History](#history)
-   [References](#references)

### Features

`S-SYSDEPS` abstracts:

-   managing processes
-   implementing a standard TCP/IP server
-   opening a client TCP/IP socket stream
-   working with process locks

### Status

`S-SYSDEPS` is considered stable code.

### News

*November 2005* - Created as a seperate project.

### Platforms

`S-SYSDEPS` is, by definition, written in ANSI standard Common Lisp but
implemented using non-standard extensions. At the moment, ports for
LispWorks (reference), OpenMCL, CMUCL and SBCL exist. Some other CL
implementations are partially supported.

### Installation

The `S-SYSDEPS` package is loaded using [ASDF](http://www.cliki.net/asdf).
There is an excellent [tutorial on
ASDF](http://constantly.at/lisp/asdf/) to get you started.

    CL-USER 1 > (asdf:oos 'asdf:load-op :s-sysdeps)

Example of setting up and using ASDF to compile and load the package

### Usage

For usage examples please have a look at the package using `S-SYSDEPS`.

### API Reference

There is automatically generated [API Reference](API.html) documentation
available for the S-SYSDEPS package.

### Mailinglist

There is no mailing list for this project.

### Changelog

Release Notes:

* release 1: moved `S-SYSDEPS` into a separate project under a new structure

### TODO

* Port to even more platforms. 
* Add some unit or functional tests
* Some example code.

### FAQ

Nothing appropriate.

### Bugs

There are no known bugs.

### Authors

`S-SYSDEPS` was written by Sven Van Caekenberghe. Ports to CMUCL and SBCL were contributed.

### Maintainers

`S-SYSDEPS` is being maintained by Sven Van
Caekenberghe.

### License

You are granted the rights to distribute and use this software as
governed by the terms of the Lisp Lesser General Public License
([http://opensource.franz.com/preamble.html](http://opensource.franz.com/preamble.html)),
also known as the LLGPL.

### History

This file was part of `S-XML-RPC` and `(N)KPAX`.

### References

There are no references.

Copyright © 2004-2005 Sven Van Caekenberghe, Beta Nine BVBA. All Right
Reserved.