# t00004 - Nested classes and enums
## Config
```yaml
diagrams:
  t00004_class:
    type: class
    generate_links:
      link: 'https://github.com/bkryza/clang-uml/blob/{{ git.commit }}/{{ element.source.path }}#L{{ element.source.line }}'
      tooltip: '{% if existsIn(element, "comment") and existsIn(element.comment, "brief")  %}{{ abbrv(trim(replace(element.comment.brief.0, "\n+", " ")), 256) }}{% else %}{{ element.name }}{% endif %}'
    glob:
      - t00004.cc
    using_namespace: clanguml::t00004
    include:
      namespaces:
        - clanguml::t00004

```
## Source code
File `tests/t00004/t00004.cc`
```cpp
namespace clanguml {
namespace t00004 {

enum Color { Red, Green, Blue };

class B {
public:
    enum AA { AA_1, AA_2, AA_3 };
    typedef enum { BB_1, BB_2, BB_3 } BB;
    typedef enum CC { CC_1, CC_2, CC_3 } CC_t;

    AA aa;
    BB bb;
    CC cc;
    Color *color;
};

class A {
public:
    void foo() const { }

    class AA {
    public:
        enum class Lights { Green, Yellow, Red };

        class AAA {
            Lights lights;
        };
    };

    void foo2() const { }
};

template <typename T> class C {
public:
    T t;

    class AA {
        class AAA { };

        enum class CCC { CCC_1, CCC_2 };
    };

    template <typename V> class B {
        V b;
    };

    B<int> b_int;

    enum class CC { CC_1, CC_2 };
};

namespace detail {
class D {
public:
    enum class AA { AA_1, AA_2, AA_3 };

    class DD { };
};
}

} // namespace t00004
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00004_class](./t00004_class.svg "Nested classes and enums")
## Generated Mermaid diagrams
![t00004_class](./t00004_class_mermaid.svg "Nested classes and enums")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "constants": [
        "Red",
        "Green",
        "Blue"
      ],
      "display_name": "Color",
      "id": "8844195389762820798",
      "is_nested": false,
      "name": "Color",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 6,
        "file": "t00004.cc",
        "line": 4,
        "translation_unit": "t00004.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "9860995429872413691",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "aa",
          "source_location": {
            "column": 8,
            "file": "t00004.cc",
            "line": 12,
            "translation_unit": "t00004.cc"
          },
          "type": "AA"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "bb",
          "source_location": {
            "column": 8,
            "file": "t00004.cc",
            "line": 13,
            "translation_unit": "t00004.cc"
          },
          "type": "BB"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "cc",
          "source_location": {
            "column": 8,
            "file": "t00004.cc",
            "line": 14,
            "translation_unit": "t00004.cc"
          },
          "type": "CC"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "color",
          "source_location": {
            "column": 12,
            "file": "t00004.cc",
            "line": 15,
            "translation_unit": "t00004.cc"
          },
          "type": "Color *"
        }
      ],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 7,
        "file": "t00004.cc",
        "line": 6,
        "translation_unit": "t00004.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "constants": [
        "AA_1",
        "AA_2",
        "AA_3"
      ],
      "display_name": "B::AA",
      "id": "13041644057721012989",
      "is_nested": true,
      "name": "B##AA",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 10,
        "file": "t00004.cc",
        "line": 8,
        "translation_unit": "t00004.cc"
      },
      "type": "enum"
    },
    {
      "constants": [
        "BB_1",
        "BB_2",
        "BB_3"
      ],
      "display_name": "B::BB",
      "id": "11301510774670429058",
      "is_nested": true,
      "name": "B##BB",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 13,
        "file": "t00004.cc",
        "line": 9,
        "translation_unit": "t00004.cc"
      },
      "type": "enum"
    },
    {
      "constants": [
        "CC_1",
        "CC_2",
        "CC_3"
      ],
      "display_name": "B::CC",
      "id": "17197386180904896588",
      "is_nested": true,
      "name": "B##CC",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 18,
        "file": "t00004.cc",
        "line": 10,
        "translation_unit": "t00004.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "12418199527012894198",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "foo",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "foo",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00004.cc",
            "line": 20,
            "translation_unit": "t00004.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "foo2",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "foo2",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00004.cc",
            "line": 31,
            "translation_unit": "t00004.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "A",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 7,
        "file": "t00004.cc",
        "line": 18,
        "translation_unit": "t00004.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A::AA",
      "id": "13939998749822876416",
      "is_abstract": false,
      "is_nested": true,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A##AA",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 11,
        "file": "t00004.cc",
        "line": 22,
        "translation_unit": "t00004.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "constants": [
        "Green",
        "Yellow",
        "Red"
      ],
      "display_name": "A::AA::Lights",
      "id": "4727494996070729955",
      "is_nested": true,
      "name": "A##AA##Lights",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 20,
        "file": "t00004.cc",
        "line": 24,
        "translation_unit": "t00004.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "A::AA::AAA",
      "id": "11441493064034257052",
      "is_abstract": false,
      "is_nested": true,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "lights",
          "source_location": {
            "column": 20,
            "file": "t00004.cc",
            "line": 27,
            "translation_unit": "t00004.cc"
          },
          "type": "Lights"
        }
      ],
      "methods": [],
      "name": "A##AA##AAA",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 15,
        "file": "t00004.cc",
        "line": 26,
        "translation_unit": "t00004.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C::B<int>",
      "id": "2302554954640607720",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C##B",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 12,
        "file": "t00004.cc",
        "line": 48,
        "translation_unit": "t00004.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "int"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C<T>",
      "id": "18226625421819521092",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "t",
          "source_location": {
            "column": 7,
            "file": "t00004.cc",
            "line": 36,
            "translation_unit": "t00004.cc"
          },
          "type": "T"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "b_int",
          "source_location": {
            "column": 12,
            "file": "t00004.cc",
            "line": 48,
            "translation_unit": "t00004.cc"
          },
          "type": "B<int>"
        }
      ],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 29,
        "file": "t00004.cc",
        "line": 34,
        "translation_unit": "t00004.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C::AA",
      "id": "4991521063183421232",
      "is_abstract": false,
      "is_nested": true,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C##AA",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 11,
        "file": "t00004.cc",
        "line": 38,
        "translation_unit": "t00004.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C::AA::AAA",
      "id": "12782408698292006929",
      "is_abstract": false,
      "is_nested": true,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C##AA##AAA",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 15,
        "file": "t00004.cc",
        "line": 39,
        "translation_unit": "t00004.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "constants": [
        "CCC_1",
        "CCC_2"
      ],
      "display_name": "C::AA::CCC",
      "id": "654553621116797875",
      "is_nested": true,
      "name": "C##AA##CCC",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 20,
        "file": "t00004.cc",
        "line": 41,
        "translation_unit": "t00004.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "C::B<V>",
      "id": "11050386686796671606",
      "is_abstract": false,
      "is_nested": true,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 11,
            "file": "t00004.cc",
            "line": 45,
            "translation_unit": "t00004.cc"
          },
          "type": "V"
        }
      ],
      "methods": [],
      "name": "C##B",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 33,
        "file": "t00004.cc",
        "line": 44,
        "translation_unit": "t00004.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "V",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "constants": [
        "CC_1",
        "CC_2"
      ],
      "display_name": "C::CC",
      "id": "16299031488803029599",
      "is_nested": true,
      "name": "C##CC",
      "namespace": "clanguml::t00004",
      "source_location": {
        "column": 16,
        "file": "t00004.cc",
        "line": 50,
        "translation_unit": "t00004.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "detail::D",
      "id": "4897065367017086369",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00004::detail",
      "source_location": {
        "column": 7,
        "file": "t00004.cc",
        "line": 54,
        "translation_unit": "t00004.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "constants": [
        "AA_1",
        "AA_2",
        "AA_3"
      ],
      "display_name": "detail::D::AA",
      "id": "12576640463341047379",
      "is_nested": true,
      "name": "D##AA",
      "namespace": "clanguml::t00004::detail",
      "source_location": {
        "column": 16,
        "file": "t00004.cc",
        "line": 56,
        "translation_unit": "t00004.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "detail::D::DD",
      "id": "4807329861420443943",
      "is_abstract": false,
      "is_nested": true,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "D##DD",
      "namespace": "clanguml::t00004::detail",
      "source_location": {
        "column": 11,
        "file": "t00004.cc",
        "line": 58,
        "translation_unit": "t00004.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00004_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "13041644057721012989",
      "label": "aa",
      "source": "9860995429872413691",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "11301510774670429058",
      "label": "bb",
      "source": "9860995429872413691",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "17197386180904896588",
      "label": "cc",
      "source": "9860995429872413691",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "8844195389762820798",
      "label": "color",
      "source": "9860995429872413691",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "9860995429872413691",
      "source": "13041644057721012989",
      "type": "containment"
    },
    {
      "access": "public",
      "destination": "9860995429872413691",
      "source": "11301510774670429058",
      "type": "containment"
    },
    {
      "access": "public",
      "destination": "9860995429872413691",
      "source": "17197386180904896588",
      "type": "containment"
    },
    {
      "access": "public",
      "destination": "12418199527012894198",
      "source": "13939998749822876416",
      "type": "containment"
    },
    {
      "access": "public",
      "destination": "13939998749822876416",
      "source": "4727494996070729955",
      "type": "containment"
    },
    {
      "access": "public",
      "destination": "13939998749822876416",
      "source": "11441493064034257052",
      "type": "containment"
    },
    {
      "access": "private",
      "destination": "4727494996070729955",
      "label": "lights",
      "source": "11441493064034257052",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "11050386686796671606",
      "source": "2302554954640607720",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "2302554954640607720",
      "label": "b_int",
      "source": "18226625421819521092",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "18226625421819521092",
      "source": "4991521063183421232",
      "type": "containment"
    },
    {
      "access": "public",
      "destination": "4991521063183421232",
      "source": "12782408698292006929",
      "type": "containment"
    },
    {
      "access": "public",
      "destination": "4991521063183421232",
      "source": "654553621116797875",
      "type": "containment"
    },
    {
      "access": "public",
      "destination": "18226625421819521092",
      "source": "11050386686796671606",
      "type": "containment"
    },
    {
      "access": "public",
      "destination": "18226625421819521092",
      "source": "16299031488803029599",
      "type": "containment"
    },
    {
      "access": "public",
      "destination": "4897065367017086369",
      "source": "12576640463341047379",
      "type": "containment"
    },
    {
      "access": "public",
      "destination": "4897065367017086369",
      "source": "4807329861420443943",
      "type": "containment"
    }
  ],
  "using_namespace": "clanguml::t00004"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00004</data>
  <node id="n0">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[Color]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L4</data>
   <data key="nd5">Color</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L6</data>
   <data key="nd5">B</data>
  </node>
  <node id="n2">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[B::AA]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L8</data>
   <data key="nd5">B::AA</data>
  </node>
  <node id="n3">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[B::BB]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L9</data>
   <data key="nd5">B::BB</data>
  </node>
  <node id="n4">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[B::CC]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L10</data>
   <data key="nd5">B::CC</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L18</data>
   <data key="nd5">A</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A::AA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L22</data>
   <data key="nd5">A::AA</data>
  </node>
  <node id="n7">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[A::AA::Lights]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L24</data>
   <data key="nd5">A::AA::Lights</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A::AA::AAA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L26</data>
   <data key="nd5">A::AA::AAA</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C::B<int>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L48</data>
   <data key="nd5">C::B</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L34</data>
   <data key="nd5">C</data>
  </node>
  <node id="n11">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C::AA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L38</data>
   <data key="nd5">C::AA</data>
  </node>
  <node id="n12">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C::AA::AAA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L39</data>
   <data key="nd5">C::AA::AAA</data>
  </node>
  <node id="n13">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[C::AA::CCC]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L41</data>
   <data key="nd5">C::AA::CCC</data>
  </node>
  <node id="n14">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C::B<V>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L44</data>
   <data key="nd5">C::B</data>
  </node>
  <node id="n15">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[C::CC]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L50</data>
   <data key="nd5">C::CC</data>
  </node>
  <node id="n16">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[detail::D]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L54</data>
   <data key="nd5">D</data>
  </node>
  <node id="n17">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[detail::D::AA]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L56</data>
   <data key="nd5">D::AA</data>
  </node>
  <node id="n18">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[detail::D::DD]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L58</data>
   <data key="nd5">D::DD</data>
  </node>
  <edge id="e0" source="n1" target="n2">
   <data key="ed3">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L12</data>
   <data key="ed0">aggregation</data>
   <data key="ed2">aa</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n1" target="n3">
   <data key="ed3">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L13</data>
   <data key="ed0">aggregation</data>
   <data key="ed2">bb</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n1" target="n4">
   <data key="ed3">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L14</data>
   <data key="ed0">aggregation</data>
   <data key="ed2">cc</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n1" target="n0">
   <data key="ed3">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L15</data>
   <data key="ed0">association</data>
   <data key="ed2">color</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n6" target="n5">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n8" target="n6">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n8" target="n7">
   <data key="ed3">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L27</data>
   <data key="ed0">aggregation</data>
   <data key="ed2">lights</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e7" source="n9" target="n14">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n10" target="n9">
   <data key="ed3">https://github.com/bkryza/clang-uml/blob/012ee41430750c86326bc1f4592515d151028b2e/tests/t00004/t00004.cc#L48</data>
   <data key="ed0">aggregation</data>
   <data key="ed2">b_int</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n11" target="n10">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n12" target="n11">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e11" source="n14" target="n10">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e12" source="n18" target="n16">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e13" source="n2" target="n1">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e14" source="n3" target="n1">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e15" source="n4" target="n1">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e16" source="n7" target="n6">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e17" source="n13" target="n11">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e18" source="n15" target="n10">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e19" source="n17" target="n16">
   <data key="ed0">containment</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
