# t00013 - Template instantiation relationships
## Config
```yaml
diagrams:
  t00013_class:
    type: class
    glob:
      - t00013.cc
    using_namespace: clanguml::t00013
    include:
      namespaces:
        - clanguml::t00013
        - ABCD

```
## Source code
File `tests/t00013/t00013.cc`
```cpp
#include <algorithm>
#include <map>
#include <numeric>
#include <string>

namespace ABCD {
template <typename T> struct F {
    T f;
};
}
namespace clanguml {
namespace t00013 {

struct A {
    int a;
};

struct B {
    int b;
};

struct C {
    int c;
};

class R;

struct D {
    int d;
    void print(R *r) { }
};

template <typename T> struct E {
    T e;
};

template <typename T, typename... Args> struct G {
    T g;
    std::tuple<Args...> args;
};

using namespace ABCD;
class R {
public:
    int get_a(A *a) { return a->a; }
    int get_b(B &b) { return b.b; }
    int get_const_b(const B &b) { return b.b; }
    int get_c(C c) { return c.c; }
    int get_d(D &&d) { return d.d; }
    // Dependency relationship should be rendered only once
    int get_d2(D &&d) { return d.d; }

    template <typename T> T get_e(E<T> e) { return e.e; }
    int get_int_e(const E<int> &e) { return e.e; }
    int get_int_e2(E<int> &e) { return e.e; }

    template <typename T> T get_f(const F<T> &f) { return f.f; }
    int get_int_f(const F<int> &f) { return f.f; }

    G<int, float, std::string> gintstring;

private:
    mutable E<std::string> estring;
};
} // namespace t00013
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00013_class](./t00013_class.svg "Template instantiation relationships")
## Generated Mermaid diagrams
![t00013_class](./t00013_class_mermaid.svg "Template instantiation relationships")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "::ABCD::F<T>",
      "id": "7622165842529918021",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "f",
          "source_location": {
            "column": 7,
            "file": "t00013.cc",
            "line": 8,
            "translation_unit": "t00013.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "F",
      "namespace": "ABCD",
      "source_location": {
        "column": 30,
        "file": "t00013.cc",
        "line": 7,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "::ABCD::F<int>",
      "id": "18433723755227114832",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "F",
      "namespace": "ABCD",
      "source_location": {
        "column": 33,
        "file": "t00013.cc",
        "line": 58,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "int"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "4159963889899419835",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 15,
            "translation_unit": "t00013.cc"
          },
          "type": "int"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00013",
      "source_location": {
        "column": 8,
        "file": "t00013.cc",
        "line": 14,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "9419901228781203525",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 19,
            "translation_unit": "t00013.cc"
          },
          "type": "int"
        }
      ],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00013",
      "source_location": {
        "column": 8,
        "file": "t00013.cc",
        "line": 18,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C",
      "id": "8225966544585026866",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 23,
            "translation_unit": "t00013.cc"
          },
          "type": "int"
        }
      ],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00013",
      "source_location": {
        "column": 8,
        "file": "t00013.cc",
        "line": 22,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "D",
      "id": "3274990964975455007",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "d",
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 29,
            "translation_unit": "t00013.cc"
          },
          "type": "int"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "print",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "print",
          "parameters": [
            {
              "name": "r",
              "type": "R *"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00013.cc",
            "line": 30,
            "translation_unit": "t00013.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "D",
      "namespace": "clanguml::t00013",
      "source_location": {
        "column": 8,
        "file": "t00013.cc",
        "line": 28,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "E<T>",
      "id": "6912447950043513847",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "e",
          "source_location": {
            "column": 7,
            "file": "t00013.cc",
            "line": 34,
            "translation_unit": "t00013.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "E",
      "namespace": "clanguml::t00013",
      "source_location": {
        "column": 30,
        "file": "t00013.cc",
        "line": 33,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "G<T,Args...>",
      "id": "1647416153016220941",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "g",
          "source_location": {
            "column": 7,
            "file": "t00013.cc",
            "line": 38,
            "translation_unit": "t00013.cc"
          },
          "type": "T"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "args",
          "source_location": {
            "column": 25,
            "file": "t00013.cc",
            "line": 39,
            "translation_unit": "t00013.cc"
          },
          "type": "std::tuple<Args...>"
        }
      ],
      "methods": [],
      "name": "G",
      "namespace": "clanguml::t00013",
      "source_location": {
        "column": 48,
        "file": "t00013.cc",
        "line": 37,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        },
        {
          "is_variadic": true,
          "kind": "template_type",
          "name": "Args...",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "E<int>",
      "id": "15819890550396525783",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "E",
      "namespace": "clanguml::t00013",
      "source_location": {
        "column": 33,
        "file": "t00013.cc",
        "line": 54,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "int"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "G<int,float,std::string>",
      "id": "12213866196910576114",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "G",
      "namespace": "clanguml::t00013",
      "source_location": {
        "column": 32,
        "file": "t00013.cc",
        "line": 60,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "int"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "float"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::string"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "E<std::string>",
      "id": "4252185767324461489",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "E",
      "namespace": "clanguml::t00013",
      "source_location": {
        "column": 28,
        "file": "t00013.cc",
        "line": 63,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::string"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "17589493410844590756",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "gintstring",
          "source_location": {
            "column": 32,
            "file": "t00013.cc",
            "line": 60,
            "translation_unit": "t00013.cc"
          },
          "type": "G<int,float,std::string>"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "estring",
          "source_location": {
            "column": 28,
            "file": "t00013.cc",
            "line": 63,
            "translation_unit": "t00013.cc"
          },
          "type": "E<std::string>"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "get_a",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_a",
          "parameters": [
            {
              "name": "a",
              "type": "A *"
            }
          ],
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 45,
            "translation_unit": "t00013.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "public",
          "display_name": "get_b",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_b",
          "parameters": [
            {
              "name": "b",
              "type": "B &"
            }
          ],
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 46,
            "translation_unit": "t00013.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "public",
          "display_name": "get_const_b",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_const_b",
          "parameters": [
            {
              "name": "b",
              "type": "const B &"
            }
          ],
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 47,
            "translation_unit": "t00013.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "public",
          "display_name": "get_c",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_c",
          "parameters": [
            {
              "name": "c",
              "type": "C"
            }
          ],
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 48,
            "translation_unit": "t00013.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "public",
          "display_name": "get_d",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_d",
          "parameters": [
            {
              "name": "d",
              "type": "D &&"
            }
          ],
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 49,
            "translation_unit": "t00013.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "public",
          "display_name": "get_d2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_d2",
          "parameters": [
            {
              "name": "d",
              "type": "D &&"
            }
          ],
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 51,
            "translation_unit": "t00013.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "public",
          "display_name": "get_int_e",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_int_e",
          "parameters": [
            {
              "name": "e",
              "type": "const clanguml::t00013::E<int> &"
            }
          ],
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 54,
            "translation_unit": "t00013.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "public",
          "display_name": "get_int_e2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_int_e2",
          "parameters": [
            {
              "name": "e",
              "type": "clanguml::t00013::E<int> &"
            }
          ],
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 55,
            "translation_unit": "t00013.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "public",
          "display_name": "get_int_f",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_int_f",
          "parameters": [
            {
              "name": "f",
              "type": "const ABCD::F<int> &"
            }
          ],
          "source_location": {
            "column": 9,
            "file": "t00013.cc",
            "line": 58,
            "translation_unit": "t00013.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "public",
          "display_name": "get_e<T>",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_e",
          "parameters": [
            {
              "name": "e",
              "type": "E<T>"
            }
          ],
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "T",
              "template_parameters": []
            }
          ],
          "type": "T"
        },
        {
          "access": "public",
          "display_name": "get_f<T>",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_f",
          "parameters": [
            {
              "name": "f",
              "type": "const F<T> &"
            }
          ],
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "T",
              "template_parameters": []
            }
          ],
          "type": "T"
        }
      ],
      "name": "R",
      "namespace": "clanguml::t00013",
      "source_location": {
        "column": 7,
        "file": "t00013.cc",
        "line": 43,
        "translation_unit": "t00013.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00013_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "7622165842529918021",
      "source": "18433723755227114832",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "17589493410844590756",
      "source": "3274990964975455007",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "6912447950043513847",
      "source": "15819890550396525783",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "1647416153016220941",
      "source": "12213866196910576114",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "6912447950043513847",
      "source": "4252185767324461489",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "4159963889899419835",
      "source": "17589493410844590756",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "9419901228781203525",
      "source": "17589493410844590756",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "8225966544585026866",
      "source": "17589493410844590756",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "3274990964975455007",
      "source": "17589493410844590756",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "15819890550396525783",
      "source": "17589493410844590756",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "6912447950043513847",
      "source": "17589493410844590756",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "18433723755227114832",
      "source": "17589493410844590756",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "7622165842529918021",
      "source": "17589493410844590756",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "12213866196910576114",
      "label": "gintstring",
      "source": "17589493410844590756",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "4252185767324461489",
      "label": "estring",
      "source": "17589493410844590756",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00013"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00013</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[::ABCD::F<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[::ABCD::F<int>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[E<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G<T,Args...>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[E<int>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G<int,float,std::string>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[E<std::string>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n11">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n5" target="n11">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n8" target="n6">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n1" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n9" target="n7">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n10" target="n6">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n11" target="n2">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n11" target="n3">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n11" target="n4">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n11" target="n5">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n11" target="n8">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n11" target="n6">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e11" source="n11" target="n1">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e12" source="n11" target="n0">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e13" source="n11" target="n9">
   <data key="ed0">aggregation</data>
   <data key="ed2">gintstring</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e14" source="n11" target="n10">
   <data key="ed0">aggregation</data>
   <data key="ed2">estring</data>
   <data key="ed1">private</data>
  </edge>
 </graph>
</graphml>

```
