# t00037 - Anonymous nested struct test case
## Config
```yaml
diagrams:
  t00037_class:
    type: class
    generate_packages: true
    glob:
      - t00037.cc
    using_namespace: clanguml::t00037
    include:
      namespaces:
        - clanguml::t00037
```
## Source code
File `tests/t00037/t00037.cc`
```cpp
namespace clanguml {
namespace t00037 {

constexpr auto LENGTH{10ULL};

struct S {
    double x;
    double y;
};

class ST {
public:
    struct {
        double t;
        double x;
        double y;
        double z;
    } dimensions;

    struct {
        int len;
        int flags;
    }
#ifndef _MSC_VER
    __attribute__((packed))
#endif
    bars[LENGTH];

private:
    struct {
        double c{1.0};
        double h{1.0};
    } units;

    S s[4][3][2];
};

struct A {
    A()
    {
        st.dimensions.t = -1.0;
        st.dimensions.x = 1.0;
        st.dimensions.y = 1.0;
        st.dimensions.z = 1.0;
    }

    ST st;
};

} // namespace t00037
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00037_class](./t00037_class.svg "Anonymous nested struct test case")
## Generated Mermaid diagrams
![t00037_class](./t00037_class_mermaid.svg "Anonymous nested struct test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "S",
      "id": "12092151151811100076",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "x",
          "source_location": {
            "column": 12,
            "file": "t00037.cc",
            "line": 7,
            "translation_unit": "t00037.cc"
          },
          "type": "double"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "y",
          "source_location": {
            "column": 12,
            "file": "t00037.cc",
            "line": 8,
            "translation_unit": "t00037.cc"
          },
          "type": "double"
        }
      ],
      "methods": [],
      "name": "S",
      "namespace": "clanguml::t00037",
      "source_location": {
        "column": 8,
        "file": "t00037.cc",
        "line": 6,
        "translation_unit": "t00037.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "ST",
      "id": "89624331032310202",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "dimensions",
          "source_location": {
            "column": 7,
            "file": "t00037.cc",
            "line": 18,
            "translation_unit": "t00037.cc"
          },
          "type": "ST::(dimensions)"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "bars",
          "source_location": {
            "column": 5,
            "file": "t00037.cc",
            "line": 27,
            "translation_unit": "t00037.cc"
          },
          "type": "ST::(bars)[10]"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "units",
          "source_location": {
            "column": 7,
            "file": "t00037.cc",
            "line": 33,
            "translation_unit": "t00037.cc"
          },
          "type": "ST::(units)"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "s",
          "source_location": {
            "column": 7,
            "file": "t00037.cc",
            "line": 35,
            "translation_unit": "t00037.cc"
          },
          "type": "S[4][3][2]"
        }
      ],
      "methods": [],
      "name": "ST",
      "namespace": "clanguml::t00037",
      "source_location": {
        "column": 7,
        "file": "t00037.cc",
        "line": 11,
        "translation_unit": "t00037.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "ST::(dimensions)",
      "id": "15846562543783208401",
      "is_abstract": false,
      "is_nested": true,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "t",
          "source_location": {
            "column": 16,
            "file": "t00037.cc",
            "line": 14,
            "translation_unit": "t00037.cc"
          },
          "type": "double"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "x",
          "source_location": {
            "column": 16,
            "file": "t00037.cc",
            "line": 15,
            "translation_unit": "t00037.cc"
          },
          "type": "double"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "y",
          "source_location": {
            "column": 16,
            "file": "t00037.cc",
            "line": 16,
            "translation_unit": "t00037.cc"
          },
          "type": "double"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "z",
          "source_location": {
            "column": 16,
            "file": "t00037.cc",
            "line": 17,
            "translation_unit": "t00037.cc"
          },
          "type": "double"
        }
      ],
      "methods": [],
      "name": "ST##(dimensions)",
      "namespace": "clanguml::t00037",
      "source_location": {
        "column": 5,
        "file": "t00037.cc",
        "line": 13,
        "translation_unit": "t00037.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "ST::(bars)",
      "id": "7016651489261202313",
      "is_abstract": false,
      "is_nested": true,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "len",
          "source_location": {
            "column": 13,
            "file": "t00037.cc",
            "line": 21,
            "translation_unit": "t00037.cc"
          },
          "type": "int"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "flags",
          "source_location": {
            "column": 13,
            "file": "t00037.cc",
            "line": 22,
            "translation_unit": "t00037.cc"
          },
          "type": "int"
        }
      ],
      "methods": [],
      "name": "ST##(bars)",
      "namespace": "clanguml::t00037",
      "source_location": {
        "column": 5,
        "file": "t00037.cc",
        "line": 20,
        "translation_unit": "t00037.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "ST::(units)",
      "id": "14489164071123227020",
      "is_abstract": false,
      "is_nested": true,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 16,
            "file": "t00037.cc",
            "line": 31,
            "translation_unit": "t00037.cc"
          },
          "type": "double"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "h",
          "source_location": {
            "column": 16,
            "file": "t00037.cc",
            "line": 32,
            "translation_unit": "t00037.cc"
          },
          "type": "double"
        }
      ],
      "methods": [],
      "name": "ST##(units)",
      "namespace": "clanguml::t00037",
      "source_location": {
        "column": 5,
        "file": "t00037.cc",
        "line": 30,
        "translation_unit": "t00037.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "10582353454193159633",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "st",
          "source_location": {
            "column": 8,
            "file": "t00037.cc",
            "line": 47,
            "translation_unit": "t00037.cc"
          },
          "type": "ST"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "A",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": true,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "A",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "t00037.cc",
            "line": 39,
            "translation_unit": "t00037.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "A",
      "namespace": "clanguml::t00037",
      "source_location": {
        "column": 8,
        "file": "t00037.cc",
        "line": 38,
        "translation_unit": "t00037.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00037_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "private",
      "destination": "12092151151811100076",
      "label": "s",
      "multiplicity_destination": "24",
      "source": "89624331032310202",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "15846562543783208401",
      "label": "dimensions",
      "source": "89624331032310202",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "7016651489261202313",
      "label": "bars",
      "multiplicity_destination": "10",
      "source": "89624331032310202",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "14489164071123227020",
      "label": "units",
      "source": "89624331032310202",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "89624331032310202",
      "label": "st",
      "source": "10582353454193159633",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00037"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00037</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[S]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ST]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ST::(dimensions)]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ST::(bars)]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ST::(units)]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">aggregation</data>
   <data key="ed2">s</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e1" source="n1" target="n2">
   <data key="ed0">aggregation</data>
   <data key="ed2">dimensions</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n1" target="n3">
   <data key="ed0">aggregation</data>
   <data key="ed2">bars</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n1" target="n4">
   <data key="ed0">aggregation</data>
   <data key="ed2">units</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e4" source="n5" target="n1">
   <data key="ed0">aggregation</data>
   <data key="ed2">st</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
