# t30005 - Package namespace alias test case
## Config
```yaml
diagrams:
  t30005_package:
    type: package
    glob:
      - t30005.cc
    include:
      namespaces:
        - clanguml::t30005
    using_namespace: clanguml::t30005
    plantuml:
      before:
        - "' t30005 test package diagram"
```
## Source code
File `tests/t30005/t30005.cc`
```cpp
namespace clanguml {
namespace t30005 {

namespace A::AA::AAA {
struct C1 { };
}

namespace B::BB::BBB {
namespace A6 = A::AA::AAA;
namespace ASix = A6;
struct C2 {
    ASix::C1 *cb;
};
}

namespace C::CC::CCC {
namespace A6 = A::AA::AAA;
namespace ASix = A6;
using ADSix = ASix::C1;
struct C2 {
    ADSix *cc;
};
}
}

}

```
## Generated PlantUML diagrams
![t30005_package](./t30005_package.svg "Package namespace alias test case")
## Generated Mermaid diagrams
![t30005_package](./t30005_package_mermaid.svg "Package namespace alias test case")
## Generated JSON models
```json
{
  "diagram_type": "package",
  "elements": [
    {
      "display_name": "A",
      "elements": [
        {
          "display_name": "AA",
          "elements": [
            {
              "display_name": "AAA",
              "id": "7312727215421241448",
              "is_deprecated": false,
              "name": "AAA",
              "namespace": "clanguml::t30005::A::AA",
              "source_location": {
                "column": 18,
                "file": "t30005.cc",
                "line": 4,
                "translation_unit": "t30005.cc"
              },
              "type": "namespace"
            }
          ],
          "id": "14220377272171128327",
          "is_deprecated": false,
          "name": "AA",
          "namespace": "clanguml::t30005::A",
          "source_location": {
            "column": 14,
            "file": "t30005.cc",
            "line": 4,
            "translation_unit": "t30005.cc"
          },
          "type": "namespace"
        }
      ],
      "id": "14146429405489052628",
      "is_deprecated": false,
      "name": "A",
      "namespace": "clanguml::t30005",
      "source_location": {
        "column": 11,
        "file": "t30005.cc",
        "line": 4,
        "translation_unit": "t30005.cc"
      },
      "type": "namespace"
    },
    {
      "display_name": "B",
      "elements": [
        {
          "display_name": "BB",
          "elements": [
            {
              "display_name": "BBB",
              "id": "14968215483680013344",
              "is_deprecated": false,
              "name": "BBB",
              "namespace": "clanguml::t30005::B::BB",
              "source_location": {
                "column": 18,
                "file": "t30005.cc",
                "line": 8,
                "translation_unit": "t30005.cc"
              },
              "type": "namespace"
            }
          ],
          "id": "13573050896833958473",
          "is_deprecated": false,
          "name": "BB",
          "namespace": "clanguml::t30005::B",
          "source_location": {
            "column": 14,
            "file": "t30005.cc",
            "line": 8,
            "translation_unit": "t30005.cc"
          },
          "type": "namespace"
        }
      ],
      "id": "3028233733024184414",
      "is_deprecated": false,
      "name": "B",
      "namespace": "clanguml::t30005",
      "source_location": {
        "column": 11,
        "file": "t30005.cc",
        "line": 8,
        "translation_unit": "t30005.cc"
      },
      "type": "namespace"
    },
    {
      "display_name": "C",
      "elements": [
        {
          "display_name": "CC",
          "elements": [
            {
              "display_name": "CCC",
              "id": "14106236321067903999",
              "is_deprecated": false,
              "name": "CCC",
              "namespace": "clanguml::t30005::C::CC",
              "source_location": {
                "column": 18,
                "file": "t30005.cc",
                "line": 16,
                "translation_unit": "t30005.cc"
              },
              "type": "namespace"
            }
          ],
          "id": "17073873133819536371",
          "is_deprecated": false,
          "name": "CC",
          "namespace": "clanguml::t30005::C",
          "source_location": {
            "column": 14,
            "file": "t30005.cc",
            "line": 16,
            "translation_unit": "t30005.cc"
          },
          "type": "namespace"
        }
      ],
      "id": "8328610567403225525",
      "is_deprecated": false,
      "name": "C",
      "namespace": "clanguml::t30005",
      "source_location": {
        "column": 11,
        "file": "t30005.cc",
        "line": 16,
        "translation_unit": "t30005.cc"
      },
      "type": "namespace"
    }
  ],
  "name": "t30005_package",
  "package_type": "namespace",
  "relationships": [
    {
      "destination": "7312727215421241448",
      "source": "14968215483680013344",
      "type": "dependency"
    },
    {
      "destination": "7312727215421241448",
      "source": "14106236321067903999",
      "type": "dependency"
    }
  ],
  "using_namespace": "clanguml::t30005"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t30005</data>
  <node id="n0">
   <data key="nd2">A</data>
   <data key="nd1">namespace</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd2">AA</data>
     <data key="nd1">namespace</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n2">
       <data key="nd2">AAA</data>
       <data key="nd1">namespace</data>
       <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <node id="n3">
   <data key="nd2">B</data>
   <data key="nd1">namespace</data>
   <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n4">
     <data key="nd2">BB</data>
     <data key="nd1">namespace</data>
     <graph id="g5" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n5">
       <data key="nd2">BBB</data>
       <data key="nd1">namespace</data>
       <graph id="g6" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <node id="n6">
   <data key="nd2">C</data>
   <data key="nd1">namespace</data>
   <graph id="g7" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n7">
     <data key="nd2">CC</data>
     <data key="nd1">namespace</data>
     <graph id="g8" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n8">
       <data key="nd2">CCC</data>
       <data key="nd1">namespace</data>
       <graph id="g9" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <edge id="e0" source="n5" target="n2">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e1" source="n8" target="n2">
   <data key="ed0">dependency</data>
  </edge>
 </graph>
</graphml>

```
