/*------------------------------------------------------------------------------
* Copyright (C) 2003-2006 Ben van Klinken and the CLucene Team
*
* Distributable under the terms of either the Apache License (Version 2.0) or
* the GNU Lesser General Public License, as specified in the COPYING file.
------------------------------------------------------------------------------*/
#include "CLucene/_ApiHeader.h"

#ifdef _CL_TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if defined(_CL_HAVE_SYS_TIME_H)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#ifdef _CL_HAVE_SYS_TIMEB_H
# include <sys/timeb.h>
#endif

#include "DateTools.h"
#include "CLucene/util/Misc.h"

CL_NS_USE(util)
CL_NS_DEF(document)

#define DATETOOLS_BUFFER_SIZE 30

TCHAR* DateTools::timeToString(const int64_t time, Resolution resolution /*= MILLISECOND_FORMAT*/) {
	TCHAR* buf = _CL_NEWARRAY(TCHAR, DATETOOLS_BUFFER_SIZE);
	timeToString(time, resolution, buf, DATETOOLS_BUFFER_SIZE);
	return buf;
}

void DateTools::timeToString(const int64_t time, Resolution resolution, TCHAR* buf, size_t bufLength) {
	time_t secs = time / 1000;
	tm *ptm = gmtime(&secs);

	char abuf[DATETOOLS_BUFFER_SIZE];

	if (resolution == MILLISECOND_FORMAT) {
		size_t len = strftime(abuf, DATETOOLS_BUFFER_SIZE, "%Y%m%d%H%M%S", ptm);
		uint32_t ms = static_cast<uint32_t>(time % 1000);
		_snprintf(abuf + len, 4, "%03u", ms);
	} else if (resolution == SECOND_FORMAT) {
		strftime(abuf, DATETOOLS_BUFFER_SIZE, "%Y%m%d%H%M%S", ptm);
	} else if (resolution == MINUTE_FORMAT) {
		strftime(abuf, DATETOOLS_BUFFER_SIZE, "%Y%m%d%H%M", ptm);
	} else if (resolution == YEAR_FORMAT) {
		strftime(abuf, DATETOOLS_BUFFER_SIZE, "%Y", ptm);
	} else if (resolution == MONTH_FORMAT) {
		strftime(abuf, DATETOOLS_BUFFER_SIZE, "%Y%m", ptm);
	} else if (resolution == DAY_FORMAT) {
		strftime(abuf, DATETOOLS_BUFFER_SIZE, "%Y%m%d", ptm);
	} else if (resolution == HOUR_FORMAT) {
		strftime(abuf, DATETOOLS_BUFFER_SIZE, "%Y%m%d%H", ptm);
	}

	STRCPY_AtoT(buf,abuf, bufLength);
}


int64_t DateTools::stringToTime(const TCHAR* dateString) {
	int64_t ret = 0;
	tm s_time;
	memset(&s_time, 0, sizeof(s_time));
	s_time.tm_mday=1;
	int32_t ms = 0;

	switch (_tcslen(dateString)) {
		case 4: // YEAR_FORMAT
			{
				s_time.tm_year = _ttoi( dateString ) - 1900;
				break;
			}
		case 6: // MONTH_FORMAT
			{
				TCHAR* tmpDate = STRDUP_TtoT(dateString);
				s_time.tm_mon = _ttoi(&tmpDate[4]) - 1;
				tmpDate[4] = 0;
				s_time.tm_year = _ttoi( tmpDate ) - 1900;
				delete[] tmpDate;
				break;
			}
		case 8: // DAY_FORMAT
			{
				TCHAR* tmpDate = STRDUP_TtoT(dateString);
				s_time.tm_mday = _ttoi(&tmpDate[6]);
				tmpDate[6] = 0;
				s_time.tm_mon = _ttoi(&tmpDate[4]) - 1;
				tmpDate[4] = 0;
				s_time.tm_year = _ttoi( tmpDate ) - 1900;
				delete[] tmpDate;
				break;
			}
		case 10: // HOUR_FORMAT
			{
				TCHAR* tmpDate = STRDUP_TtoT(dateString);
				s_time.tm_hour = _ttoi(&tmpDate[8]);
				tmpDate[8] = 0;
				s_time.tm_mday = _ttoi(&tmpDate[6]);
				tmpDate[6] = 0;
				s_time.tm_mon = _ttoi(&tmpDate[4]) - 1;
				tmpDate[4] = 0;
				s_time.tm_year = _ttoi( tmpDate ) - 1900;
				delete[] tmpDate;
				break;
			}
		case 12: // MINUTE_FORMAT
			{
				TCHAR* tmpDate = STRDUP_TtoT(dateString);
				s_time.tm_min = _ttoi(&tmpDate[10]);
				tmpDate[10] = 0;
				s_time.tm_hour = _ttoi(&tmpDate[8]);
				tmpDate[8] = 0;
				s_time.tm_mday = _ttoi(&tmpDate[6]);
				tmpDate[6] = 0;
				s_time.tm_mon = _ttoi(&tmpDate[4]) - 1;
				tmpDate[4] = 0;
				s_time.tm_year = _ttoi( tmpDate ) - 1900;
				delete[] tmpDate;
				break;
			}
		case 14: // SECOND_FORMAT
			{
				TCHAR* tmpDate = STRDUP_TtoT(dateString);
				s_time.tm_sec = _ttoi(&tmpDate[12]);
				tmpDate[12] = 0;
				s_time.tm_min = _ttoi(&tmpDate[10]);
				tmpDate[10] = 0;
				s_time.tm_hour = _ttoi(&tmpDate[8]);
				tmpDate[8] = 0;
				s_time.tm_mday = _ttoi(&tmpDate[6]);
				tmpDate[6] = 0;
				s_time.tm_mon = _ttoi(&tmpDate[4]) - 1;
				tmpDate[4] = 0;
				s_time.tm_year = _ttoi( tmpDate ) - 1900;
				delete[] tmpDate;
				break;
			}
		case 17: // MILLISECOND_FORMAT
			{
				TCHAR* tmpDate = STRDUP_TtoT(dateString);
				ms = _ttoi(&tmpDate[14]);
				tmpDate[14] = 0;
				s_time.tm_sec = _ttoi(&tmpDate[12]);
				tmpDate[12] = 0;
				s_time.tm_min = _ttoi(&tmpDate[10]);
				tmpDate[10] = 0;
				s_time.tm_hour = _ttoi(&tmpDate[8]);
				tmpDate[8] = 0;
				s_time.tm_mday = _ttoi(&tmpDate[6]);
				tmpDate[6] = 0;
				s_time.tm_mon = _ttoi(&tmpDate[4]) - 1;
				tmpDate[4] = 0;
				s_time.tm_year = _ttoi( tmpDate ) - 1900;
				delete[] tmpDate;
				break;
			}
		default:
			{
				_CLTHROWA(CL_ERR_Parse, "Input is not valid date string");
				break;
			}
	}

	time_t t = mktime(&s_time);
	if (t == -1)
		_CLTHROWA(CL_ERR_Parse, "Input is not valid date string");

	ret = (static_cast<int64_t>(t) * 1000) + ms;

	return ret;
}

DateTools::~DateTools(){
}

CL_NS_END
