/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.GetHelper;
import com.sleepycat.client.PutHelper;
import com.sleepycat.client.SBtreeStats;
import com.sleepycat.client.SCompactConfig;
import com.sleepycat.client.SCompactStats;
import com.sleepycat.client.SCursor;
import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabaseConfig;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseEntryBase;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SDatabaseStats;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.SForeignMultiKeyNullifier;
import com.sleepycat.client.SHashStats;
import com.sleepycat.client.SHeapStats;
import com.sleepycat.client.SJoinConfig;
import com.sleepycat.client.SJoinCursor;
import com.sleepycat.client.SKeyRange;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SMultipleDataEntry;
import com.sleepycat.client.SMultiplePairs;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.SQueueStats;
import com.sleepycat.client.SSecondaryCursor;
import com.sleepycat.client.SSecondaryDatabase;
import com.sleepycat.client.SSequence;
import com.sleepycat.client.SSequenceConfig;
import com.sleepycat.client.SStatsConfig;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.ThriftWrapper;
import com.sleepycat.client.TxnHelper;
import com.sleepycat.thrift.BdbService;
import com.sleepycat.thrift.TCompactResult;
import com.sleepycat.thrift.TCursor;
import com.sleepycat.thrift.TDatabase;
import com.sleepycat.thrift.TDatabaseStatResult;
import com.sleepycat.thrift.TDbGetConfig;
import com.sleepycat.thrift.TDbGetMode;
import com.sleepycat.thrift.TDbPutConfig;
import com.sleepycat.thrift.TDbt;
import com.sleepycat.thrift.TIsolationLevel;
import com.sleepycat.thrift.TJoinCursor;
import com.sleepycat.thrift.TKeyData;
import com.sleepycat.thrift.TKeyDataWithSecondaryKeys;
import com.sleepycat.thrift.TSequence;
import com.sleepycat.thrift.TSequenceConfig;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SDatabase
implements GetHelper,
PutHelper,
TxnHelper,
AutoCloseable {
    protected final TDatabase tDb;
    protected final BdbService.Client client;
    private final SEnvironment env;
    private final String fileName;
    private final String databaseName;
    private final Set<SSecondaryDatabase> secondaries;
    private final Map<SSecondaryDatabase, SForeignMultiKeyNullifier> fkNullifiers;

    protected SDatabase(TDatabase tDatabase, String string, String string2, BdbService.Client client, SEnvironment sEnvironment) {
        this.tDb = tDatabase;
        this.fileName = string;
        this.databaseName = string2;
        this.client = client;
        this.env = sEnvironment;
        this.secondaries = new HashSet<SSecondaryDatabase>();
        this.fkNullifiers = new HashMap<SSecondaryDatabase, SForeignMultiKeyNullifier>();
    }

    TDatabase getThriftObj() {
        return this.tDb;
    }

    void associate(SSecondaryDatabase sSecondaryDatabase) {
        this.secondaries.add(sSecondaryDatabase);
    }

    void disassociate(SSecondaryDatabase sSecondaryDatabase) {
        this.secondaries.remove(sSecondaryDatabase);
    }

    void associateForeign(SSecondaryDatabase sSecondaryDatabase, SForeignMultiKeyNullifier sForeignMultiKeyNullifier) {
        this.fkNullifiers.put(sSecondaryDatabase, sForeignMultiKeyNullifier);
    }

    void disassociateForeign(SSecondaryDatabase sSecondaryDatabase) {
        this.fkNullifiers.remove(sSecondaryDatabase);
    }

    @Override
    public void close() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.closeDatabaseHandle(this.tDb);
            return null;
        });
    }

    public SDatabaseConfig getConfig() throws SDatabaseException {
        return this.remoteCall(() -> new SDatabaseConfig(this.client.getDatabaseConfig(this.tDb)));
    }

    public void setConfig(SDatabaseConfig sDatabaseConfig) throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.setDatabaseConfig(this.tDb, ThriftWrapper.nullSafeGet(sDatabaseConfig));
            return null;
        });
    }

    public String getDatabaseFile() {
        return this.fileName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public SEnvironment getEnvironment() {
        return this.env;
    }

    @Override
    public Set<SSecondaryDatabase> getSecondaryDatabases() {
        return Collections.unmodifiableSet(this.secondaries);
    }

    public ByteOrder getServerByteOrder() {
        return this.getEnvironment().getServerByteOrder();
    }

    public SOperationStatus get(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        if (sDatabaseEntry.getPartial()) {
            throw new IllegalArgumentException("Partial key is not supported.");
        }
        return this.dbGet(sTransaction, sDatabaseEntry, sDatabaseEntryBase, sLockMode, TDbGetMode.DEFAULT);
    }

    public SOperationStatus getSearchBoth(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        if (sDatabaseEntry.getPartial()) {
            throw new IllegalArgumentException("Partial key is not supported.");
        }
        if (sDatabaseEntryBase != null && !(sDatabaseEntryBase instanceof SDatabaseEntry)) {
            throw new IllegalArgumentException("data must be a SDatabaseEntry.");
        }
        return this.dbGet(sTransaction, sDatabaseEntry, sDatabaseEntryBase, sLockMode, TDbGetMode.GET_BOTH);
    }

    public SOperationStatus getSearchRecordNumber(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        return this.dbGet(sTransaction, sDatabaseEntry, sDatabaseEntryBase, sLockMode, TDbGetMode.SET_RECNO);
    }

    private SOperationStatus dbGet(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode, TDbGetMode tDbGetMode) {
        if (!this.isValidType(sDatabaseEntryBase)) {
            throw new IllegalArgumentException("data must be a SDatabaseEntry or SMultipleDataEntry.");
        }
        return this.remoteGet(sDatabaseEntry, sDatabaseEntryBase, tKeyData -> {
            TDbGetConfig tDbGetConfig = this.createConfig(sDatabaseEntryBase, sLockMode).setMode(tDbGetMode);
            return this.client.dbGet(this.tDb, STransaction.nullSafeGet(sTransaction), tKeyData, tDbGetConfig);
        });
    }

    private boolean isValidType(SDatabaseEntryBase sDatabaseEntryBase) {
        return sDatabaseEntryBase == null || sDatabaseEntryBase instanceof SDatabaseEntry || sDatabaseEntryBase instanceof SMultipleDataEntry;
    }

    protected TDbGetConfig createConfig(SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) {
        TDbGetConfig tDbGetConfig = new TDbGetConfig();
        if (sLockMode != null) {
            switch (sLockMode) {
                case READ_COMMITTED: {
                    tDbGetConfig.setIsoLevel(TIsolationLevel.READ_COMMITTED);
                }
                case READ_UNCOMMITTED: {
                    tDbGetConfig.setIsoLevel(TIsolationLevel.READ_UNCOMMITTED);
                }
                case RMW: {
                    tDbGetConfig.setRmw(true);
                }
            }
        }
        if (sDatabaseEntryBase instanceof SMultipleDataEntry) {
            tDbGetConfig.setMultiple(true);
        }
        return tDbGetConfig;
    }

    public SOperationStatus exists(STransaction sTransaction, SDatabaseEntry sDatabaseEntry) throws SDatabaseException {
        return this.remoteCall(() -> SOperationStatus.toBdb(this.client.dbKeyExists(this.tDb, STransaction.nullSafeGet(sTransaction), (TDbt)sDatabaseEntry.getThriftObj())));
    }

    boolean isEmpty(STransaction sTransaction) throws SDatabaseException {
        try (SCursor sCursor = this.openCursor(sTransaction, null);){
            boolean bl = sCursor.getFirst(null, null, null) == SOperationStatus.NOTFOUND;
            return bl;
        }
    }

    public SKeyRange getKeyRange(STransaction sTransaction, SDatabaseEntry sDatabaseEntry) throws SDatabaseException {
        return this.remoteCall(() -> new SKeyRange(this.client.dbKeyRange(this.tDb, STransaction.nullSafeGet(sTransaction), (TDbt)sDatabaseEntry.getThriftObj())));
    }

    public SOperationStatus put(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return this.putSingle(sTransaction, sDatabaseEntry, sDatabaseEntry2, TDbPutConfig.DEFAULT);
    }

    public SOperationStatus putNoDupData(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return this.putSingle(sTransaction, sDatabaseEntry, sDatabaseEntry2, TDbPutConfig.NO_DUP_DATA);
    }

    public SOperationStatus putNoOverwrite(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return this.putSingle(sTransaction, sDatabaseEntry, sDatabaseEntry2, TDbPutConfig.NO_OVERWRITE);
    }

    public SOperationStatus putMultipleKey(STransaction sTransaction, SMultiplePairs sMultiplePairs, boolean bl) throws SDatabaseException {
        return this.dbPut(sTransaction, null, sMultiplePairs.map(this::calculateSKey), bl ? TDbPutConfig.OVERWRITE_DUP : TDbPutConfig.DEFAULT);
    }

    private SOperationStatus putSingle(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, TDbPutConfig tDbPutConfig) throws SDatabaseException {
        return this.dbPut(sTransaction, sDatabaseEntry, Collections.singletonList(this.calculateSKey(sDatabaseEntry, sDatabaseEntry2)), tDbPutConfig);
    }

    private SOperationStatus dbPut(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, List<TKeyDataWithSecondaryKeys> list2, TDbPutConfig tDbPutConfig) throws SDatabaseException {
        if (list2.isEmpty()) {
            return SOperationStatus.SUCCESS;
        }
        return this.remotePut(list2, sDatabaseEntry, list -> this.client.dbPut(this.tDb, STransaction.nullSafeGet(sTransaction), list, tDbPutConfig));
    }

    public SOperationStatus delete(STransaction sTransaction2, SDatabaseEntry sDatabaseEntry) throws SDatabaseException {
        return this.runInSingleTxn(sTransaction2, sTransaction -> {
            this.updatePrimaryData((STransaction)sTransaction, Collections.singletonList(sDatabaseEntry));
            return this.remoteDelete((STransaction)sTransaction, Collections.singletonList(new TKeyData().setKey((TDbt)sDatabaseEntry.getThriftObj())));
        });
    }

    public SOperationStatus deleteMultiple(STransaction sTransaction2, SMultipleDataEntry sMultipleDataEntry) throws SDatabaseException {
        return this.runInSingleTxn(sTransaction2, sTransaction -> {
            this.updatePrimaryData((STransaction)sTransaction, sMultipleDataEntry.map(sDatabaseEntry -> sDatabaseEntry));
            return this.remoteDelete((STransaction)sTransaction, sMultipleDataEntry.map(sDatabaseEntry -> new TKeyData().setKey((TDbt)sDatabaseEntry.getThriftObj())));
        });
    }

    public SOperationStatus deleteMultipleKey(STransaction sTransaction2, SMultiplePairs sMultiplePairs) throws SDatabaseException {
        return this.runInSingleTxn(sTransaction2, sTransaction -> {
            this.updatePrimaryData((STransaction)sTransaction, sMultiplePairs.map((sDatabaseEntry, sDatabaseEntry2) -> sDatabaseEntry));
            return this.remoteDelete((STransaction)sTransaction, sMultiplePairs.map((sDatabaseEntry, sDatabaseEntry2) -> new TKeyData().setKey((TDbt)sDatabaseEntry.getThriftObj()).setData((TDbt)sDatabaseEntry2.getThriftObj())));
        });
    }

    void updatePrimaryData(STransaction sTransaction, List<SDatabaseEntry> list) throws SDatabaseException {
        SCursorConfig sCursorConfig = new SCursorConfig().setBulkCursor(true);
        this.fkNullifiers.keySet().forEach(sSecondaryDatabase -> {
            Map<SDatabaseEntry, SDatabaseEntry> map;
            try (SCursor sCursor = sSecondaryDatabase.openCursor(sTransaction, sCursorConfig);){
                map = this.calculateNullifiedData((SSecondaryCursor)sCursor, list);
            }
            sCursor = sSecondaryDatabase.getPrimaryDatabase().openCursor(sTransaction, new SCursorConfig());
            var7_6 = null;
            try {
                map.forEach(sCursor::putKeyFirst);
            }
            catch (Throwable throwable) {
                var7_6 = throwable;
                throw throwable;
            }
            finally {
                if (sCursor != null) {
                    if (var7_6 != null) {
                        try {
                            sCursor.close();
                        }
                        catch (Throwable throwable) {
                            var7_6.addSuppressed(throwable);
                        }
                    } else {
                        sCursor.close();
                    }
                }
            }
        });
    }

    private Map<SDatabaseEntry, SDatabaseEntry> calculateNullifiedData(SSecondaryCursor sSecondaryCursor, List<SDatabaseEntry> list) throws SDatabaseException {
        SSecondaryDatabase sSecondaryDatabase = sSecondaryCursor.getDatabase();
        HashMap<SDatabaseEntry, SDatabaseEntry> hashMap = new HashMap<SDatabaseEntry, SDatabaseEntry>();
        list.forEach(sDatabaseEntry -> {
            SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
            SDatabaseEntry sDatabaseEntry3 = new SDatabaseEntry();
            SOperationStatus sOperationStatus = sSecondaryCursor.getSearchKey((SDatabaseEntry)sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, SLockMode.RMW);
            while (sOperationStatus == SOperationStatus.SUCCESS) {
                sDatabaseEntry3 = hashMap.getOrDefault(sDatabaseEntry2, sDatabaseEntry3);
                if (this.fkNullifiers.get(sSecondaryDatabase).nullifyForeignKey(sSecondaryDatabase, sDatabaseEntry2, sDatabaseEntry3, (SDatabaseEntry)sDatabaseEntry)) {
                    hashMap.put(sDatabaseEntry2.deepCopy(), sDatabaseEntry3.deepCopy());
                }
                sOperationStatus = sSecondaryCursor.getNextDup((SDatabaseEntry)sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, SLockMode.RMW);
            }
        });
        return hashMap;
    }

    private SOperationStatus remoteDelete(STransaction sTransaction, List<TKeyData> list) throws SDatabaseException {
        return this.remoteCall(() -> SOperationStatus.toBdb(this.client.dbDelete(this.tDb, STransaction.nullSafeGet(sTransaction), list)));
    }

    public SCursor openCursor(STransaction sTransaction, SCursorConfig sCursorConfig) throws SDatabaseException {
        return this.remoteCall(() -> {
            TCursor tCursor = this.client.openCursor(this.tDb, STransaction.nullSafeGet(sTransaction), SCursorConfig.nullSafeGet(sCursorConfig));
            return new SCursor(tCursor, this, sTransaction, this.client);
        });
    }

    public SJoinCursor join(SCursor[] sCursorArray, SJoinConfig sJoinConfig) throws SDatabaseException {
        return this.remoteCall(() -> {
            List list = Arrays.stream(sCursorArray).map(sCursor -> sCursor.tCursor).collect(Collectors.toList());
            TJoinCursor tJoinCursor = this.client.openJoinCursor(this.tDb, list, sJoinConfig == null || !sJoinConfig.getNoSort());
            return new SJoinCursor(tJoinCursor, sJoinConfig, this, this.client);
        });
    }

    public SSequence openSequence(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SSequenceConfig sSequenceConfig) throws SDatabaseException {
        return this.remoteCall(() -> {
            TSequence tSequence = this.client.openSequence(this.tDb, STransaction.nullSafeGet(sTransaction), (TDbt)sDatabaseEntry.getThriftObj(), (TSequenceConfig)sSequenceConfig.getThriftObj());
            return new SSequence(tSequence, this.client, this, sDatabaseEntry);
        });
    }

    public void removeSequence(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, boolean bl, boolean bl2) throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.removeSequence(this.tDb, STransaction.nullSafeGet(sTransaction), (TDbt)sDatabaseEntry.getThriftObj(), bl, bl2);
            return null;
        });
    }

    public SCompactStats compact(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, SCompactConfig sCompactConfig) throws SDatabaseException {
        return this.remoteCall(() -> {
            TCompactResult tCompactResult = this.client.dbCompact(this.tDb, STransaction.nullSafeGet(sTransaction), (TDbt)sDatabaseEntry.getThriftObj(), (TDbt)sDatabaseEntry2.getThriftObj(), SCompactConfig.nullSafeGet(sCompactConfig));
            if (sDatabaseEntry3 != null) {
                sDatabaseEntry3.setDataFromTDbt(tCompactResult.endKey);
            }
            return new SCompactStats(tCompactResult);
        });
    }

    public int truncate(STransaction sTransaction, boolean bl) throws SDatabaseException {
        return this.remoteCall(() -> this.client.dbTruncate(this.tDb, STransaction.nullSafeGet(sTransaction), bl));
    }

    public SDatabaseStats getStats(STransaction sTransaction, SStatsConfig sStatsConfig) throws SDatabaseException {
        return this.remoteCall(() -> {
            TDatabaseStatResult tDatabaseStatResult = this.client.getDatabaseStatistics(this.tDb, STransaction.nullSafeGet(sTransaction), SStatsConfig.nullSafeGet(sStatsConfig).getFast());
            if (tDatabaseStatResult.isSetBtreeStat()) {
                return new SBtreeStats(tDatabaseStatResult.btreeStat);
            }
            if (tDatabaseStatResult.isSetHashStat()) {
                return new SHashStats(tDatabaseStatResult.hashStat);
            }
            if (tDatabaseStatResult.isSetHeapStat()) {
                return new SHeapStats(tDatabaseStatResult.heapStat);
            }
            if (tDatabaseStatResult.isSetQueueStat()) {
                return new SQueueStats(tDatabaseStatResult.queueStat);
            }
            throw new RuntimeException("no stats available.");
        });
    }
}

