/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.STransaction;
import java.io.IOException;
import java.util.function.Function;

interface TxnHelper {
    public SEnvironment getEnvironment();

    default public <V> V runInSingleTxn(STransaction sTransaction, Function<STransaction, V> function) throws SDatabaseException {
        try {
            return (V)this.runInSingleTxnWithIOException(sTransaction, function::apply);
        }
        catch (IOException iOException) {
            if (!1.$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    default public <V> V runInSingleTxnWithIOException(STransaction sTransaction, TransactionOperations<V> transactionOperations) throws IOException, SDatabaseException {
        V v;
        STransaction sTransaction2 = sTransaction;
        if (sTransaction2 == null) {
            sTransaction2 = this.getEnvironment().beginTransaction(null, null);
        }
        try {
            v = transactionOperations.call(sTransaction2);
        }
        catch (IOException | RuntimeException exception) {
            if (sTransaction == null) {
                sTransaction2.abort();
            }
            throw exception;
        }
        if (sTransaction == null) {
            sTransaction2.commit();
        }
        return v;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    @FunctionalInterface
    public static interface TransactionOperations<V> {
        public V call(STransaction var1) throws IOException, SDatabaseException;
    }
}

