/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.serial;

import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.bind.serial.ClassCatalog;
import com.sleepycat.client.util.ClassResolver;
import com.sleepycat.client.util.RuntimeExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;

public class SerialInput
extends ClassResolver.Stream {
    private ClassCatalog classCatalog;

    public SerialInput(InputStream inputStream, ClassCatalog classCatalog) throws IOException {
        this(inputStream, classCatalog, null);
    }

    public SerialInput(InputStream inputStream, ClassCatalog classCatalog, ClassLoader classLoader) throws IOException {
        super(inputStream, classLoader);
        this.classCatalog = classCatalog;
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        try {
            byte by = this.readByte();
            byte[] byArray = new byte[by];
            this.readFully(byArray);
            return this.classCatalog.getClassFormat(byArray);
        }
        catch (SDatabaseException sDatabaseException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(sDatabaseException);
        }
    }
}

