/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleBinding;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;
import com.sleepycat.client.util.UtfOps;

public class StringBinding
extends TupleBinding<String> {
    @Override
    public String entryToObject(TupleInput tupleInput) {
        return tupleInput.readString();
    }

    @Override
    public void objectToEntry(String string, TupleOutput tupleOutput) {
        tupleOutput.writeString(string);
    }

    @Override
    protected TupleOutput getTupleOutput(String string) {
        return StringBinding.sizedOutput(string);
    }

    public static String entryToString(SDatabaseEntry sDatabaseEntry) {
        return StringBinding.entryToInput(sDatabaseEntry).readString();
    }

    public static void stringToEntry(String string, SDatabaseEntry sDatabaseEntry) {
        StringBinding.outputToEntry(StringBinding.sizedOutput(string).writeString(string), sDatabaseEntry);
    }

    private static TupleOutput sizedOutput(String string) {
        int n = string == null ? 1 : UtfOps.getByteLength(string.toCharArray());
        return new TupleOutput(new byte[++n]);
    }
}

