/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;

public class TupleBase<E> {
    private int outputBufferSize = 0;

    public void setTupleBufferSize(int n) {
        this.outputBufferSize = n;
    }

    public int getTupleBufferSize() {
        return this.outputBufferSize;
    }

    protected TupleOutput getTupleOutput(E e) {
        int n = this.getTupleBufferSize();
        if (n != 0) {
            return new TupleOutput(new byte[n]);
        }
        return new TupleOutput();
    }

    public static void outputToEntry(TupleOutput tupleOutput, SDatabaseEntry sDatabaseEntry) {
        sDatabaseEntry.setData(tupleOutput.getBufferBytes(), tupleOutput.getBufferOffset(), tupleOutput.getBufferLength());
    }

    public static void inputToEntry(TupleInput tupleInput, SDatabaseEntry sDatabaseEntry) {
        sDatabaseEntry.setData(tupleInput.getBufferBytes(), tupleInput.getBufferOffset(), tupleInput.getBufferLength());
    }

    public static TupleInput entryToInput(SDatabaseEntry sDatabaseEntry) {
        return new TupleInput(sDatabaseEntry.getData(), sDatabaseEntry.getOffset(), sDatabaseEntry.getSize());
    }

    public static TupleOutput newOutput() {
        return new TupleOutput();
    }

    public static TupleOutput newOutput(byte[] byArray) {
        return new TupleOutput(byArray);
    }
}

