/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.compat;

import com.sleepycat.client.SCursor;
import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseConfig;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SDatabaseType;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.SEnvironmentConfig;
import com.sleepycat.client.SLockDetectMode;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.SSecondaryConfig;
import com.sleepycat.client.SSecondaryCursor;
import com.sleepycat.client.SSecondaryDatabase;
import com.sleepycat.client.STransaction;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;

public class DbCompat {
    public static final boolean CDB = false;
    public static final boolean JOIN = true;
    public static final boolean NESTED_TRANSACTIONS = true;
    public static final boolean INSERTION_ORDERED_DUPLICATES = true;
    public static final boolean SEPARATE_DATABASE_FILES = true;
    public static final boolean MEMORY_SUBSYSTEM = true;
    public static final boolean LOCK_SUBSYSTEM = true;
    public static final boolean HASH_METHOD = true;
    public static final boolean RECNO_METHOD = false;
    public static final boolean QUEUE_METHOD = false;
    public static final boolean BTREE_RECNUM_METHOD = true;
    public static final boolean OPTIONAL_READ_UNCOMMITTED = true;
    public static final boolean SECONDARIES = true;
    public static boolean TRANSACTION_RUNNER_PRINT_STACK_TRACES = true;
    public static final boolean DATABASE_COUNT = false;
    public static final boolean NEW_JE_EXCEPTIONS = false;
    public static final boolean POPULATE_ENFORCES_CONSTRAINTS = false;
    private static boolean fSystemCaseSensitive = true;

    public static ClassLoader getClassLoader(SEnvironment sEnvironment) {
        return null;
    }

    public static boolean getInitializeCache(SEnvironmentConfig sEnvironmentConfig) {
        return sEnvironmentConfig.getInitializeCache();
    }

    public static boolean getInitializeLocking(SEnvironmentConfig sEnvironmentConfig) {
        return sEnvironmentConfig.getInitializeLocking();
    }

    public static boolean getInitializeCDB(SEnvironmentConfig sEnvironmentConfig) {
        return sEnvironmentConfig.getInitializeCDB();
    }

    public static boolean isTypeBtree(SDatabaseConfig sDatabaseConfig) {
        return sDatabaseConfig.getType() == SDatabaseType.BTREE;
    }

    public static boolean isTypeHash(SDatabaseConfig sDatabaseConfig) {
        return sDatabaseConfig.getType() == SDatabaseType.HASH;
    }

    public static boolean isTypeQueue(SDatabaseConfig sDatabaseConfig) {
        return false;
    }

    public static boolean isTypeRecno(SDatabaseConfig sDatabaseConfig) {
        return false;
    }

    public static boolean getBtreeRecordNumbers(SDatabaseConfig sDatabaseConfig) {
        return sDatabaseConfig.getBtreeRecordNumbers();
    }

    public static boolean getReadUncommitted(SDatabaseConfig sDatabaseConfig) {
        return sDatabaseConfig.getReadUncommitted();
    }

    public static boolean getRenumbering(SDatabaseConfig sDatabaseConfig) {
        return sDatabaseConfig.getRenumbering();
    }

    public static boolean getSortedDuplicates(SDatabaseConfig sDatabaseConfig) {
        return sDatabaseConfig.getSortedDuplicates();
    }

    public static boolean getUnsortedDuplicates(SDatabaseConfig sDatabaseConfig) {
        return sDatabaseConfig.getUnsortedDuplicates();
    }

    public static boolean getDeferredWrite(SDatabaseConfig sDatabaseConfig) {
        return false;
    }

    public static SCursorConfig cloneCursorConfig(SCursorConfig sCursorConfig) {
        SCursorConfig sCursorConfig2 = new SCursorConfig();
        sCursorConfig2.setReadCommitted(sCursorConfig.getReadCommitted());
        sCursorConfig2.setReadUncommitted(sCursorConfig.getReadUncommitted());
        return sCursorConfig2;
    }

    public static boolean getWriteCursor(SCursorConfig sCursorConfig) {
        return false;
    }

    public static void setWriteCursor(SCursorConfig sCursorConfig, boolean bl) {
        throw new IllegalStateException("Concurrent Data Store is not supported.");
    }

    public static void setRecordNumber(SDatabaseEntry sDatabaseEntry, int n, ByteOrder byteOrder) {
        sDatabaseEntry.setRecordNumber(n, byteOrder);
    }

    public static int getRecordNumber(SDatabaseEntry sDatabaseEntry, ByteOrder byteOrder) {
        return sDatabaseEntry.getRecordNumber(byteOrder);
    }

    public static String getDatabaseFile(SDatabase sDatabase) throws SDatabaseException {
        return sDatabase.getDatabaseFile();
    }

    public static long getDatabaseCount(SDatabase sDatabase) throws SDatabaseException {
        throw new UnsupportedOperationException();
    }

    public static void syncDeferredWrite(SDatabase sDatabase, boolean bl) throws SDatabaseException {
    }

    public static SOperationStatus getCurrentRecordNumber(SCursor sCursor, SDatabaseEntry sDatabaseEntry, SLockMode sLockMode) throws SDatabaseException {
        return sCursor.getRecordNumber(sDatabaseEntry, sLockMode);
    }

    public static SOperationStatus getSearchRecordNumber(SCursor sCursor, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SLockMode sLockMode) throws SDatabaseException {
        return sCursor.getSearchRecordNumber(sDatabaseEntry, sDatabaseEntry2, sLockMode);
    }

    public static SOperationStatus getSearchRecordNumber(SSecondaryCursor sSecondaryCursor, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, SLockMode sLockMode) throws SDatabaseException {
        return sSecondaryCursor.getSearchRecordNumber(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, sLockMode);
    }

    public static SOperationStatus putAfter(SCursor sCursor, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return sCursor.putAfter(sDatabaseEntry, sDatabaseEntry2);
    }

    public static SOperationStatus putBefore(SCursor sCursor, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return sCursor.putBefore(sDatabaseEntry, sDatabaseEntry2);
    }

    public static STransaction getThreadTransaction(SEnvironment sEnvironment) throws SDatabaseException {
        return null;
    }

    public static void setLockDetectModeOldest(SEnvironmentConfig sEnvironmentConfig) {
        sEnvironmentConfig.setLockDetectMode(SLockDetectMode.OLDEST);
    }

    public static void setTypeBtree(SDatabaseConfig sDatabaseConfig) {
        sDatabaseConfig.setType(SDatabaseType.BTREE);
    }

    public static void setTypeHash(SDatabaseConfig sDatabaseConfig) {
        sDatabaseConfig.setType(SDatabaseType.HASH);
    }

    public static void setBtreeRecordNumbers(SDatabaseConfig sDatabaseConfig, boolean bl) {
        sDatabaseConfig.setBtreeRecordNumbers(bl);
    }

    public static void setReadUncommitted(SDatabaseConfig sDatabaseConfig, boolean bl) {
        sDatabaseConfig.setReadUncommitted(bl);
    }

    public static void setRenumbering(SDatabaseConfig sDatabaseConfig, boolean bl) {
        sDatabaseConfig.setRenumbering(bl);
    }

    public static void setSortedDuplicates(SDatabaseConfig sDatabaseConfig, boolean bl) {
        sDatabaseConfig.setSortedDuplicates(bl);
    }

    public static void setUnsortedDuplicates(SDatabaseConfig sDatabaseConfig, boolean bl) {
        sDatabaseConfig.setUnsortedDuplicates(bl);
    }

    public static void setDeferredWrite(SDatabaseConfig sDatabaseConfig, boolean bl) {
    }

    public static void setRecordLength(SDatabaseConfig sDatabaseConfig, int n) {
        sDatabaseConfig.setRecordLength(n);
    }

    public static void setRecordPad(SDatabaseConfig sDatabaseConfig, int n) {
        sDatabaseConfig.setRecordPad(n);
    }

    public static boolean databaseExists(SEnvironment sEnvironment, String string, String string2) {
        assert (string != null);
        assert (string2 == null);
        try {
            SDatabase sDatabase = sEnvironment.openDatabase(null, string, string2, null);
            sDatabase.close();
            return true;
        }
        catch (SDatabaseException sDatabaseException) {
            throw new RuntimeException(sDatabaseException);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static SDatabase openDatabase(SEnvironment sEnvironment, STransaction sTransaction, String string, String string2, SDatabaseConfig sDatabaseConfig) throws SDatabaseException {
        assert (string != null);
        assert (string2 == null);
        try {
            return sEnvironment.openDatabase(sTransaction, string, string2, sDatabaseConfig);
        }
        catch (SDatabaseException sDatabaseException) {
            if (DbCompat.isFileExistsError(sDatabaseException)) {
                return null;
            }
            throw sDatabaseException;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static SSecondaryDatabase openSecondaryDatabase(SEnvironment sEnvironment, STransaction sTransaction, String string, String string2, SDatabase sDatabase, SSecondaryConfig sSecondaryConfig) throws SDatabaseException {
        assert (string != null);
        assert (string2 == null);
        try {
            return sEnvironment.openSecondaryDatabase(sTransaction, string, string2, sDatabase, sSecondaryConfig);
        }
        catch (SDatabaseException sDatabaseException) {
            if (DbCompat.isFileExistsError(sDatabaseException)) {
                return null;
            }
            throw sDatabaseException;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean truncateDatabase(SEnvironment sEnvironment, STransaction sTransaction, String string, String string2) throws SDatabaseException {
        SDatabase sDatabase;
        assert (string != null);
        assert (string2 == null);
        try {
            sDatabase = sEnvironment.openDatabase(sTransaction, string, string2, null);
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            sDatabase.truncate(sTransaction, false);
            boolean bl = true;
            return bl;
        }
        finally {
            sDatabase.close();
        }
    }

    public static boolean removeDatabase(SEnvironment sEnvironment, STransaction sTransaction, String string, String string2) throws SDatabaseException {
        assert (string != null);
        assert (string2 == null);
        try {
            sEnvironment.removeDatabase(sTransaction, string, string2, false);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean renameDatabase(SEnvironment sEnvironment, STransaction sTransaction, String string, String string2, String string3, String string4) throws SDatabaseException {
        assert (string != null);
        assert (string3 != null);
        assert (string2 == null);
        assert (string4 == null);
        try {
            File file = new File(string);
            File file2 = new File(string3);
            if (!file.equals(file2)) {
                sEnvironment.renameDatabase(sTransaction, string, null, string3, false);
            }
            if (string2 != null && !string2.equals(string4)) {
                sEnvironment.renameDatabase(sTransaction, string3, string2, string4, false);
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static SDatabase testOpenDatabase(SEnvironment sEnvironment, STransaction sTransaction, String string, String string2, SDatabaseConfig sDatabaseConfig) throws SDatabaseException {
        assert (string != null);
        assert (string2 == null);
        try {
            return sEnvironment.openDatabase(sTransaction, string, string2, sDatabaseConfig);
        }
        catch (SDatabaseException sDatabaseException) {
            if (DbCompat.isFileExistsError(sDatabaseException)) {
                assert (false);
                return null;
            }
            throw sDatabaseException;
        }
        catch (IOException iOException) {
            assert (false);
            return null;
        }
    }

    public static SSecondaryDatabase testOpenSecondaryDatabase(SEnvironment sEnvironment, STransaction sTransaction, String string, String string2, SDatabase sDatabase, SSecondaryConfig sSecondaryConfig) throws SDatabaseException {
        assert (string != null);
        assert (string2 == null);
        try {
            return sEnvironment.openSecondaryDatabase(sTransaction, string, string2, sDatabase, sSecondaryConfig);
        }
        catch (SDatabaseException sDatabaseException) {
            if (DbCompat.isFileExistsError(sDatabaseException)) {
                assert (false);
                return null;
            }
            throw sDatabaseException;
        }
        catch (IOException iOException) {
            assert (false);
            return null;
        }
    }

    private static boolean isFileExistsError(SDatabaseException sDatabaseException) {
        return sDatabaseException.getMessage().contains("File exists") || sDatabaseException.getMessage().contains("Do not specify an existing file");
    }

    public static boolean isDalvik() {
        return false;
    }

    public static boolean setImportunate(STransaction sTransaction, boolean bl) {
        return false;
    }

    public static RuntimeException unexpectedException(Exception exception) {
        if (!(exception instanceof SDatabaseException)) {
            exception = new SDatabaseException(exception);
        }
        throw new RuntimeException(new SDatabaseException(exception));
    }

    public static RuntimeException unexpectedException(String string, Exception exception) {
        if (!(exception instanceof SDatabaseException)) {
            exception = new SDatabaseException(exception);
        }
        throw new RuntimeException(new SDatabaseException(exception));
    }

    public static RuntimeException unexpectedState(String string) {
        throw new RuntimeException(new SDatabaseException(string));
    }

    public static RuntimeException unexpectedState() {
        throw new RuntimeException();
    }

    public static boolean hasCaseInsensitiveOnDiskDbFile() {
        return !fSystemCaseSensitive;
    }

    public static void enableDeadlockDetection(SEnvironmentConfig sEnvironmentConfig, boolean bl) {
        sEnvironmentConfig.setLockDetectMode(SLockDetectMode.MAX_WRITE);
    }

    static {
        File file = new File("no_such_file");
        File file2 = new File("NO_SUCH_FILE");
        fSystemCaseSensitive = !file.equals(file2);
    }

    public static class OpWriteOptions {
        public static final OpWriteOptions EMPTY = new OpWriteOptions();

        private OpWriteOptions() {
        }
    }

    public static class OpReadOptions {
        public static final OpReadOptions EMPTY = new OpReadOptions(null);
        private SLockMode lockMode;

        private OpReadOptions(SLockMode sLockMode) {
            this.lockMode = sLockMode;
        }

        public SLockMode getLockMode() {
            return this.lockMode;
        }

        public static OpReadOptions make(SLockMode sLockMode) {
            return sLockMode != null ? new OpReadOptions(sLockMode) : EMPTY;
        }
    }

    public static class OpResult {
        public static final OpResult SUCCESS = new OpResult(SOperationStatus.SUCCESS);
        public static final OpResult FAILURE = new OpResult(SOperationStatus.NOTFOUND);
        private SOperationStatus status;

        private OpResult(SOperationStatus sOperationStatus) {
            this.status = sOperationStatus;
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }

        public SOperationStatus status() {
            return this.status;
        }

        public static OpResult make(SOperationStatus sOperationStatus) {
            return sOperationStatus == SOperationStatus.SUCCESS ? SUCCESS : FAILURE;
        }
    }
}

