/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist;

import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.SSecondaryCursor;
import com.sleepycat.client.SSecondaryDatabase;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.bind.EntityBinding;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.collections.StoredSortedMap;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.BasicIndex;
import com.sleepycat.client.persist.EntityCursor;
import com.sleepycat.client.persist.EntityIndex;
import com.sleepycat.client.persist.PrimaryIndex;
import com.sleepycat.client.persist.PrimaryKeyValueAdapter;
import com.sleepycat.client.persist.SecondaryIndex;
import com.sleepycat.client.persist.SubIndexCursor;
import com.sleepycat.client.persist.ValueAdapter;
import com.sleepycat.client.util.keyrange.KeyRange;
import com.sleepycat.client.util.keyrange.RangeCursor;
import java.util.Map;
import java.util.SortedMap;

class SubIndex<PK, E>
implements EntityIndex<PK, E> {
    private SecondaryIndex<?, PK, E> secIndex;
    private SSecondaryDatabase db;
    private boolean transactional;
    private boolean sortedDups;
    private boolean locking;
    private boolean concurrentDB;
    private SDatabaseEntry keyEntry;
    private Object keyObject;
    private KeyRange singleKeyRange;
    private EntryBinding pkeyBinding;
    private KeyRange emptyPKeyRange;
    private EntityBinding entityBinding;
    private ValueAdapter<PK> keyAdapter;
    private ValueAdapter<E> entityAdapter;
    private SortedMap<PK, E> map;

    <SK> SubIndex(SecondaryIndex<SK, PK, E> secondaryIndex, EntityBinding entityBinding, SK SK) throws SDatabaseException {
        this.secIndex = secondaryIndex;
        this.db = secondaryIndex.getDatabase();
        this.transactional = secondaryIndex.transactional;
        this.sortedDups = secondaryIndex.sortedDups;
        this.locking = DbCompat.getInitializeLocking(this.db.getEnvironment().getConfig());
        SEnvironment sEnvironment = this.db.getEnvironment();
        this.concurrentDB = DbCompat.getInitializeCDB(sEnvironment.getConfig());
        this.keyObject = SK;
        this.keyEntry = new SDatabaseEntry();
        secondaryIndex.keyBinding.objectToEntry(SK, this.keyEntry);
        this.singleKeyRange = secondaryIndex.emptyRange.subRange(this.keyEntry);
        PrimaryIndex<PK, E> primaryIndex = secondaryIndex.getPrimaryIndex();
        this.pkeyBinding = primaryIndex.keyBinding;
        this.emptyPKeyRange = primaryIndex.emptyRange;
        this.entityBinding = entityBinding;
        this.keyAdapter = new PrimaryKeyValueAdapter<PK>(primaryIndex.keyClass, primaryIndex.keyBinding);
        this.entityAdapter = secondaryIndex.entityAdapter;
    }

    @Override
    public SDatabase getDatabase() {
        return this.db;
    }

    @Override
    public boolean contains(PK PK) throws SDatabaseException {
        return this.contains((STransaction)null, PK, (SLockMode)null);
    }

    @Override
    public boolean contains(STransaction sTransaction, PK PK, SLockMode sLockMode) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry2 = BasicIndex.NO_RETURN_ENTRY;
        this.pkeyBinding.objectToEntry(PK, sDatabaseEntry);
        SOperationStatus sOperationStatus = this.db.getSearchBoth(sTransaction, this.keyEntry, sDatabaseEntry, sDatabaseEntry2, sLockMode);
        return sOperationStatus == SOperationStatus.SUCCESS;
    }

    @Override
    public E get(PK PK) throws SDatabaseException {
        return this.get((STransaction)null, PK, (SLockMode)null);
    }

    @Override
    public E get(STransaction sTransaction, PK PK, SLockMode sLockMode) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
        this.pkeyBinding.objectToEntry(PK, sDatabaseEntry);
        SOperationStatus sOperationStatus = this.db.getSearchBoth(sTransaction, this.keyEntry, sDatabaseEntry, sDatabaseEntry2, sLockMode);
        if (sOperationStatus == SOperationStatus.SUCCESS) {
            return this.entityBinding.entryToObject(sDatabaseEntry, sDatabaseEntry2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() throws SDatabaseException {
        SCursorConfig sCursorConfig = this.locking ? SCursorConfig.READ_UNCOMMITTED : null;
        try (EntityCursor<PK> entityCursor = this.keys(null, sCursorConfig);){
            if (entityCursor.next() != null) {
                long l = entityCursor.count();
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    @Override
    public boolean delete(PK PK) throws SDatabaseException {
        return this.delete((STransaction)null, PK);
    }

    @Override
    public boolean delete(STransaction sTransaction, PK PK) throws SDatabaseException {
        return this.deleteInternal(sTransaction, PK, DbCompat.OpWriteOptions.EMPTY).isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbCompat.OpResult deleteInternal(STransaction sTransaction, PK PK, DbCompat.OpWriteOptions opWriteOptions) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry2 = BasicIndex.NO_RETURN_ENTRY;
        this.pkeyBinding.objectToEntry(PK, sDatabaseEntry);
        boolean bl = false;
        SEnvironment sEnvironment = this.db.getEnvironment();
        if (this.transactional && sTransaction == null && DbCompat.getThreadTransaction(sEnvironment) == null) {
            sTransaction = sEnvironment.beginTransaction(null, this.secIndex.getAutoCommitTransactionConfig());
            bl = true;
        }
        boolean bl2 = true;
        SCursorConfig sCursorConfig = null;
        if (this.concurrentDB) {
            sCursorConfig = new SCursorConfig();
            DbCompat.setWriteCursor(sCursorConfig, true);
        }
        SSecondaryCursor sSecondaryCursor = this.db.openCursor(sTransaction, sCursorConfig);
        try {
            SOperationStatus sOperationStatus = sSecondaryCursor.getSearchBoth(this.keyEntry, sDatabaseEntry, sDatabaseEntry2, this.locking ? SLockMode.RMW : null);
            if (sOperationStatus == SOperationStatus.SUCCESS) {
                sOperationStatus = sSecondaryCursor.delete();
            }
            bl2 = false;
            DbCompat.OpResult opResult = DbCompat.OpResult.make(sOperationStatus);
            return opResult;
        }
        finally {
            sSecondaryCursor.close();
            if (bl) {
                if (bl2) {
                    sTransaction.abort();
                } else {
                    sTransaction.commit();
                }
            }
        }
    }

    @Override
    public EntityCursor<PK> keys() throws SDatabaseException {
        return this.keys(null, null);
    }

    @Override
    public EntityCursor<PK> keys(STransaction sTransaction, SCursorConfig sCursorConfig) throws SDatabaseException {
        return this.cursor(sTransaction, null, this.keyAdapter, sCursorConfig);
    }

    @Override
    public EntityCursor<E> entities() throws SDatabaseException {
        return this.cursor(null, null, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(STransaction sTransaction, SCursorConfig sCursorConfig) throws SDatabaseException {
        return this.cursor(sTransaction, null, this.entityAdapter, sCursorConfig);
    }

    @Override
    public EntityCursor<PK> keys(PK PK, boolean bl, PK PK2, boolean bl2) throws SDatabaseException {
        return this.cursor(null, PK, bl, PK2, bl2, this.keyAdapter, null);
    }

    @Override
    public EntityCursor<PK> keys(STransaction sTransaction, PK PK, boolean bl, PK PK2, boolean bl2, SCursorConfig sCursorConfig) throws SDatabaseException {
        return this.cursor(sTransaction, PK, bl, PK2, bl2, this.keyAdapter, sCursorConfig);
    }

    @Override
    public EntityCursor<E> entities(PK PK, boolean bl, PK PK2, boolean bl2) throws SDatabaseException {
        return this.cursor(null, PK, bl, PK2, bl2, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(STransaction sTransaction, PK PK, boolean bl, PK PK2, boolean bl2, SCursorConfig sCursorConfig) throws SDatabaseException {
        return this.cursor(sTransaction, PK, bl, PK2, bl2, this.entityAdapter, sCursorConfig);
    }

    private <V> EntityCursor<V> cursor(STransaction sTransaction, PK PK, boolean bl, PK PK2, boolean bl2, ValueAdapter<V> valueAdapter, SCursorConfig sCursorConfig) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = null;
        if (PK != null) {
            sDatabaseEntry = new SDatabaseEntry();
            this.pkeyBinding.objectToEntry(PK, sDatabaseEntry);
        }
        SDatabaseEntry sDatabaseEntry2 = null;
        if (PK2 != null) {
            sDatabaseEntry2 = new SDatabaseEntry();
            this.pkeyBinding.objectToEntry(PK2, sDatabaseEntry2);
        }
        KeyRange keyRange = this.emptyPKeyRange.subRange(sDatabaseEntry, bl, sDatabaseEntry2, bl2);
        return this.cursor(sTransaction, keyRange, valueAdapter, sCursorConfig);
    }

    private <V> EntityCursor<V> cursor(STransaction sTransaction, KeyRange keyRange, ValueAdapter<V> valueAdapter, SCursorConfig sCursorConfig) throws SDatabaseException {
        SSecondaryCursor sSecondaryCursor = this.db.openCursor(sTransaction, sCursorConfig);
        RangeCursor rangeCursor = new RangeCursor(this.singleKeyRange, keyRange, this.sortedDups, sSecondaryCursor);
        return new SubIndexCursor<V>(rangeCursor, valueAdapter);
    }

    @Override
    public Map<PK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<PK, E> sortedMap() {
        if (this.map == null) {
            this.map = (SortedMap)((StoredSortedMap)this.secIndex.sortedMap()).duplicatesMap(this.keyObject, this.pkeyBinding);
        }
        return this.map;
    }
}

