/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.impl.Catalog;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.SimpleFormat;
import com.sleepycat.client.persist.raw.RawObject;
import com.sleepycat.client.util.ClassResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class SimpleCatalog
implements Catalog {
    private static final Map<String, Class> keywordToPrimitive = new HashMap<String, Class>(8);
    private static final Map<Class, Class> primitiveTypeToWrapper;
    private static final SimpleCatalog instance;
    private final ClassLoader classLoader;
    private final List<SimpleFormat> formatList;
    private final Map<String, SimpleFormat> formatMap;

    static boolean isSimpleType(Class clazz) {
        return SimpleCatalog.instance.formatMap.containsKey(clazz.getName());
    }

    static Class primitiveToWrapper(Class clazz) {
        Class clazz2 = primitiveTypeToWrapper.get(clazz);
        if (clazz2 == null) {
            throw DbCompat.unexpectedState(clazz.getName());
        }
        return clazz2;
    }

    public static Class resolveClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = keywordToPrimitive.get(string);
        if (clazz == null) {
            clazz = ClassResolver.resolveClass(string, classLoader);
        }
        return clazz;
    }

    public static Class resolveKeyClass(String string, ClassLoader classLoader) {
        Class clazz = keywordToPrimitive.get(string);
        if (clazz != null) {
            clazz = primitiveTypeToWrapper.get(clazz);
        } else {
            try {
                clazz = ClassResolver.resolveClass(string, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Key class not found: " + string);
            }
        }
        return clazz;
    }

    public static String keyClassName(String string) {
        Class clazz = keywordToPrimitive.get(string);
        if (clazz != null) {
            clazz = primitiveTypeToWrapper.get(clazz);
            return clazz.getName();
        }
        return string;
    }

    static List<Format> getAllSimpleFormats(ClassLoader classLoader) {
        return new ArrayList<Format>(new SimpleCatalog((ClassLoader)classLoader).formatList);
    }

    static boolean addMissingSimpleFormats(ClassLoader classLoader, List<Format> list) {
        boolean bl = false;
        SimpleCatalog simpleCatalog = null;
        for (int i = 0; i <= 30; ++i) {
            Format format = SimpleCatalog.instance.formatList.get(i);
            Format format2 = list.get(i);
            if (format == null || format2 != null) continue;
            assert (format.getWrapperFormat() == null);
            if (simpleCatalog == null) {
                simpleCatalog = new SimpleCatalog(classLoader);
            }
            list.set(i, simpleCatalog.formatList.get(i));
            bl = true;
        }
        return bl;
    }

    SimpleCatalog(ClassLoader classLoader) {
        this.classLoader = classLoader;
        int n = 60;
        this.formatList = new ArrayList<SimpleFormat>(n);
        this.formatMap = new HashMap<String, SimpleFormat>(n);
        for (int i = 0; i <= 30; ++i) {
            this.formatList.add(null);
        }
        this.setFormat(2, new SimpleFormat.FBool((Catalog)this, true));
        this.setFormat(3, new SimpleFormat.FBool((Catalog)this, false));
        this.setFormat(4, new SimpleFormat.FByte((Catalog)this, true));
        this.setFormat(5, new SimpleFormat.FByte((Catalog)this, false));
        this.setFormat(6, new SimpleFormat.FShort((Catalog)this, true));
        this.setFormat(7, new SimpleFormat.FShort((Catalog)this, false));
        this.setFormat(8, new SimpleFormat.FInt((Catalog)this, true));
        this.setFormat(9, new SimpleFormat.FInt((Catalog)this, false));
        this.setFormat(10, new SimpleFormat.FLong((Catalog)this, true));
        this.setFormat(11, new SimpleFormat.FLong((Catalog)this, false));
        this.setFormat(12, new SimpleFormat.FFloat((Catalog)this, true));
        this.setFormat(13, new SimpleFormat.FFloat((Catalog)this, false));
        this.setFormat(14, new SimpleFormat.FDouble((Catalog)this, true));
        this.setFormat(15, new SimpleFormat.FDouble((Catalog)this, false));
        this.setFormat(16, new SimpleFormat.FChar((Catalog)this, true));
        this.setFormat(17, new SimpleFormat.FChar((Catalog)this, false));
        this.setFormat(18, new SimpleFormat.FString(this));
        this.setFormat(19, new SimpleFormat.FBigInt(this));
        this.setFormat(20, new SimpleFormat.FBigDec(this));
        this.setFormat(21, new SimpleFormat.FDate(this));
        this.setWrapper(2, 3);
        this.setWrapper(4, 5);
        this.setWrapper(6, 7);
        this.setWrapper(8, 9);
        this.setWrapper(10, 11);
        this.setWrapper(12, 13);
        this.setWrapper(14, 15);
        this.setWrapper(16, 17);
    }

    private void setFormat(int n, SimpleFormat simpleFormat) {
        simpleFormat.setId(n);
        simpleFormat.initializeIfNeeded(this, null);
        this.formatList.set(n, simpleFormat);
        this.formatMap.put(simpleFormat.getClassName(), simpleFormat);
    }

    private void setWrapper(int n, int n2) {
        SimpleFormat simpleFormat = this.formatList.get(n);
        SimpleFormat simpleFormat2 = this.formatList.get(n2);
        simpleFormat.setWrapperFormat(simpleFormat2);
    }

    @Override
    public int getInitVersion(Format format, boolean bl) {
        return 1;
    }

    @Override
    public Format getFormat(int n, boolean bl) {
        try {
            Format format = this.formatList.get(n);
            if (format == null) {
                throw DbCompat.unexpectedState("Not a simple type: " + n);
            }
            return format;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw DbCompat.unexpectedState("Not a simple type: " + n);
        }
    }

    @Override
    public Format getFormat(Class clazz, boolean bl) {
        Format format = this.formatMap.get(clazz.getName());
        if (format == null) {
            throw new IllegalArgumentException("Not a simple type: " + clazz.getName());
        }
        return format;
    }

    @Override
    public Format getFormat(String string) {
        return this.formatMap.get(string);
    }

    @Override
    public Format createFormat(String string, Map<String, Format> map) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public Format createFormat(Class clazz, Map<String, Format> map) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public boolean isRawAccess() {
        return false;
    }

    @Override
    public Object convertRawObject(RawObject rawObject, IdentityHashMap identityHashMap) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public Class resolveClass(String string) throws ClassNotFoundException {
        return SimpleCatalog.resolveClass(string, this.classLoader);
    }

    @Override
    public Class resolveKeyClass(String string) {
        return SimpleCatalog.resolveKeyClass(string, this.classLoader);
    }

    public static boolean allowRegisterProxy(Class clazz) {
        return !SimpleCatalog.isSimpleType(clazz);
    }

    static {
        keywordToPrimitive.put("boolean", Boolean.TYPE);
        keywordToPrimitive.put("char", Character.TYPE);
        keywordToPrimitive.put("byte", Byte.TYPE);
        keywordToPrimitive.put("short", Short.TYPE);
        keywordToPrimitive.put("int", Integer.TYPE);
        keywordToPrimitive.put("long", Long.TYPE);
        keywordToPrimitive.put("float", Float.TYPE);
        keywordToPrimitive.put("double", Double.TYPE);
        primitiveTypeToWrapper = new HashMap<Class, Class>(8);
        primitiveTypeToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveTypeToWrapper.put(Character.TYPE, Character.class);
        primitiveTypeToWrapper.put(Byte.TYPE, Byte.class);
        primitiveTypeToWrapper.put(Short.TYPE, Short.class);
        primitiveTypeToWrapper.put(Integer.TYPE, Integer.class);
        primitiveTypeToWrapper.put(Long.TYPE, Long.class);
        primitiveTypeToWrapper.put(Float.TYPE, Float.class);
        primitiveTypeToWrapper.put(Double.TYPE, Double.class);
        instance = new SimpleCatalog(null);
    }
}

