/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.raw;

import com.sleepycat.client.persist.raw.RawType;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;

public class RawObject {
    private static final String INDENT = "  ";
    private RawType type;
    private Map<String, Object> values;
    private Object[] elements;
    private String enumConstant;
    private RawObject superObject;

    public RawObject(RawType rawType, Map<String, Object> map, RawObject rawObject) {
        if (rawType == null || map == null) {
            throw new NullPointerException();
        }
        this.type = rawType;
        this.values = map;
        this.superObject = rawObject;
    }

    public RawObject(RawType rawType, Object[] objectArray) {
        if (rawType == null || objectArray == null) {
            throw new NullPointerException();
        }
        this.type = rawType;
        this.elements = objectArray;
    }

    public RawObject(RawType rawType, String string) {
        if (rawType == null || string == null) {
            throw new NullPointerException();
        }
        this.type = rawType;
        this.enumConstant = string;
    }

    public RawType getType() {
        return this.type;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public Object[] getElements() {
        return this.elements;
    }

    public String getEnum() {
        return this.enumConstant;
    }

    public RawObject getSuper() {
        return this.superObject;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RawObject)) {
            return false;
        }
        RawObject rawObject = (RawObject)object;
        if (this.type != rawObject.type) {
            return false;
        }
        if (!Arrays.deepEquals(this.elements, rawObject.elements)) {
            return false;
        }
        if (this.enumConstant != null ? !this.enumConstant.equals(rawObject.enumConstant) : rawObject.enumConstant != null) {
            return false;
        }
        if (this.values != null ? !this.values.equals(rawObject.values) : rawObject.values != null) {
            return false;
        }
        return !(this.superObject != null ? !this.superObject.equals(rawObject.superObject) : rawObject.superObject != null);
    }

    public int hashCode() {
        return System.identityHashCode(this.type) + Arrays.deepHashCode(this.elements) + (this.enumConstant != null ? this.enumConstant.hashCode() : 0) + (this.values != null ? this.values.hashCode() : 0) + (this.superObject != null ? this.superObject.hashCode() : 0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(500);
        this.formatRawObject(stringBuilder, "", null, false);
        return stringBuilder.toString();
    }

    private void formatRawObject(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        if (this.type.isEnum()) {
            stringBuilder.append(string);
            stringBuilder.append("<Enum");
            RawObject.formatId(stringBuilder, string2);
            stringBuilder.append(" class=\"");
            stringBuilder.append(this.type.getClassName());
            stringBuilder.append("\" typeId=\"");
            stringBuilder.append(this.type.getId());
            stringBuilder.append("\">");
            stringBuilder.append(this.enumConstant);
            stringBuilder.append("</Enum>\n");
        } else {
            String string3;
            String string4 = string + INDENT;
            stringBuilder.append(string);
            if (this.type.isArray()) {
                stringBuilder.append("<Array");
                string3 = "</Array>";
            } else if (bl) {
                stringBuilder.append("<Super");
                string3 = "</Super>";
            } else {
                stringBuilder.append("<Object");
                string3 = "</Object>";
            }
            RawObject.formatId(stringBuilder, string2);
            if (this.type.isArray()) {
                stringBuilder.append(" length=\"");
                stringBuilder.append(this.elements.length);
                stringBuilder.append('\"');
            }
            stringBuilder.append(" class=\"");
            stringBuilder.append(this.type.getClassName());
            stringBuilder.append("\" typeId=\"");
            stringBuilder.append(this.type.getId());
            stringBuilder.append("\">\n");
            if (this.superObject != null) {
                this.superObject.formatRawObject(stringBuilder, string4, null, true);
            }
            if (this.type.isArray()) {
                for (int i = 0; i < this.elements.length; ++i) {
                    RawObject.formatValue(stringBuilder, string4, String.valueOf(i), this.elements[i]);
                }
            } else {
                TreeSet<String> treeSet = new TreeSet<String>(this.values.keySet());
                for (String string5 : treeSet) {
                    RawObject.formatValue(stringBuilder, string4, string5, this.values.get(string5));
                }
            }
            stringBuilder.append(string);
            stringBuilder.append(string3);
            stringBuilder.append("\n");
        }
    }

    private static void formatValue(StringBuilder stringBuilder, String string, String string2, Object object) {
        if (object == null) {
            stringBuilder.append(string);
            stringBuilder.append("<Null");
            RawObject.formatId(stringBuilder, string2);
            stringBuilder.append("/>\n");
        } else if (object instanceof RawObject) {
            ((RawObject)object).formatRawObject(stringBuilder, string, string2, false);
        } else {
            stringBuilder.append(string);
            stringBuilder.append("<Value");
            RawObject.formatId(stringBuilder, string2);
            stringBuilder.append(" class=\"");
            stringBuilder.append(object.getClass().getName());
            stringBuilder.append("\">");
            stringBuilder.append(object.toString());
            stringBuilder.append("</Value>\n");
        }
    }

    private static void formatId(StringBuilder stringBuilder, String string) {
        if (string != null) {
            if (Character.isDigit(string.charAt(0))) {
                stringBuilder.append(" index=\"");
            } else {
                stringBuilder.append(" field=\"");
            }
            stringBuilder.append(string);
            stringBuilder.append('\"');
        }
    }
}

