/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.handle;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.Transaction;
import com.sleepycat.server.callbacks.ServerKeyCreator;
import com.sleepycat.server.handle.DatabaseDescriptor;
import com.sleepycat.server.handle.DatabaseKey;
import com.sleepycat.server.handle.EnvironmentDescriptor;
import com.sleepycat.server.util.KeyDataPair;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class SecondaryDatabaseDescriptor
extends DatabaseDescriptor {
    private final DatabaseDescriptor primary;
    private final DatabaseDescriptor foreign;
    private final ServerKeyCreator keyCreator;

    public SecondaryDatabaseDescriptor(SecondaryDatabase secondaryDatabase, DatabaseKey databaseKey, EnvironmentDescriptor environmentDescriptor, DatabaseDescriptor databaseDescriptor, DatabaseDescriptor databaseDescriptor2, ServerKeyCreator serverKeyCreator) {
        super(secondaryDatabase, databaseKey, environmentDescriptor, databaseDescriptor);
        this.primary = databaseDescriptor;
        this.foreign = databaseDescriptor2;
        this.keyCreator = serverKeyCreator;
        this.primary.associate(this);
        if (this.foreign != null) {
            this.foreign.associateForeign(this);
        }
    }

    @Override
    protected void closeBdbHandle() throws DatabaseException {
        try {
            this.keyCreator.close();
        }
        finally {
            this.primary.disassociate(this);
            if (this.foreign != null) {
                this.foreign.disassociateForeign(this);
            }
            super.closeBdbHandle();
        }
    }

    public DatabaseDescriptor getPrimary() {
        return this.primary;
    }

    public void setNewSecondaryKeys(Map<KeyDataPair, List<DatabaseEntry>> map) {
        this.keyCreator.setNewKeys(map);
    }

    public void setCurrentTxn(Transaction transaction) {
        this.keyCreator.setTransaction(transaction);
    }

    @Override
    public void forEachSecondary(Consumer<SecondaryDatabaseDescriptor> consumer) {
        this.getPrimary().forEachSecondary(consumer);
    }

    @Override
    public void forEachForeignSecondary(Consumer<SecondaryDatabaseDescriptor> consumer) {
        this.getPrimary().forEachForeignSecondary(consumer);
    }
}

