/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database.page;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public class DatabaseConsumerPageLoadSettings
extends ActiveWizardPage<DataTransferWizard> {
    private Button transferAutoGeneratedColumns;
    private Button truncateTargetTable;

    public DatabaseConsumerPageLoadSettings() {
        super("Data load");
        this.setTitle("Data load settings");
        this.setDescription("Configuration of table data load");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        final DatabaseConsumerSettings settings = this.getSettings();
        Group loadSettings = UIUtils.createControlGroup((Composite)composite, (String)"Data load", (int)1, (int)768, (int)0);
        this.transferAutoGeneratedColumns = UIUtils.createCheckbox((Composite)loadSettings, (String)"Transfer auto-generated columns", (String)"Transfer values of auto-generated/identity columns.\nIf turned off then such columns will be ignored during transfer.", (boolean)settings.isTransferAutoGeneratedColumns(), (int)1);
        this.transferAutoGeneratedColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setTransferAutoGeneratedColumns(DatabaseConsumerPageLoadSettings.this.transferAutoGeneratedColumns.getSelection());
            }
        });
        this.truncateTargetTable = UIUtils.createCheckbox((Composite)loadSettings, (String)"Truncate target table(s) before load", (boolean)settings.isTruncateBeforeLoad());
        this.truncateTargetTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DatabaseConsumerPageLoadSettings.this.truncateTargetTable.getSelection() && !DatabaseConsumerPageLoadSettings.this.confirmDataTruncate()) {
                    DatabaseConsumerPageLoadSettings.this.truncateTargetTable.setSelection(false);
                    return;
                }
                settings.setTruncateBeforeLoad(DatabaseConsumerPageLoadSettings.this.truncateTargetTable.getSelection());
            }
        });
        Group performanceSettings = UIUtils.createControlGroup((Composite)composite, (String)"Performance", (int)4, (int)768, (int)0);
        final Button newConnectionCheckbox = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_new_connection, null, (boolean)settings.isOpenNewConnections(), (int)4);
        newConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenNewConnections(newConnectionCheckbox.getSelection());
            }
        });
        final Button useTransactionsCheck = UIUtils.createCheckbox((Composite)performanceSettings, (String)"Use transactions", null, (boolean)settings.isUseTransactions(), (int)4);
        useTransactionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setUseTransactions(useTransactionsCheck.getSelection());
            }
        });
        final Spinner commitAfterEdit = UIUtils.createLabelSpinner((Composite)performanceSettings, (String)"Commit after insert of ", (int)settings.getCommitAfterRows(), (int)1, (int)Integer.MAX_VALUE);
        commitAfterEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCommitAfterRows(commitAfterEdit.getSelection());
            }
        });
        commitAfterEdit.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        Group generalSettings = UIUtils.createControlGroup((Composite)composite, (String)"General", (int)4, (int)768, (int)0);
        final Button showTableCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)"Open table editor on finish", null, (boolean)settings.isOpenTableOnFinish(), (int)4);
        showTableCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenTableOnFinish(showTableCheckbox.getSelection());
            }
        });
        final Button showFinalMessageCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)"Show finish message", null, (boolean)((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage(), (int)4);
        showFinalMessageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((DataTransferWizard)DatabaseConsumerPageLoadSettings.this.getWizard()).getSettings().setShowFinalMessage(showFinalMessageCheckbox.getSelection());
            }
        });
        this.setControl((Control)composite);
    }

    private DatabaseConsumerSettings getSettings() {
        return ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
    }

    public void activatePage() {
        this.updatePageCompletion();
        UIUtils.asyncExec(() -> {
            DatabaseConsumerSettings settings = this.getSettings();
            if (settings.isTruncateBeforeLoad() && !this.confirmDataTruncate()) {
                this.truncateTargetTable.setSelection(false);
                settings.setTruncateBeforeLoad(false);
            }
        });
    }

    private boolean confirmDataTruncate() {
        Shell shell = this.getContainer().getShell();
        return !shell.isVisible() && !this.getSettings().isTruncateBeforeLoad() || UIUtils.confirmAction((Shell)shell, (String)"Data truncate attention", (String)"'Truncate target table' option is enabled.\nThis will remove ALL data from target table, it will not be possible to revert this.\nAre you absolutely sure you want to proceed?");
    }

    public void deactivatePage() {
        super.deactivatePage();
    }

    protected boolean determinePageCompletion() {
        return true;
    }
}

