/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterCSV
extends StreamExporterAbstract {
    private static final String PROP_DELIMITER = "delimiter";
    private static final String PROP_HEADER = "header";
    private static final String PROP_QUOTE_CHAR = "quoteChar";
    private static final String PROP_QUOTE_ALWAYS = "quoteAlways";
    private static final String PROP_QUOTE_NEVER = "quoteNever";
    private static final String PROP_NULL_STRING = "nullString";
    private static final String PROP_FORMAT_NUMBERS = "formatNumbers";
    private static final String DEF_QUOTE_CHAR = "\"";
    private String delimiter;
    private char quoteChar = (char)34;
    private boolean useQuotes = true;
    private boolean quoteAlways = true;
    private String rowDelimiter;
    private String nullString;
    private HeaderPosition headerPosition;
    private List<DBDAttributeBinding> columns;
    private final StringBuilder buffer = new StringBuilder();

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        Object nullStringProp;
        String quoteStr;
        super.init(site);
        Map<Object, Object> properties = site.getProperties();
        this.delimiter = StreamTransferUtils.getDelimiterString(properties, PROP_DELIMITER);
        Object quoteProp = properties.get(PROP_QUOTE_CHAR);
        String string = quoteStr = quoteProp == null ? DEF_QUOTE_CHAR : quoteProp.toString();
        if (!CommonUtils.isEmpty((String)quoteStr)) {
            this.quoteChar = quoteStr.charAt(0);
        }
        if (CommonUtils.toBoolean((Object)properties.get(PROP_QUOTE_NEVER))) {
            this.quoteChar = (char)32;
        }
        this.nullString = (nullStringProp = properties.get(PROP_NULL_STRING)) == null ? null : nullStringProp.toString();
        this.useQuotes = this.quoteChar != ' ';
        this.quoteAlways = CommonUtils.toBoolean((Object)properties.get(PROP_QUOTE_ALWAYS));
        this.rowDelimiter = GeneralUtils.getDefaultLineSeparator();
        try {
            this.headerPosition = HeaderPosition.valueOf(String.valueOf(properties.get(PROP_HEADER)));
        }
        catch (Exception exception) {
            this.headerPosition = HeaderPosition.top;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected DBDDisplayFormat getValueExportFormat(DBDAttributeBinding column) {
        if (column.getDataKind() == DBPDataKind.NUMERIC && !Boolean.TRUE.equals(this.getSite().getProperties().get(PROP_FORMAT_NUMBERS))) {
            return DBDDisplayFormat.NATIVE;
        }
        return super.getValueExportFormat(column);
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        if (this.headerPosition == HeaderPosition.top || this.headerPosition == HeaderPosition.both) {
            this.printHeader();
        }
    }

    private void printHeader() {
        int i = 0;
        int columnsSize = this.columns.size();
        while (i < columnsSize) {
            DBDAttributeBinding column = this.columns.get(i);
            String colName = column.getLabel();
            if (CommonUtils.isEmpty((String)colName)) {
                colName = column.getName();
            }
            this.writeCellValue(colName, true);
            if (i < columnsSize - 1) {
                this.writeDelimiter();
            }
            ++i;
        }
        this.writeRowLimit();
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        int i = 0;
        while (i < row.length && i < this.columns.size()) {
            DBDAttributeBinding column = this.columns.get(i);
            if (DBUtils.isNullValue((Object)row[i])) {
                if (!CommonUtils.isEmpty((String)this.nullString)) {
                    this.getWriter().write(this.nullString);
                }
            } else if (row[i] instanceof DBDContent) {
                DBDContent content = (DBDContent)row[i];
                try {
                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) {
                        this.writeCellValue("[NULL]", false);
                    }
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        this.writeCellValue(cs.getContentReader());
                    }
                    this.getSite().writeBinaryData(cs);
                }
                finally {
                    content.release();
                }
            } else {
                String stringValue = super.getValueDisplayString(column, row[i]);
                boolean quote = false;
                if (!stringValue.isEmpty() && !(row[i] instanceof Number) && !(row[i] instanceof Date) && Character.isDigit(stringValue.charAt(0))) {
                    quote = true;
                }
                this.writeCellValue(stringValue, quote);
            }
            if (i < row.length - 1) {
                this.writeDelimiter();
            }
            ++i;
        }
        this.writeRowLimit();
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.headerPosition == HeaderPosition.bottom || this.headerPosition == HeaderPosition.both) {
            this.printHeader();
        }
    }

    private void writeCellValue(String value, boolean quote) {
        boolean hasQuotes;
        if (!this.useQuotes) {
            quote = false;
        }
        boolean bl = hasQuotes = this.useQuotes && value.indexOf(this.quoteChar) != -1;
        if (this.quoteAlways || this.useQuotes && value.isEmpty()) {
            quote = true;
        } else if (!quote && (hasQuotes || value.contains(this.delimiter) || value.indexOf(13) != -1 || value.indexOf(10) != -1 || value.contains(this.rowDelimiter))) {
            quote = true;
        }
        if (quote && hasQuotes) {
            this.buffer.setLength(0);
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c == this.quoteChar) {
                    this.buffer.append(this.quoteChar);
                }
                this.buffer.append(c);
                ++i;
            }
            value = this.buffer.toString();
        }
        PrintWriter out = this.getWriter();
        if (quote && this.useQuotes) {
            out.write(this.quoteChar);
        }
        out.write(value);
        if (quote && this.useQuotes) {
            out.write(this.quoteChar);
        }
    }

    private void writeCellValue(Reader reader) throws IOException {
        try {
            int count;
            PrintWriter out = this.getWriter();
            if (this.useQuotes) {
                out.write(this.quoteChar);
            }
            char[] buffer = new char[2000];
            while ((count = reader.read(buffer)) > 0) {
                int i = 0;
                while (i < count) {
                    if (this.useQuotes && buffer[i] == this.quoteChar) {
                        out.write(this.quoteChar);
                    }
                    out.write(buffer[i]);
                    ++i;
                }
            }
            if (this.useQuotes) {
                out.write(this.quoteChar);
            }
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    private void writeDelimiter() {
        this.getWriter().write(this.delimiter);
    }

    private void writeRowLimit() {
        this.getWriter().write(this.rowDelimiter);
    }

    static enum HeaderPosition {
        none,
        top,
        bottom,
        both;

    }
}

