/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.reader;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.reader.OPBReader2006;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPBReader2007
extends OPBReader2006 {
    private static final long serialVersionUID = 1L;
    protected int nbNewSymbols;
    private final Map<String, IVec<String>> varToProduct = new HashMap<String, IVec<String>>();
    private final Map<String, Map<String, String>> binaryProductToVar = new HashMap<String, Map<String, String>>();

    public OPBReader2007(IPBSolver solver) {
        super(solver);
    }

    @Override
    protected boolean isGoodFirstCharacter(char c) {
        return Character.isLetter(c) || c == '_' || c == '~';
    }

    @Override
    protected void checkId(StringBuffer s) throws ParseFormatException {
        int varID;
        int cpt = 1;
        if (s.charAt(0) == '~') {
            cpt = 2;
        }
        if ((varID = Integer.parseInt(s.substring(cpt))) > this.nbVars) {
            throw new ParseFormatException("Variable identifier larger than #variables in metadata.");
        }
    }

    @Override
    protected void readTerm(StringBuffer coeff, StringBuffer var) throws IOException, ParseFormatException {
        this.readInteger(coeff);
        this.skipSpaces();
        var.setLength(0);
        Vec tmpLit = new Vec();
        StringBuffer tmpVar = new StringBuffer();
        while (this.readIdentifier(tmpVar)) {
            tmpLit = tmpLit.push((Object)tmpVar.toString());
            this.skipSpaces();
        }
        if (tmpLit.size() == 0) {
            throw new ParseFormatException("identifier expected");
        }
        if (tmpLit.size() == 1) {
            var.append((String)tmpLit.last());
            tmpLit.pop();
        } else {
            try {
                var.append(this.linearizeProduct((IVec<String>)tmpLit));
            }
            catch (ContradictionException e) {
                throw new ParseFormatException((Throwable)e);
            }
        }
    }

    protected void literalInAProduct(String var, IVecInt lits) throws ParseFormatException {
        int beginning = var.charAt(0) == '~' ? 2 : 1;
        int id = Integer.parseInt(var.substring(beginning));
        int lid = (var.charAt(0) == '~' ? -1 : 1) * id;
        if (lid == 0 || Math.abs(lid) >= this.nbNewSymbols) {
            throw new ParseFormatException("Wrong variable id");
        }
        lits.push(lid);
    }

    protected void negateLiteralInAProduct(String var, IVecInt lits) {
        int beginning = var.charAt(0) == '~' ? 2 : 1;
        int id = Integer.parseInt(var.substring(beginning));
        int lid = (var.charAt(0) == '~' ? 1 : -1) * id;
        lits.push(lid);
    }

    @Override
    protected void readMetaData() throws IOException, ParseFormatException {
        String[] splitted;
        String rest;
        char c = this.get();
        if (c != '*') {
            throw new ParseFormatException("First line of input file should be a comment");
        }
        String s = this.readWord();
        if (this.eof() || !"#variable=".equals(s)) {
            throw new ParseFormatException("First line should contain #variable= as first keyword");
        }
        this.nbVars = Integer.parseInt(this.readWord());
        this.nbNewSymbols = this.nbVars + 1;
        s = this.readWord();
        if (this.eof() || !"#constraint=".equals(s)) {
            throw new ParseFormatException("First line should contain #constraint= as second keyword");
        }
        this.nbConstr = Integer.parseInt(this.readWord());
        this.charAvailable = false;
        if (!this.eol() && (rest = this.in.readLine()) != null && rest.indexOf("#product=") != -1 && (splitted = rest.trim().split(" "))[0].equals("#product=")) {
            Integer.parseInt(splitted[1]);
        }
        this.metaData(this.nbVars, this.nbConstr);
    }

    @Override
    protected int translateVarToId(String var) throws ParseFormatException {
        int beginning = var.charAt(0) == '~' ? 2 : 1;
        int id = Integer.parseInt(var.substring(beginning));
        if (id == 0 || id >= this.nbNewSymbols) {
            throw new ParseFormatException("Wrong variable id format: " + var);
        }
        return (var.charAt(0) == '~' ? -1 : 1) * id;
    }

    private String linearizeProduct(IVec<String> tmpLit) throws ContradictionException, ParseFormatException {
        tmpLit.sort(String.CASE_INSENSITIVE_ORDER);
        String newVar = this.getProductVariable(tmpLit);
        if (newVar == null) {
            newVar = "X" + this.nbNewSymbols++;
            if (tmpLit.size() == 2) {
                Map<String, String> map1 = this.binaryProductToVar.get(tmpLit.get(0));
                if (map1 == null) {
                    map1 = new HashMap<String, String>();
                    this.binaryProductToVar.put((String)tmpLit.get(0), map1);
                }
                map1.put((String)tmpLit.get(1), newVar);
            }
            this.varToProduct.put(newVar, tmpLit);
            VecInt newLits = new VecInt();
            Iterator iterator = tmpLit.iterator();
            while (iterator.hasNext()) {
                this.negateLiteralInAProduct((String)iterator.next(), (IVecInt)newLits);
            }
            this.literalInAProduct(newVar, (IVecInt)newLits);
            this.solver.addClause((IVecInt)newLits);
            newLits.clear();
            Vec newCoefs = new Vec();
            Iterator iterator2 = tmpLit.iterator();
            while (iterator2.hasNext()) {
                this.literalInAProduct((String)iterator2.next(), (IVecInt)newLits);
                newCoefs.push((Object)BigInteger.ONE);
            }
            this.literalInAProduct(newVar, (IVecInt)newLits);
            newCoefs.push((Object)new BigInteger(String.valueOf(-tmpLit.size())));
            this.solver.addPseudoBoolean((IVecInt)newLits, (IVec<BigInteger>)newCoefs, true, BigInteger.ZERO);
        }
        return newVar;
    }

    private String getProductVariable(IVec<String> lits) {
        if (lits.size() == 2) {
            Map<String, String> map = this.binaryProductToVar.get(lits.get(0));
            if (map == null) {
                return null;
            }
            return map.get(lits.get(1));
        }
        for (Map.Entry<String, IVec<String>> c : this.varToProduct.entrySet()) {
            if (!c.getValue().equals(lits)) continue;
            return c.getKey();
        }
        return null;
    }

    @Override
    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer();
        int[] nArray = model;
        int n = model.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            int p = element;
            if (Math.abs(p) <= this.nbVars) {
                if (p < 0) {
                    stb.append("-x");
                    stb.append(-p);
                } else {
                    stb.append("x");
                    stb.append(p);
                }
                stb.append(" ");
            }
            ++n2;
        }
        return stb.toString();
    }

    @Override
    public void decode(int[] model, PrintWriter out) {
        int[] nArray = model;
        int n = model.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            int p = element;
            if (Math.abs(p) <= this.nbVars) {
                if (element < 0) {
                    out.print("-x");
                    out.print(-p);
                } else {
                    out.print("x");
                    out.print(p);
                }
                out.print(" ");
            }
            ++n2;
        }
    }
}

