/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentLOB;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;

public abstract class OracleContentOpaque<OPAQUE_TYPE>
extends JDBCContentLOB {
    private static final Log log = Log.getLog(OracleContentOpaque.class);
    private OPAQUE_TYPE opaque;
    private InputStream tmpStream;

    public OracleContentOpaque(DBPDataSource dataSource, OPAQUE_TYPE opaque) {
        super(dataSource);
        this.opaque = opaque;
    }

    public long getLOBLength() throws DBCException {
        return 0L;
    }

    @NotNull
    public String getContentType() {
        return "text/xml";
    }

    public DBDContentStorage getContents(DBRProgressMonitor monitor) throws DBCException {
        if (this.storage == null && this.opaque != null) {
            this.storage = this.makeStorageFromOpaque(monitor, this.opaque);
            this.opaque = null;
        }
        return this.storage;
    }

    public void release() {
        if (this.tmpStream != null) {
            ContentUtils.close((Closeable)this.tmpStream);
            this.tmpStream = null;
        }
        super.release();
    }

    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        try {
            if (this.storage != null) {
                preparedStatement.setObject(paramIndex, this.createNewOracleObject(session.getOriginal()));
            } else if (this.opaque != null) {
                preparedStatement.setObject(paramIndex, this.opaque);
            } else {
                preparedStatement.setNull(paramIndex, 2009);
            }
        }
        catch (IOException e) {
            throw new DBCException("IO error while reading content", (Throwable)e);
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)session.getDataSource());
        }
    }

    public boolean isNull() {
        return this.opaque == null && this.storage == null;
    }

    public String getDisplayString(DBDDisplayFormat format) {
        return this.opaque == null && this.storage == null ? null : "[" + this.getOpaqueType() + "]";
    }

    protected abstract String getOpaqueType();

    protected abstract OracleContentOpaque createNewContent();

    protected abstract OPAQUE_TYPE createNewOracleObject(Connection var1) throws DBCException, IOException, SQLException;

    protected abstract DBDContentStorage makeStorageFromOpaque(DBRProgressMonitor var1, OPAQUE_TYPE var2) throws DBCException;
}

