/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public class MySQLView
extends MySQLTableBase
implements DBSView {
    private static final Log log = Log.getLog(MySQLView.class);
    private final AdditionalInfo additionalInfo = new AdditionalInfo();

    public MySQLView(MySQLCatalog catalog) {
        super(catalog);
    }

    public MySQLView(MySQLCatalog catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    public boolean isView() {
        return true;
    }

    public AdditionalInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded) {
                this.loadAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    public List<? extends DBSTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public List<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public List<? extends DBSTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public List<? extends DBSTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    private void loadAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        if (!this.isPersisted() || ((MySQLCatalog)this.getContainer()).isSystem()) {
            this.additionalInfo.loaded = true;
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
                JDBCResultSet dbResult;
                Object var9_18;
                Throwable throwable2;
                JDBCPreparedStatement dbStat;
                Object var6_11;
                Throwable throwable3;
                block52: {
                    throwable3 = null;
                    var6_11 = null;
                    try {
                        dbStat = session.prepareStatement("SELECT CHECK_OPTION,DEFINER,IS_UPDATABLE FROM information_schema.VIEWS WHERE TABLE_SCHEMA=? AND TABLE_NAME=?");
                        try {
                            dbStat.setString(1, ((MySQLCatalog)this.getContainer()).getName());
                            dbStat.setString(2, this.getName());
                            throwable2 = null;
                            var9_18 = null;
                            try {
                                dbResult = dbStat.executeQuery();
                                try {
                                    if (!dbResult.next()) break block52;
                                    try {
                                        this.additionalInfo.setCheckOption(CheckOption.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHECK_OPTION")));
                                    }
                                    catch (IllegalArgumentException e) {
                                        log.warn((Object)e);
                                    }
                                    this.additionalInfo.setDefiner(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFINER"));
                                    this.additionalInfo.setUpdatable("YES".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IS_UPDATABLE")));
                                }
                                finally {
                                    if (dbResult != null) {
                                        dbResult.close();
                                    }
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                        finally {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable3 == null) {
                            throwable3 = throwable5;
                        } else if (throwable3 != throwable5) {
                            throwable3.addSuppressed(throwable5);
                        }
                        throw throwable3;
                    }
                }
                throwable3 = null;
                var6_11 = null;
                try {
                    dbStat = session.prepareStatement("SHOW CREATE VIEW " + this.getFullyQualifiedName(DBPEvaluationContext.DDL));
                    try {
                        throwable2 = null;
                        var9_18 = null;
                        try {
                            dbResult = dbStat.executeQuery();
                            try {
                                if (dbResult.next()) {
                                    int divPos;
                                    String definition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Create View");
                                    if (definition != null && (divPos = definition.indexOf(" VIEW `")) != -1) {
                                        this.additionalInfo.algorithm = this.parseAlgorithm(definition.substring(0, divPos));
                                        definition = "CREATE OR REPLACE " + definition.substring(divPos);
                                    }
                                    this.additionalInfo.setDefinition(SQLFormatUtils.formatSQL((SQLDataSource)((SQLDataSource)this.getDataSource()), (String)definition));
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable3 == null) {
                        throwable3 = throwable7;
                    } else if (throwable3 != throwable7) {
                        throwable3.addSuppressed(throwable7);
                    }
                    throw throwable3;
                }
                this.additionalInfo.loaded = true;
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, this.getDataSource());
        }
    }

    private String parseAlgorithm(String ddl) {
        Matcher matcher = Pattern.compile("ALGORITHM\\s*=\\s*([A-Z_]+) ").matcher(ddl);
        return matcher.find() ? matcher.group(1) : null;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        String definition = this.getAdditionalInfo(monitor).getDefinition();
        if (definition == null && !this.isPersisted()) {
            return "";
        }
        return definition;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.getAdditionalInfo().setDefinition(sourceText);
    }

    public static class AdditionalInfo {
        private volatile boolean loaded = false;
        private String definition;
        private CheckOption checkOption;
        private boolean updatable;
        private String definer;
        public String algorithm;

        public boolean isLoaded() {
            return this.loaded;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        @Property(viewable=true, editable=true, updatable=true, order=4)
        public CheckOption getCheckOption() {
            return this.checkOption;
        }

        public void setCheckOption(CheckOption checkOption) {
            this.checkOption = checkOption;
        }

        @Property(viewable=true, order=5)
        public boolean isUpdatable() {
            return this.updatable;
        }

        public void setUpdatable(boolean updatable) {
            this.updatable = updatable;
        }

        @Property(viewable=true, order=6)
        public String getDefiner() {
            return this.definer;
        }

        public void setDefiner(String definer) {
            this.definer = definer;
        }

        @Property(viewable=true, order=7)
        public String getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }
    }

    public static class AdditionalInfoValidator
    implements IPropertyCacheValidator<MySQLView> {
        public boolean isPropertyCached(MySQLView object, Object propertyId) {
            return object.additionalInfo.loaded;
        }
    }

    public static enum CheckOption {
        NONE(null),
        CASCADE("CASCADED"),
        LOCAL("LOCAL");

        private final String definitionName;

        private CheckOption(String definitionName) {
            this.definitionName = definitionName;
        }

        public String getDefinitionName() {
            return this.definitionName;
        }
    }
}

