/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IntKeyMap;

public class MockDataUtils {
    public static int LONG_PRECISION = String.valueOf(Long.MAX_VALUE).length();
    public static int INTEGER_PRECISION = String.valueOf(Integer.MAX_VALUE).length();
    public static int SHORT_PRECISION = String.valueOf(Short.MAX_VALUE).length();
    public static int BYTE_PRECISION = String.valueOf(127).length();
    private static final Random random = new Random();
    private static IntKeyMap<Integer> degrees = new IntKeyMap();

    public static Object generateNumeric(Integer precision, Integer scale, Double min, Double max) {
        if ((scale == null || scale == 0) && precision != null && precision != 0) {
            if (precision <= BYTE_PRECISION) {
                return (byte)MockDataUtils.randomInteger(MockDataUtils.degree(precision), min, max);
            }
            if (precision <= SHORT_PRECISION) {
                return (short)MockDataUtils.randomInteger(MockDataUtils.degree(precision), min, max);
            }
            if (precision <= INTEGER_PRECISION) {
                return MockDataUtils.randomInteger(MockDataUtils.degree(precision), min, max);
            }
            if (precision <= LONG_PRECISION) {
                return MockDataUtils.getRandomLong(min, max, random);
            }
            return null;
        }
        if (precision != null && precision > 0) {
            int scl = scale != null ? scale : 0;
            StringBuilder sb = new StringBuilder();
            if (precision <= scl) {
                sb.append('0');
            } else {
                sb.append(MockDataUtils.randomInteger(MockDataUtils.degree(precision - scl), 0.0, null));
            }
            if (scl > 0) {
                sb.append('.');
                sb.append(MockDataUtils.randomInteger(MockDataUtils.degree(scl), 0.0, null));
            }
            return new BigDecimal(sb.toString());
        }
        return new BigDecimal(MockDataUtils.getRandomLong(min, max, random));
    }

    public static int getRandomInt(int min, int max, @NotNull Random random) {
        if (min == Integer.MIN_VALUE && max == Integer.MAX_VALUE) {
            return random.nextInt();
        }
        long dif = (long)max - (long)min;
        float number = random.nextFloat();
        return (int)((float)min + number * (float)dif);
    }

    public static double getRandomDouble(double min, double max, @NotNull Random random) {
        double dif = max - min;
        double number = random.nextDouble();
        return min + number * dif;
    }

    private static long getRandomLong(Double min, Double max, Random random) {
        long minimum = Long.MIN_VALUE;
        if (min != null && min > (double)minimum) {
            minimum = Math.round(min);
        }
        long maximum = Long.MAX_VALUE;
        if (max != null && max < (double)maximum) {
            maximum = Math.round(max);
        }
        return MockDataUtils.getRandomLong(minimum, maximum, random);
    }

    public static long getRandomLong(long min, long max, @NotNull Random random) {
        if (min == Long.MIN_VALUE && max == Long.MAX_VALUE) {
            return random.nextLong();
        }
        double dif = (double)max - (double)min;
        double number = random.nextDouble();
        return Math.round((double)min + number * dif);
    }

    public static int degree(int d) {
        Integer value = (Integer)degrees.get(d);
        if (value == null) {
            int result = 10;
            int i = 0;
            while (i < d - 1) {
                result *= 10;
                ++i;
            }
            value = result;
            degrees.put(d, (Object)value);
        }
        return value;
    }

    private static int randomInteger(int bound, Double min, Double max) {
        int minimum = Integer.MIN_VALUE;
        int maximum = Integer.MAX_VALUE;
        if (min != null && min > (double)minimum && min < 2.147483647E9) {
            minimum = (int)Math.round(min);
        }
        if (max == null || max > (double)bound) {
            max = bound;
        }
        if (max < (double)maximum) {
            maximum = (int)Math.round(max);
        }
        return MockDataUtils.getRandomInt(minimum, maximum, random);
    }

    public static UNIQ_TYPE checkUnique(DBRProgressMonitor monitor, DBSEntity dbsEntity, DBSAttributeBase attribute) throws DBException {
        for (DBSEntityConstraint constraint : CommonUtils.safeCollection((Collection)dbsEntity.getConstraints(monitor))) {
            DBSEntityAttributeRef constraintAttribute;
            DBSEntityConstraintType constraintType = constraint.getConstraintType();
            if (!constraintType.isUnique() || (constraintAttribute = DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)constraint), (String)attribute.getName())) == null || constraintAttribute.getAttribute() != attribute) continue;
            List refColumns = ((DBSEntityReferrer)constraint).getAttributeReferences(monitor);
            if (refColumns.size() > 1) {
                return UNIQ_TYPE.MULTI;
            }
            return UNIQ_TYPE.SINGLE;
        }
        return null;
    }

    public static enum UNIQ_TYPE {
        SINGLE,
        MULTI;

    }
}

