/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardListViewer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardGroupContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewConfiguration;
import org.jkiss.utils.CommonUtils;

public class DashboardView
extends ViewPart
implements IDataSourceContainerProvider,
DBPEventListener {
    public static final String VIEW_ID = "org.jkiss.dbeaver.ui.dashboardView";
    private DashboardListViewer dashboardListViewer;
    private DashboardViewConfiguration configuration;
    private int viewNumber;
    private DBPDataSourceContainer dataSourceContainer;

    public DashboardViewConfiguration getConfiguration() {
        return this.configuration;
    }

    public void createPartControl(Composite parent) {
        String secondaryId = this.getViewSite().getSecondaryId();
        if (CommonUtils.isEmpty((String)secondaryId)) {
            throw new IllegalStateException("Dashboard view requires active database connection");
        }
        int divPos = secondaryId.lastIndexOf(58);
        String dataSourceId = divPos == -1 ? secondaryId : secondaryId.substring(0, divPos);
        this.viewNumber = divPos == -1 ? 0 : CommonUtils.toInt((Object)secondaryId.substring(divPos + 1));
        this.dataSourceContainer = DBUtils.findDataSource((String)dataSourceId);
        if (this.dataSourceContainer == null) {
            throw new IllegalStateException("Database connection '" + dataSourceId + "' not found");
        }
        this.dataSourceContainer.getRegistry().addDataSourceListener((DBPEventListener)this);
        this.configuration = new DashboardViewConfiguration(this.dataSourceContainer, secondaryId);
        this.dashboardListViewer = new DashboardListViewer((IWorkbenchSite)this.getSite(), this.dataSourceContainer, this.configuration);
        this.dashboardListViewer.createControl(parent);
        this.dashboardListViewer.createDashboardsFromConfiguration();
        this.getSite().setSelectionProvider((ISelectionProvider)this.dashboardListViewer);
        this.updateStatus();
    }

    public void setFocus() {
        DashboardGroupContainer group;
        List<? extends DashboardContainer> items;
        if (this.dashboardListViewer != null && !(items = (group = this.dashboardListViewer.getDefaultGroup()).getItems()).isEmpty()) {
            group.selectItem(items.get(0));
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void dispose() {
        super.dispose();
        if (this.dashboardListViewer != null) {
            this.dataSourceContainer.getRegistry().removeDataSourceListener((DBPEventListener)this);
            this.dashboardListViewer.dispose();
            this.dashboardListViewer = null;
        }
    }

    public void handleDataSourceEvent(DBPEvent event) {
        if (event.getObject() != this.dataSourceContainer) {
            return;
        }
        switch (event.getAction()) {
            case OBJECT_UPDATE: 
            case OBJECT_REMOVE: {
                UIUtils.asyncExec(this::updateStatus);
            }
        }
    }

    private void updateStatus() {
        UIUtils.asyncExec(() -> this.setPartName(String.valueOf(this.dataSourceContainer.getName()) + (this.dataSourceContainer.isConnected() ? "" : " <off>")));
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    public DashboardListViewer getDashboardListViewer() {
        return this.dashboardListViewer;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return null;
    }
}

