/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLCommandHandlerDescriptor;

public class SQLCommandsRegistry {
    static final String TAG_COMMAND = "command";
    private static SQLCommandsRegistry instance = null;
    private final Map<String, SQLCommandHandlerDescriptor> commandHandlers = new HashMap<String, SQLCommandHandlerDescriptor>();

    public static synchronized SQLCommandsRegistry getInstance() {
        if (instance == null) {
            instance = new SQLCommandsRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SQLCommandsRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlCommand");
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_COMMAND.equals(ext.getName())) {
                SQLCommandHandlerDescriptor commandDescriptor = new SQLCommandHandlerDescriptor(ext);
                this.commandHandlers.put(commandDescriptor.getId(), commandDescriptor);
            }
            ++n2;
        }
    }

    public void dispose() {
        this.commandHandlers.clear();
    }

    public List<SQLCommandHandlerDescriptor> getCommandHandlers() {
        return new ArrayList<SQLCommandHandlerDescriptor>(this.commandHandlers.values());
    }

    public SQLCommandHandlerDescriptor getCommandHandler(String id) {
        return this.commandHandlers.get(id);
    }
}

