/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLVariable;

public class SQLContext
extends DocumentTemplateContext
implements DBPContextProvider {
    private SQLEditorBase editor;
    private Map<String, SQLVariable> variables = new HashMap<String, SQLVariable>();

    public SQLContext(TemplateContextType type, IDocument document, Position position, SQLEditorBase editor) {
        super(type, document, position);
        this.editor = editor;
    }

    public SQLEditorBase getEditor() {
        return this.editor;
    }

    public DBCExecutionContext getExecutionContext() {
        return this.editor.getExecutionContext();
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(TemplateVariableType type, String name, int[] offsets) {
                SQLVariable variable = new SQLVariable(SQLContext.this, type, name, offsets);
                SQLContext.this.variables.put(name, variable);
                return variable;
            }
        };
        TemplateBuffer buffer = translator.translate(template);
        this.formatTemplate(buffer);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    private void formatTemplate(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        String indentation = this.getIndentation();
        String content = buffer.getString();
        if (!indentation.isEmpty() && content.indexOf(10) != -1) {
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (i < content.length()) {
                char c = content.charAt(i);
                result.append(c);
                if (c == '\n') {
                    result.append(indentation);
                }
                ++i;
            }
            buffer.setContent(result.toString(), variables);
        }
    }

    SQLVariable getTemplateVariable(String name) {
        SQLVariable variable = this.variables.get(name);
        if (variable != null && !variable.isResolved()) {
            this.getContextType().resolve((TemplateVariable)variable, (TemplateContext)this);
        }
        return variable;
    }

    Collection<SQLVariable> getVariables() {
        return this.variables.values();
    }

    private String getIndentation() {
        int lineIndent;
        block4: {
            int start = this.getStart();
            IDocument document = this.getDocument();
            IRegion region = document.getLineInformationOfOffset(start);
            lineIndent = start - region.getOffset();
            if (lineIndent > 0) break block4;
            return "";
        }
        try {
            char[] buf = new char[lineIndent];
            int i = 0;
            while (i < lineIndent) {
                buf[i] = 32;
                ++i;
            }
            return String.valueOf(buf);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

