/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.presentation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisTransformUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.gis.GeometryDataUtils;
import org.jkiss.dbeaver.ui.gis.panel.GISLeafletViewer;

public class GeometryPresentation
extends AbstractPresentation {
    private static final Log log = Log.getLog(GeometryPresentation.class);
    private GISLeafletViewer leafletViewer;

    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        this.leafletViewer = new GISLeafletViewer(parent, null, GisTransformUtils.getSpatialDataProvider((DBPDataSource)controller.getDataContainer().getDataSource()));
        this.leafletViewer.getBrowserComposite().setLayoutData((Object)new GridData(1808));
    }

    protected void applyThemeSettings() {
    }

    public Composite getControl() {
        return this.leafletViewer.getBrowser();
    }

    public void formatData(boolean refreshData) {
    }

    public void clearMetaData() {
    }

    public void updateValueView() {
    }

    public void changeMode(boolean recordMode) {
    }

    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
        super.scrollToRow(position);
    }

    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.controller.getModel().getDocumentAttribute();
    }

    @Nullable
    public String copySelectionToString(ResultSetCopySettings settings) {
        return null;
    }

    public ISelection getSelection() {
        return new StructuredSelection();
    }

    public void setSelection(ISelection selection) {
    }

    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        this.controller.updateEditControls();
        List<GeometryDataUtils.GeomAttrs> result = GeometryDataUtils.extractGeometryAttributes(this.getController());
        ResultSetModel model = this.getController().getModel();
        ArrayList<DBGeometry> geometries = new ArrayList<DBGeometry>();
        for (GeometryDataUtils.GeomAttrs geomAttrs : result) {
            for (ResultSetRow row : model.getAllRows()) {
                Object value = model.getCellValue(geomAttrs.geomAttr, row);
                DBGeometry geometry = GisTransformUtils.getGeometryValueFromObject((DBSDataContainer)this.controller.getDataContainer(), (DBDValueHandler)geomAttrs.geomAttr.getValueHandler(), (DBSTypedObject)geomAttrs.geomAttr, (Object)value);
                if (geometry == null) continue;
                geometries.add(geometry);
                if (geomAttrs.descAttrs.isEmpty()) continue;
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                for (DBDAttributeBinding da : geomAttrs.descAttrs) {
                    Object descValue = model.getCellValue(da, row);
                    if (DBUtils.isNullValue((Object)descValue)) continue;
                    properties.put(da.getName(), descValue);
                }
                geometry.setProperties(properties);
            }
        }
        try {
            this.leafletViewer.setGeometryData(geometries.toArray(new DBGeometry[0]));
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error rendering GIS data", "Error while rendering geometry data", (Throwable)e);
        }
    }
}

