/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerProcedure;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;

public class SQLServerProcedureParameter
implements DBSProcedureParameter,
DBSAttributeBase,
DBSObject {
    private SQLServerProcedure procedure;
    private String paramName;
    private int ordinalPosition;
    private SQLServerDataType dataType;
    private int maxLength;
    private int scale;
    private int precision;
    private DBSProcedureParameterKind parameterKind;
    private boolean nullable;
    private String defaultValue;

    public SQLServerProcedureParameter(DBRProgressMonitor monitor, SQLServerProcedure procedure, JDBCResultSet dbResult) throws DBException {
        boolean readonly;
        this.procedure = procedure;
        this.paramName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.ordinalPosition = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"parameter_id");
        int typeID = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"user_type_id");
        this.dataType = ((SQLServerSchema)procedure.getContainer()).getDatabase().getDataTypeByUserTypeId(monitor, typeID);
        boolean isOutput = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_output") != 0;
        boolean isCursor = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_cursor_ref") != 0;
        boolean bl = readonly = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_readonly") != 0;
        this.parameterKind = isCursor ? DBSProcedureParameterKind.RESULTSET : (isOutput ? DBSProcedureParameterKind.OUT : (readonly ? DBSProcedureParameterKind.IN : DBSProcedureParameterKind.INOUT));
        this.maxLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"max_length");
        this.scale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"scale");
        this.precision = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"precision");
        if (JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"has_default_value") != 0) {
            this.defaultValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"default_value");
        }
        this.nullable = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_nullable") != 0;
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)this.procedure.getDataSource();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public SQLServerProcedure getParentObject() {
        return this.procedure;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.paramName;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public SQLServerDataType getParameterType() {
        return this.dataType;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public DBSProcedureParameterKind getParameterKind() {
        return this.parameterKind;
    }

    @Property(viewable=true, order=4)
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public boolean isRequired() {
        return !this.nullable;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    public String getTypeName() {
        return this.dataType.getTypeName();
    }

    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public int getTypeID() {
        return this.dataType.getTypeID();
    }

    public DBPDataKind getDataKind() {
        return this.dataType.getDataKind();
    }

    public Integer getScale() {
        return this.scale;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    @Property(viewable=true, order=5)
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

