/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.CommonUtils;

public class SQLServerView
extends SQLServerTableBase
implements DBSView {
    private static final Log log = Log.getLog(SQLServerView.class);
    private String ddl;

    public SQLServerView(SQLServerSchema schema) {
        super(schema);
    }

    public SQLServerView(DBRProgressMonitor monitor, SQLServerSchema schema, SQLServerView source) throws DBException {
        super(monitor, schema, source);
    }

    public SQLServerView(SQLServerSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    public boolean isView() {
        return true;
    }

    public List<SQLServerTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        List childColumns = ((SQLServerSchema)this.getContainer()).getTableCache().getChildren(monitor, (SQLServerSchema)this.getContainer(), this);
        if (childColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<SQLServerTableColumn> columns = new ArrayList<SQLServerTableColumn>(childColumns);
        columns.sort(DBUtils.orderComparator());
        return columns;
    }

    @Override
    public SQLServerTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (SQLServerTableColumn)((SQLServerSchema)this.getContainer()).getTableCache().getChild(monitor, (SQLServerSchema)this.getContainer(), this, attributeName);
    }

    @Override
    public SQLServerTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull long columnId) throws DBException {
        for (SQLServerTableColumn col : this.getAttributes(monitor)) {
            if (col.getObjectId() != columnId) continue;
            return col;
        }
        log.error((Object)("Column '" + columnId + "' not found in table '" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "'"));
        return null;
    }

    @Override
    @Association
    public Collection<SQLServerTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    @Association
    public Collection<SQLServerTableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Association
    public Collection<SQLServerTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<SQLServerTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public String getDDL() {
        return this.ddl;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (CommonUtils.getOption(options, (String)"refresh")) {
            this.ddl = null;
        }
        if (this.ddl == null) {
            this.ddl = this.isPersisted() ? SQLServerUtils.extractSource(monitor, this.getDatabase(), this.getSchema(), this.getName()) : "CREATE VIEW " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " AS\n";
        }
        return this.ddl;
    }

    public void setObjectDefinitionText(String source) {
        this.ddl = source;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((SQLServerSchema)this.getContainer()).getTableCache().refreshObject(monitor, (SQLServerSchema)this.getContainer(), this);
    }

    public boolean supportsObjectDefinitionOption(String option) {
        return false;
    }
}

