/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.exec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.utils.CommonUtils;

public class DBCStatistics {
    private final long startTime = System.currentTimeMillis();
    private long rowsUpdated;
    private long rowsFetched;
    private long executeTime;
    private long fetchTime;
    private int statementsCount;
    private String queryText;
    private Map<String, Object> infoMap;
    private List<String> messages;

    public long getRowsUpdated() {
        return this.rowsUpdated;
    }

    public void setRowsUpdated(long rowsUpdated) {
        this.rowsUpdated = rowsUpdated;
    }

    public void addRowsUpdated(long rowsUpdated) {
        this.rowsUpdated += rowsUpdated;
    }

    public long getRowsFetched() {
        return this.rowsFetched;
    }

    public void setRowsFetched(long rowsFetched) {
        this.rowsFetched = rowsFetched;
    }

    public long getExecuteTime() {
        return this.executeTime;
    }

    public void setExecuteTime(long executeTime) {
        this.executeTime = executeTime;
    }

    public void addExecuteTime(long executeTime) {
        this.executeTime += executeTime;
    }

    public void addExecuteTime() {
        this.executeTime += System.currentTimeMillis() - this.startTime;
    }

    public long getFetchTime() {
        return this.fetchTime;
    }

    public void setFetchTime(long fetchTime) {
        this.fetchTime = fetchTime;
    }

    public void addFetchTime(long fetchTime) {
        this.fetchTime += fetchTime;
    }

    public long getTotalTime() {
        return this.executeTime + this.fetchTime;
    }

    public int getStatementsCount() {
        return this.statementsCount;
    }

    public void setStatementsCount(int statementsCount) {
        this.statementsCount = statementsCount;
    }

    public void addStatementsCount() {
        ++this.statementsCount;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void addMessage(String message) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
        }
        this.messages.add(message);
    }

    public Map<String, Object> getInfo() {
        if (this.infoMap == null) {
            return Collections.emptyMap();
        }
        return this.infoMap;
    }

    public void addInfo(String name, Object value) {
        if (this.infoMap == null) {
            this.infoMap = new LinkedHashMap<String, Object>();
        }
        this.infoMap.put(name, value);
    }

    public boolean isEmpty() {
        return this.executeTime <= 0L && this.fetchTime <= 0L && this.statementsCount == 0;
    }

    public void accumulate(DBCStatistics stat) {
        this.rowsUpdated += stat.rowsUpdated;
        this.rowsFetched += stat.rowsFetched;
        this.executeTime += stat.executeTime;
        this.fetchTime += stat.fetchTime;
        this.statementsCount += stat.statementsCount;
        if (!CommonUtils.isEmpty(stat.messages)) {
            for (String string : stat.messages) {
                this.addMessage(string);
            }
        }
        if (!CommonUtils.isEmpty(stat.infoMap)) {
            for (Map.Entry entry : stat.infoMap.entrySet()) {
                this.addInfo((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void reset() {
        this.rowsUpdated = 0L;
        this.rowsFetched = 0L;
        this.executeTime = 0L;
        this.fetchTime = 0L;
        this.statementsCount = 0;
        this.messages = null;
        this.infoMap = null;
    }
}

