/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.utils.CommonUtils;

public class DefaultServerOutputReader
implements DBCServerOutputReader {
    @Override
    public boolean isServerOutputEnabled() {
        return true;
    }

    @Override
    public boolean isAsyncOutputReadSupported() {
        return false;
    }

    @Override
    public void readServerOutput(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @Nullable SQLQueryResult queryResult, @Nullable DBCStatement statement, @NotNull PrintWriter output) throws DBCException {
        this.dumpWarnings(output, queryResult.getWarnings());
    }

    protected void dumpWarnings(@NotNull PrintWriter output, List<Throwable> warnings) {
        if (warnings != null && warnings.size() > 0) {
            for (Throwable warning : warnings) {
                String sqlState;
                if (warning instanceof SQLException && !CommonUtils.isEmpty((String)(sqlState = ((SQLException)warning).getSQLState()))) {
                    output.print(String.valueOf(sqlState) + ": ");
                }
                output.println(warning.getMessage());
            }
        }
    }
}

