/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;

public abstract class CreateLinkHandler
extends AbstractHandler {
    static final Path[] NO_TARGETS = new Path[0];

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection structured = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (structured.isEmpty() || !(structured instanceof IStructuredSelection)) {
            return null;
        }
        Object first = ((IStructuredSelection)structured).getFirstElement();
        IResource resource = (IResource)GeneralUtils.adapt((Object)first, IResource.class);
        final IContainer container = this.extractContainer(resource);
        if (container == null) {
            IStatus error = GeneralUtils.makeErrorStatus((String)NLS.bind((String)UINavigatorMessages.CreateLinkHandler_e_create_link_validation, (Object)resource));
            StatusAdapter statusAdapter = new StatusAdapter(error);
            statusAdapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)UINavigatorMessages.CreateLinkHandler_e_create_link_title);
            StatusManager.getManager().handle(statusAdapter, 2);
            return null;
        }
        final Path[] locations = this.selectTargets(event);
        if (locations == null || locations.length == 0) {
            return null;
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IStatus linked = CreateLinkHandler.this.createLink(container, monitor, locations);
                int severity = linked.getSeverity();
                switch (severity) {
                    case 8: {
                        throw new OperationCanceledException(linked.getMessage());
                    }
                    case 4: {
                        throw new CoreException(linked);
                    }
                }
            }
        };
        IRunnableContext context = this.getRunnableContext(event);
        try {
            context.run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            IStatus error = GeneralUtils.makeErrorStatus((String)UINavigatorMessages.CreateLinkHandler_e_create_link_message, (Throwable)e.getTargetException());
            StatusAdapter statusAdapter = new StatusAdapter(error);
            statusAdapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)UINavigatorMessages.CreateLinkHandler_e_create_link_title);
            StatusManager.getManager().handle(statusAdapter, 3);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private IContainer extractContainer(IResource resource) {
        if (resource instanceof IContainer) {
            return (IContainer)resource;
        }
        return null;
    }

    protected abstract Path[] selectTargets(ExecutionEvent var1);

    private IRunnableContext getRunnableContext(ExecutionEvent event) {
        IWorkbenchWindow activeWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (activeWindow != null) {
            return activeWindow;
        }
        return PlatformUI.getWorkbench().getProgressService();
    }

    protected abstract IStatus createLink(IContainer var1, IProgressMonitor var2, Path ... var3);
}

